/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.function;

import ghidra.app.cmd.function.CallDepthChangeInfo;
import ghidra.framework.cmd.Command;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.util.Msg;
import ghidra.util.exception.DuplicateNameException;

public class SetStackDepthChangeCommand
implements Command<Program> {
    private Address address;
    private int stackDepthChange;
    private String errMsg = null;

    public SetStackDepthChangeCommand(Address address, int newStackDepthChange) {
        this.address = address;
        this.stackDepthChange = newStackDepthChange;
    }

    public boolean applyTo(Program program) {
        try {
            CallDepthChangeInfo.setStackDepthChange(program, this.address, this.stackDepthChange);
            return true;
        }
        catch (DuplicateNameException e) {
            this.errMsg = e.getMessage();
            Msg.error((Object)this, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
            return false;
        }
    }

    public String getName() {
        return "Set Stack Depth Change";
    }

    public String getStatusMsg() {
        return this.errMsg;
    }
}

