/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.reloc;

import ghidra.program.model.address.Address;

public class Relocation {
    private Address addr;
    private Status status;
    private int type;
    private long[] values;
    private byte[] bytes;
    private String symbolName;

    public Relocation(Address addr, Status status, int type, long[] values, byte[] bytes, String symbolName) {
        this.addr = addr;
        this.status = status;
        this.type = type;
        this.values = values;
        this.bytes = bytes;
        this.symbolName = symbolName;
    }

    public Address getAddress() {
        return this.addr;
    }

    public Status getStatus() {
        return this.status;
    }

    public int getType() {
        return this.type;
    }

    public long[] getValues() {
        return this.values;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public int getLength() {
        return this.bytes != null ? this.bytes.length : 0;
    }

    public String getSymbolName() {
        return this.symbolName;
    }

    public static enum Status {
        UNKNOWN(0, true),
        SKIPPED(1, false),
        UNSUPPORTED(2, false),
        FAILURE(3, false),
        PARTIAL(4, false),
        APPLIED(5, true),
        APPLIED_OTHER(6, true);

        private int value;
        private boolean hasBytes;

        private Status(int value, boolean hasBytes) {
            this.value = value;
            this.hasBytes = hasBytes;
        }

        public boolean hasBytes() {
            return this.hasBytes;
        }

        public int getValue() {
            return this.value;
        }

        public static Status getStatus(int value) {
            for (Status s : Status.values()) {
                if (s.value != value) continue;
                return s;
            }
            throw new IllegalArgumentException("Undefined Status value: " + value);
        }
    }
}

