/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.references;

import db.DBHandle;
import db.DBRecord;
import db.Field;
import db.LongField;
import db.RecordIterator;
import db.Table;
import db.util.ErrorHandler;
import ghidra.program.database.DBObjectCache;
import ghidra.program.database.ProgramDB;
import ghidra.program.database.map.AddressIndexKeyIterator;
import ghidra.program.database.map.AddressKeyAddressIterator;
import ghidra.program.database.map.AddressMap;
import ghidra.program.database.references.RefList;
import ghidra.program.database.references.RefListV0;
import ghidra.program.database.references.ToAdapter;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.symbol.RefTypeFactory;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.exception.VersionException;
import java.io.IOException;

class ToAdapterSharedTable
extends ToAdapter {
    static final String OLD_REFS_TABLE_NAME = "Memory References";
    static final int OLD_FROM_ADDR_COL = 0;
    static final int OLD_TO_ADDR_COL = 1;
    static final int OLD_OP_INDEX_COL = 2;
    static final int OLD_USER_DEFINED_COL = 3;
    static final int OLD_REF_TYPE_COL = 4;
    static final int OLD_SYMBOL_ID_COL = 5;
    static final int OLD_BASE_ADDR_COL = 6;
    static final int OLD_IS_OFFSET_COL = 7;
    static final int OLD_IS_PRIMARY_COL = 8;
    private Table table;
    private AddressMap addrMap;
    private ErrorHandler errHandler;

    ToAdapterSharedTable(DBHandle handle, AddressMap addrMap, ErrorHandler errHandler) throws VersionException {
        this.addrMap = addrMap.getOldAddressMap();
        this.errHandler = errHandler;
        this.table = handle.getTable(OLD_REFS_TABLE_NAME);
        if (this.table == null) {
            throw new VersionException("Missing Table: Memory References");
        }
        if (this.table.getSchema().getVersion() != 0) {
            throw new VersionException(false);
        }
    }

    @Override
    RefList createRefList(ProgramDB program, DBObjectCache<RefList> cache, Address toAddr) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    RefList getRefList(ProgramDB program, DBObjectCache<RefList> cache, Address to, long toAddr) throws IOException {
        LongField toField = new LongField(toAddr);
        RefListV0 toRefs = new RefListV0(toAddr, this.addrMap, program, cache, false);
        RecordIterator iter = this.table.indexIterator(1, (Field)toField, (Field)toField, true);
        while (iter.hasNext()) {
            DBRecord rec = iter.next();
            boolean isUser = rec.getBooleanValue(3);
            SourceType source = isUser ? SourceType.USER_DEFINED : SourceType.DEFAULT;
            ((RefList)toRefs).addRef(this.addrMap.decodeAddress(rec.getLongValue(0)), to, RefTypeFactory.get((byte)rec.getShortValue(4)), rec.getShortValue(2), rec.getLongValue(5), rec.getBooleanValue(8), source, false, false, 0L);
        }
        if (((RefList)toRefs).isEmpty()) {
            return null;
        }
        return toRefs;
    }

    @Override
    boolean hasRefTo(long toAddr) throws IOException {
        LongField toField = new LongField(toAddr);
        RecordIterator iter = this.table.indexIterator(1, (Field)toField, (Field)toField, true);
        return iter.hasNext();
    }

    @Override
    public DBRecord createRecord(long key, int numRefs, byte refType, byte[] refData) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public DBRecord getRecord(long key) throws IOException {
        return this.table.getRecord(key);
    }

    @Override
    public void putRecord(DBRecord record) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeRecord(long key) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    AddressIterator getToIterator(boolean forward) throws IOException {
        AddressIndexKeyIterator iter = new AddressIndexKeyIterator(this.table, 1, this.addrMap, forward);
        return new AddressKeyAddressIterator(iter, forward, this.addrMap, this.errHandler);
    }

    @Override
    AddressIterator getToIterator(Address startAddr, boolean forward) throws IOException {
        AddressIndexKeyIterator iter = new AddressIndexKeyIterator(this.table, 1, this.addrMap, startAddr, forward);
        return new AddressKeyAddressIterator(iter, forward, this.addrMap, this.errHandler);
    }

    @Override
    AddressIterator getToIterator(AddressSetView set, boolean forward) throws IOException {
        AddressIndexKeyIterator iter = new AddressIndexKeyIterator(this.table, 0, this.addrMap, set, forward);
        return new AddressKeyAddressIterator(iter, forward, this.addrMap, this.errHandler);
    }

    @Override
    AddressIterator getOldNamespaceAddresses(AddressSpace addrSpace) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    int getRecordCount() {
        return this.table.getRecordCount();
    }
}

