/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.type;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordCategory;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.StringParseType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.ClassFieldMsAttributes;

public abstract class AbstractNestedTypeExtMsType
extends AbstractMsType {
    protected ClassFieldMsAttributes attribute;
    protected RecordNumber nestedTypeDefinitionRecordNumber;
    protected String name;

    public AbstractNestedTypeExtMsType(AbstractPdb pdb, PdbByteReader reader, StringParseType strType) throws PdbException {
        super(pdb, reader);
        this.attribute = new ClassFieldMsAttributes(reader);
        this.nestedTypeDefinitionRecordNumber = RecordNumber.parse(pdb, reader, RecordCategory.TYPE, 32);
        this.name = reader.parseString(pdb, strType);
        reader.align4();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public RecordNumber getNestedTypeDefinitionRecordNumber() {
        return this.nestedTypeDefinitionRecordNumber;
    }

    public ClassFieldMsAttributes getClassFieldAttributes() {
        return this.attribute;
    }

    @Override
    public void emit(StringBuilder builder, AbstractMsType.Bind bind) {
        builder.append(this.name);
        this.pdb.getTypeRecord(this.nestedTypeDefinitionRecordNumber).emit(builder, AbstractMsType.Bind.NONE);
        StringBuilder myBuilder = new StringBuilder();
        myBuilder.append(this.attribute);
        myBuilder.append(": ");
        builder.insert(0, myBuilder);
    }
}

