/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.util;

import ghidra.feature.vt.api.main.VTAssociation;
import ghidra.feature.vt.api.main.VTMatch;
import ghidra.feature.vt.gui.plugin.AddressCorrelatorManager;
import ghidra.feature.vt.gui.util.MatchInfo;
import ghidra.util.datastruct.WeakValueHashMap;
import java.util.Map;
import java.util.Set;

public class MatchInfoFactory {
    private WeakValueHashMap<VTMatch, MatchInfo> weakMap = new WeakValueHashMap();

    public synchronized MatchInfo getMatchInfo(VTMatch match, AddressCorrelatorManager correlator) {
        MatchInfo matchInfo = (MatchInfo)this.weakMap.get((Object)match);
        if (matchInfo == null) {
            matchInfo = new MatchInfo(match, correlator);
            this.weakMap.put((Object)match, (Object)matchInfo);
        }
        return matchInfo;
    }

    public synchronized void clearCache() {
        this.weakMap.clear();
    }

    public synchronized void clearMatchInfoInternalCache() {
        for (MatchInfo info : this.weakMap.values()) {
            if (info == null) continue;
            info.clearCache();
        }
    }

    public synchronized void clearCacheForAssociation(VTAssociation association) {
        Set entrySet = this.weakMap.entrySet();
        for (Map.Entry entry : entrySet) {
            MatchInfo info;
            VTMatch match = (VTMatch)entry.getKey();
            if (!match.getAssociation().equals(association) || (info = (MatchInfo)entry.getValue()) == null) continue;
            info.clearCache();
        }
    }
}

