/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.query.protocol;

import generic.lsh.vector.LSHVectorFactory;
import ghidra.features.bsim.query.LSHException;
import ghidra.features.bsim.query.description.DescriptionManager;
import ghidra.features.bsim.query.protocol.BSimFilter;
import ghidra.features.bsim.query.protocol.BSimQuery;
import ghidra.features.bsim.query.protocol.ResponseNearest;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;
import java.io.IOException;
import java.io.Writer;

public class QueryNearest
extends BSimQuery<ResponseNearest> {
    public static final double DEFAULT_SIMILARITY_THRESHOLD = 0.7;
    public static final double DEFAULT_SIGNIFICANCE_THRESHOLD = 0.0;
    public static final int DEFAULT_MAX_MATCHES = 100;
    public DescriptionManager manage = new DescriptionManager();
    public ResponseNearest nearresponse;
    public double thresh = 0.7;
    public double signifthresh = 0.0;
    public int max = 100;
    public int vectormax = 0;
    public boolean fillinCategories = true;
    public BSimFilter bsimFilter = null;

    public QueryNearest() {
        super("querynearest");
    }

    @Override
    public void buildResponseTemplate() {
        if (this.response == null) {
            this.nearresponse = new ResponseNearest(this);
            this.response = this.nearresponse;
        }
    }

    @Override
    public DescriptionManager getDescriptionManager() {
        return this.manage;
    }

    public QueryNearest getLocalStagingCopy() {
        QueryNearest newq = new QueryNearest();
        newq.thresh = this.thresh;
        newq.signifthresh = this.signifthresh;
        newq.max = this.max;
        newq.vectormax = this.vectormax;
        newq.fillinCategories = this.fillinCategories;
        if (this.bsimFilter != null) {
            newq.bsimFilter = this.bsimFilter.clone();
        }
        return newq;
    }

    @Override
    public void saveXml(Writer fwrite) throws IOException {
        fwrite.append('<').append(this.name).append(">\n");
        this.manage.saveXml(fwrite);
        fwrite.append("<simthresh>").append(Double.toString(this.thresh)).append("</simthresh>\n");
        fwrite.append("<signifthresh>").append(Double.toString(this.signifthresh)).append("</signifthresh>\n");
        fwrite.append("<max>").append(SpecXmlUtils.encodeSignedInteger((long)this.max)).append("</max>\n");
        if (this.vectormax != 0) {
            fwrite.append("<vectormax>").append(SpecXmlUtils.encodeSignedInteger((long)this.vectormax)).append("</vectormax>\n");
        }
        if (!this.fillinCategories) {
            fwrite.append("<categories>false</categories>\n");
        }
        if (this.bsimFilter != null) {
            this.bsimFilter.saveXml(fwrite);
        }
        fwrite.append("</").append(this.name).append(">\n");
    }

    @Override
    public void restoreXml(XmlPullParser parser, LSHVectorFactory vectorFactory) throws LSHException {
        this.vectormax = 0;
        this.fillinCategories = true;
        parser.start(new String[]{this.name});
        this.manage.restoreXml(parser, vectorFactory);
        parser.start(new String[]{"simthresh"});
        this.thresh = Double.parseDouble(parser.end().getText());
        parser.start(new String[]{"signifthresh"});
        this.signifthresh = Double.parseDouble(parser.end().getText());
        parser.start(new String[]{"max"});
        this.max = SpecXmlUtils.decodeInt((String)parser.end().getText());
        while (parser.peek().isStart()) {
            XmlElement el = parser.peek();
            if (el.getName().equals("vectormax")) {
                parser.start(new String[0]);
                this.vectormax = SpecXmlUtils.decodeInt((String)parser.end().getText());
                continue;
            }
            if (el.getName().equals("categories")) {
                parser.start(new String[0]);
                this.fillinCategories = SpecXmlUtils.decodeBoolean((String)parser.end().getText());
                continue;
            }
            if (el.getName().equals("exefilter")) {
                this.bsimFilter = new BSimFilter();
                this.bsimFilter.restoreXml(parser);
                continue;
            }
            throw new LSHException("Unknown tag: " + el.getName());
        }
        parser.end();
    }
}

