/*
 * Decompiled with CFR 0.152.
 */
package sarif.export.props;

import com.google.gson.JsonElement;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.program.model.util.IntPropertyMap;
import ghidra.program.model.util.LongPropertyMap;
import ghidra.program.model.util.ObjectPropertyMap;
import ghidra.program.model.util.PropertyMap;
import ghidra.program.model.util.StringPropertyMap;
import ghidra.program.model.util.VoidPropertyMap;
import ghidra.util.SaveableColor;
import ghidra.util.SaveablePoint;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.NoValueException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import sarif.export.AbstractExtWriter;
import sarif.export.SarifObject;
import sarif.export.props.ExtProperty;
import sarif.managers.PropertiesSarifMgr;

public class SarifPropertyMapWriter
extends AbstractExtWriter {
    List<PropertyMap<?>> maps;
    Program program;
    AddressSetView set;

    public SarifPropertyMapWriter(List<PropertyMap<?>> request, Program program, AddressSetView set, Writer baseWriter) throws IOException {
        super(baseWriter);
        this.maps = request;
        this.program = program;
        this.set = set;
    }

    @Override
    protected void genRoot(TaskMonitor monitor) throws CancelledException, IOException {
        this.genMap(monitor);
        this.root.add("properties", (JsonElement)this.objects);
    }

    private void genMap(TaskMonitor monitor) throws CancelledException, IOException {
        monitor.initialize((long)this.maps.size());
        for (PropertyMap<?> map : this.maps) {
            if (map instanceof VoidPropertyMap) {
                this.genVoidMap((VoidPropertyMap)map, monitor);
                continue;
            }
            if (map instanceof IntPropertyMap) {
                this.genIntMap((IntPropertyMap)map, monitor);
                continue;
            }
            if (map instanceof LongPropertyMap) {
                this.genLongMap((LongPropertyMap)map, monitor);
                continue;
            }
            if (map instanceof StringPropertyMap) {
                this.genStringMap((StringPropertyMap)map, monitor);
                continue;
            }
            if (!(map instanceof ObjectPropertyMap)) continue;
            this.genObjectMap((ObjectPropertyMap)map, monitor);
        }
    }

    private void genVoidMap(VoidPropertyMap map, TaskMonitor monitor) throws CancelledException {
        AddressIterator iter;
        AddressIterator addressIterator = iter = this.set != null ? map.getPropertyIterator(this.set) : map.getPropertyIterator();
        while (iter.hasNext()) {
            Address addr = iter.next();
            ExtProperty isf = new ExtProperty(map.getName(), "void", null);
            SarifObject sarif = new SarifObject(PropertiesSarifMgr.SUBKEY, PropertiesSarifMgr.KEY, this.getTree(isf), addr, addr);
            this.objects.add(this.getTree(sarif));
            monitor.increment();
        }
    }

    private void genIntMap(IntPropertyMap map, TaskMonitor monitor) throws CancelledException {
        AddressIterator iter;
        AddressIterator addressIterator = iter = this.set != null ? map.getPropertyIterator(this.set) : map.getPropertyIterator();
        while (iter.hasNext()) {
            if (monitor.isCancelled()) {
                throw new CancelledException();
            }
            try {
                Address addr = iter.next();
                int value = map.getInt(addr);
                ExtProperty isf = new ExtProperty(map.getName(), "int", Integer.toHexString(value));
                SarifObject sarif = new SarifObject(PropertiesSarifMgr.SUBKEY, PropertiesSarifMgr.KEY, this.getTree(isf), addr, addr);
                this.objects.add(this.getTree(sarif));
            }
            catch (NoValueException noValueException) {}
        }
    }

    private void genLongMap(LongPropertyMap map, TaskMonitor monitor) throws CancelledException {
        AddressIterator iter;
        AddressIterator addressIterator = iter = this.set != null ? map.getPropertyIterator(this.set) : map.getPropertyIterator();
        while (iter.hasNext()) {
            if (monitor.isCancelled()) {
                throw new CancelledException();
            }
            try {
                Address addr = iter.next();
                long value = map.getLong(addr);
                ExtProperty isf = new ExtProperty(map.getName(), "long", Long.toHexString(value));
                SarifObject sarif = new SarifObject(PropertiesSarifMgr.SUBKEY, PropertiesSarifMgr.KEY, this.getTree(isf), addr, addr);
                this.objects.add(this.getTree(sarif));
            }
            catch (NoValueException noValueException) {}
        }
    }

    private void genStringMap(StringPropertyMap map, TaskMonitor monitor) throws CancelledException {
        AddressIterator iter;
        AddressIterator addressIterator = iter = this.set != null ? map.getPropertyIterator(this.set) : map.getPropertyIterator();
        while (iter.hasNext()) {
            if (monitor.isCancelled()) {
                throw new CancelledException();
            }
            Address addr = iter.next();
            String value = map.getString(addr);
            ExtProperty isf = new ExtProperty(map.getName(), "string", value);
            SarifObject sarif = new SarifObject(PropertiesSarifMgr.SUBKEY, PropertiesSarifMgr.KEY, this.getTree(isf), addr, addr);
            this.objects.add(this.getTree(sarif));
        }
    }

    private void genObjectMap(ObjectPropertyMap<?> map, TaskMonitor monitor) throws CancelledException {
        AddressIterator iter;
        AddressIterator addressIterator = iter = this.set != null ? map.getPropertyIterator(this.set) : map.getPropertyIterator();
        while (iter.hasNext()) {
            ExtProperty isf;
            if (monitor.isCancelled()) {
                throw new CancelledException();
            }
            Address addr = iter.next();
            Object value = map.get(addr);
            if (value instanceof SaveablePoint) {
                isf = new ExtProperty(map.getName(), "point", value.toString());
            } else if (value instanceof SaveableColor) {
                isf = new ExtProperty(map.getName(), "color", value.toString());
            } else {
                return;
            }
            SarifObject sarif = new SarifObject(PropertiesSarifMgr.SUBKEY, PropertiesSarifMgr.KEY, this.getTree(isf), addr, addr);
            this.objects.add(this.getTree(sarif));
        }
    }
}

