/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.dump;

import ghidra.program.model.address.Address;

public class DumpAddressObject {
    private String providerId;
    private long rva;
    private long base;
    private long length;
    private boolean isRead = true;
    private boolean isWrite = true;
    private boolean isExec = true;
    private String comment;
    private Address address;
    private String rangeName;

    public DumpAddressObject(String providerId, long rva, long base, long length) {
        this.providerId = providerId;
        this.rva = rva;
        this.base = base;
        this.length = length;
    }

    public String getProviderId() {
        return this.providerId;
    }

    public void setProviderId(String providerId) {
        this.providerId = providerId;
    }

    public long getRVA() {
        return this.rva;
    }

    public void setRVA(long rva) {
        this.rva = rva;
    }

    public long getBase() {
        return this.base;
    }

    public void setBase(long base) {
        this.base = base;
    }

    public void setLength(long length) {
        this.length = length;
    }

    public long getLength() {
        return this.length;
    }

    public long getAdjustedAddress(long addr) {
        return addr - this.getBase() + this.getRVA();
    }

    public long getCopyLen(long addr, long size) {
        if (addr - this.getRVA() + size > this.getLength()) {
            return this.getLength() - (addr - this.getRVA());
        }
        return size;
    }

    public boolean isRead() {
        return this.isRead;
    }

    public boolean isWrite() {
        return this.isWrite;
    }

    public boolean isExec() {
        return this.isExec;
    }

    public void setRead(boolean isRead) {
        this.isRead = isRead;
    }

    public void setWrite(boolean isWrite) {
        this.isWrite = isWrite;
    }

    public void setExec(boolean isExec) {
        this.isExec = isExec;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public Address getAddress() {
        return this.address;
    }

    public void setAddress(Address address) {
        this.address = address;
    }

    public String getRangeName() {
        return this.rangeName;
    }

    public void setRangeName(String name) {
        this.rangeName = name;
    }
}

