/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.ast;

import org.mozilla.javascript.Token;
import org.mozilla.javascript.ast.AstNode;
import org.mozilla.javascript.ast.NodeVisitor;

public class Comment
extends AstNode {
    private String value;
    private Token.CommentType commentType;

    public Comment(int n, int n2, Token.CommentType commentType, String string) {
        super(n, n2);
        this.type = 165;
        this.commentType = commentType;
        this.value = string;
    }

    public Token.CommentType getCommentType() {
        return this.commentType;
    }

    public void setCommentType(Token.CommentType commentType) {
        this.commentType = commentType;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String string) {
        this.value = string;
        this.setLength(this.value.length());
    }

    @Override
    public String toSource(int n) {
        StringBuilder stringBuilder = new StringBuilder(this.getLength() + 10);
        stringBuilder.append(this.makeIndent(n));
        stringBuilder.append(this.value);
        if (Token.CommentType.BLOCK_COMMENT == this.getCommentType()) {
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    @Override
    public void visit(NodeVisitor nodeVisitor) {
        nodeVisitor.visit(this);
    }
}

