/*
 * Copyright (C) 2011 Igalia S.L.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

#if !defined(__JSC_H_INSIDE__) && !defined(BUILDING_WEBKIT)
#error "Only <jsc/jsc.h> can be included directly."
#endif

#ifndef JSCDefines_h
#define JSCDefines_h

#include <glib.h>

#ifdef G_OS_WIN32
#    if defined(BUILDING_JavaScriptCore) || defined(STATICALLY_LINKED_WITH_JavaScriptCore)
#        define JSC_API __declspec(dllexport)
#    else
#        define JSC_API __declspec(dllimport)
#    endif
#else
#    define JSC_API __attribute__((visibility("default")))
#endif

#ifndef __GI_SCANNER__
#define JSC_DEPRECATED JSC_API G_DEPRECATED
#define JSC_DEPRECATED_FOR(f) JSC_API G_DEPRECATED_FOR(f)
#endif /* !__GI_SCANNER__ */

#define JSC_DECLARE_FINAL_TYPE(ModuleObjName, module_obj_name, MODULE, OBJ_NAME, ParentName) \
    JSC_API GType module_obj_name ## _get_type (void);                     \
                                                                           \
    typedef struct _ ## ModuleObjName ModuleObjName;                       \
    typedef struct _ ## ModuleObjName ## Class ModuleObjName ## Class;     \
    typedef struct _ ## ModuleObjName ## Private ModuleObjName ## Private; \
                                                                           \
    struct _ ## ModuleObjName {                                            \
        ParentName parent;                                                 \
        /*< private >*/                                                    \
        ModuleObjName ## Private *priv;                                    \
    };

#endif /* JSCDefines_h */
