//
// Copyright 2023 Pixar
//
// Licensed under the terms set forth in the LICENSE.txt file available at
// https://openusd.org/license.
//
////////////////////////////////////////////////////////////////////////

/* ************************************************************************** */
/* **                                                                      ** */
/* ** This file is generated by a script.                                  ** */
/* **                                                                      ** */
/* ** Do not edit it directly (unless it is within a CUSTOM CODE section)! ** */
/* ** Edit hdSchemaDefs.py instead to make changes.                        ** */
/* **                                                                      ** */
/* ************************************************************************** */

#ifndef PXR_USD_IMAGING_USD_IMAGING_COLLECTION_MATERIAL_BINDING_SCHEMA_H
#define PXR_USD_IMAGING_USD_IMAGING_COLLECTION_MATERIAL_BINDING_SCHEMA_H

/// \file

#include "pxr/usdImaging/usdImaging/api.h"

#include "pxr/imaging/hd/schema.h"

// --(BEGIN CUSTOM CODE: Includes)--
// --(END CUSTOM CODE: Includes)--

PXR_NAMESPACE_OPEN_SCOPE

// --(BEGIN CUSTOM CODE: Declares)--
// --(END CUSTOM CODE: Declares)--

#define USD_IMAGING_COLLECTION_MATERIAL_BINDING_SCHEMA_TOKENS \
    (collectionMaterialBinding) \
    (collectionPrimPath) \
    (collectionName) \
    (materialPath) \
    (bindingStrength) \

TF_DECLARE_PUBLIC_TOKENS(UsdImagingCollectionMaterialBindingSchemaTokens, USDIMAGING_API,
    USD_IMAGING_COLLECTION_MATERIAL_BINDING_SCHEMA_TOKENS);

//-----------------------------------------------------------------------------


class UsdImagingCollectionMaterialBindingSchema : public HdSchema
{
public:
    /// \name Schema retrieval
    /// @{

    UsdImagingCollectionMaterialBindingSchema(HdContainerDataSourceHandle container)
      : HdSchema(container) {}

    /// Retrieves a container data source with the schema's default name token
    /// "collectionMaterialBinding" from the parent container and constructs a
    /// UsdImagingCollectionMaterialBindingSchema instance.
    /// Because the requested container data source may not exist, the result
    /// should be checked with IsDefined() or a bool comparison before use.
    USDIMAGING_API
    static UsdImagingCollectionMaterialBindingSchema GetFromParent(
        const HdContainerDataSourceHandle &fromParentContainer);

    /// @}

// --(BEGIN CUSTOM CODE: Schema Methods)--
// --(END CUSTOM CODE: Schema Methods)--

    /// \name Member accessor
    /// @{

    USDIMAGING_API
    HdPathDataSourceHandle GetCollectionPrimPath() const;

    USDIMAGING_API
    HdTokenDataSourceHandle GetCollectionName() const;

    USDIMAGING_API
    HdPathDataSourceHandle GetMaterialPath() const;

    USDIMAGING_API
    HdTokenDataSourceHandle GetBindingStrength() const; 

    /// @}

    /// \name Schema location
    /// @{

    /// Returns a token where the container representing this schema is found in
    /// a container by default.
    USDIMAGING_API
    static const TfToken &GetSchemaToken();

    /// Returns an HdDataSourceLocator (relative to the prim-level data source)
    /// where the container representing this schema is found by default.
    USDIMAGING_API
    static const HdDataSourceLocator &GetDefaultLocator();

    /// @} 

    /// \name Schema construction
    /// @{

    /// \deprecated Use Builder instead.
    ///
    /// Builds a container data source which includes the provided child data
    /// sources. Parameters with nullptr values are excluded. This is a
    /// low-level interface. For cases in which it's desired to define
    /// the container with a sparse set of child fields, the Builder class
    /// is often more convenient and readable.
    USDIMAGING_API
    static HdContainerDataSourceHandle
    BuildRetained(
        const HdPathDataSourceHandle &collectionPrimPath,
        const HdTokenDataSourceHandle &collectionName,
        const HdPathDataSourceHandle &materialPath,
        const HdTokenDataSourceHandle &bindingStrength
    );

    /// \class UsdImagingCollectionMaterialBindingSchema::Builder
    /// 
    /// Utility class for setting sparse sets of child data source fields to be
    /// filled as arguments into BuildRetained. Because all setter methods
    /// return a reference to the instance, this can be used in the "builder
    /// pattern" form.
    class Builder
    {
    public:
        USDIMAGING_API
        Builder &SetCollectionPrimPath(
            const HdPathDataSourceHandle &collectionPrimPath);
        USDIMAGING_API
        Builder &SetCollectionName(
            const HdTokenDataSourceHandle &collectionName);
        USDIMAGING_API
        Builder &SetMaterialPath(
            const HdPathDataSourceHandle &materialPath);
        USDIMAGING_API
        Builder &SetBindingStrength(
            const HdTokenDataSourceHandle &bindingStrength);

        /// Returns a container data source containing the members set thus far.
        USDIMAGING_API
        HdContainerDataSourceHandle Build();

    private:
        HdPathDataSourceHandle _collectionPrimPath;
        HdTokenDataSourceHandle _collectionName;
        HdPathDataSourceHandle _materialPath;
        HdTokenDataSourceHandle _bindingStrength;

    };

    /// @}
};

PXR_NAMESPACE_CLOSE_SCOPE

#endif