/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.transport.nio;

import java.io.IOException;
import org.apache.catalina.tribes.ChannelException;
import org.apache.catalina.tribes.ChannelMessage;
import org.apache.catalina.tribes.Member;
import org.apache.catalina.tribes.transport.DataSender;
import org.apache.catalina.tribes.transport.PooledSender;
import org.apache.catalina.tribes.transport.nio.ParallelNioSender;
import org.apache.catalina.tribes.transport.nio.PooledParallelSenderMBean;
import org.apache.catalina.tribes.util.StringManager;

public class PooledParallelSender
extends PooledSender
implements PooledParallelSenderMBean {
    protected static final StringManager sm = StringManager.getManager(PooledParallelSender.class);

    @Override
    public void sendMessage(Member[] memberArray, ChannelMessage channelMessage) throws ChannelException {
        if (!this.isConnected()) {
            throw new ChannelException(sm.getString("pooledParallelSender.sender.disconnected"));
        }
        ParallelNioSender parallelNioSender = (ParallelNioSender)this.getSender();
        if (parallelNioSender == null) {
            ChannelException channelException = new ChannelException(sm.getString("pooledParallelSender.unable.retrieveSender.timeout", Long.toString(this.getMaxWait())));
            for (Member member : memberArray) {
                channelException.addFaultyMember(member, new NullPointerException(sm.getString("pooledParallelSender.unable.retrieveSender")));
            }
            throw channelException;
        }
        try {
            if (!parallelNioSender.isConnected()) {
                parallelNioSender.connect();
            }
            parallelNioSender.sendMessage(memberArray, channelMessage);
            parallelNioSender.keepalive();
        }
        catch (ChannelException channelException) {
            parallelNioSender.disconnect();
            throw channelException;
        }
        finally {
            this.returnSender(parallelNioSender);
        }
    }

    @Override
    public DataSender getNewDataSender() {
        try {
            ParallelNioSender parallelNioSender = new ParallelNioSender();
            PooledParallelSender.transferProperties(this, parallelNioSender);
            return parallelNioSender;
        }
        catch (IOException iOException) {
            throw new RuntimeException(sm.getString("pooledParallelSender.unable.open"), iOException);
        }
    }
}

