# Seri

## Introduction

The [Seri people](https://en.wikipedia.org/wiki/Seri_people) are an indigenous group in Mexico.

## Description

There have been six different Comca'ac groups (Comca'ac means "people"):

 - the Xica hacataj quitoj, who eat meat of sharks, inhabited San Esteban Island (Isla Turón);
 - the Xnamotat, who lived in the south, inhabit San Carlos, Guaymas and Tastiota;
 - the Cail hitic 'tamoc, the men from the valley, inhabited the region between Tastiota and Bahía Kino;
 - the Heno comca'ac, who live in the mountains, inhabited the centre of Tiburón Island;
 - the Tepocaj, the fishermen, who inhabited the region between Puerto Libertad and Puerto Peñasco; and,
 - the Tosni hox hanoquipilc, who fed themselves on sea birds (ducks and pelicans), inhabited Island San Lorenzo.

 <img src="illustrations/abuela.png" width="250" align="left" />Nowadays, the Seri people live at Punta Chueca and Desemboque, located in the coast of the northwestern state of Sonora, Mexico. According with the fishing cycles, Comca'ac occupy several fishing camps at the litoral distributed along a 100 km territory. The whole area assigned to them reaches the 210 thousand hectares which corresponds to a region in the continent and the Tiburón Island in the California gulf.

The Seri language (coiiqui'itom) forms part of the seriyumana family which means that, on one hand, its most recent relation can be given by the yumano coming from the north of the Californian peninsula, and, on the other hand, this language totally contrasts with the languages of its neighbouring nations who talk uto-aztec ones like pima, p&#225;pago, yaqui and mayo; all of them fila with a much more recent origin.

The description of the Comca'ac (Seri) Constellations presented here comes from the book "Bajo el cielo Comca'ac: Astronomía entre el mar y el desierto", written by Arturo Morales Blanco, in which it is possible to identify the relations between sky, sea and desert, as they are recovered by oral tradition and family memories.

This knowledge has arrived to us by oral transmission from generation to generation through time and shows how the events from the sea like the appearance of crabs or the abundance of Totoaba (a large fish, now in danger), comes along with the presence of sets of stars in the sky. Comca'ac people has named them Zaamth or Zix cam caoc'la, respectively; also, the coincidence of Pitahayas (cactus fruits) in the cactus with the appearance of constellation Hácosa (Corta-pitahayas) in the sky is very suggestive.

## Constellations

##### <notr>Zaamth</notr>

<table class="layout">
<tr>
	<td><img src="illustrations/zaamth.png" height="100" /></td>
	<td>When the stars of Orion's Belt, Rigel and Betelgeuse appear above the western horizon, in the month of March, Comca'ac people see how in shallow waters of the marsh, the crabs are found forming groups of about 300 or 400 items which can be collected easily; that is the reason to call Zaamth to constellation. After six months, when the sea is cold, the crabs do not appear any more going from one place to another; instead the sea wheat, xnois, comes and their seed has been used to make flour and different food plates for centuries. The legend says that in the days corresponding to the crab "harvesting", it must be avoided to break a leg or a claw because, if this happens, the day after there will not be any more crabs at the site.</td>
</tr>
</table>

##### <notr>Cohamc</notr>

<table class="layout">
<tr>
	<td><img src="illustrations/cohamc.png" height="100" /></td>
	<td>About October 18th, an alignment of stars takes place in the morning sky and it is called, since ancient times, as Cohamc constellation, women. Then four or five days after the rains begin to fall with intensity and the wind runs by the desert. The star that is at the north of the alignment, the Comca'ac's name is Hacamta, the husband, and is the one appearing behind the other six named women, (the star Psi of Ursa Major); the six stars appear in sequence, two by two. The forecast of this bad weather motivated their ancestors to go to the caves in the mountain and to go far from the beach. After the difficult days, around two months later, Comca'ac people returned to the beach carrying with them all the food and materials kept along: dried meat, fish, 'caguama' turtle, honey, and flour from 'péchita de mezquite' (seeds from Mesquite tree), between them.</td>
</tr>
</table>

##### <notr>Hazoj canoj Hantificaü</notr>

<table class="layout">
<tr>
	<td><img src="illustrations/hazoj_canoj.png" height="100" /></td>
	<td>This star that appears alone in the sky with its multicolour shine can be seen along the year. However, in the first days of September (after the heliacal rising), one has to get up at 4 or 5 in the morning to see it. This star corresponds to Sirius and it announces the new day. The legend says that when someone gets up when the Sun is already in the sky, all his tents to become the skin of the dead. Hazoj means constellation and Hantificaö is "Who comes at the dawn".</td>
</tr>
</table>

##### <notr>Haapjc</notr>

<table class="layout">
<tr>
	<td><img src="illustrations/haapjc_desc.jpg" height="100" /></td>
	<td>This constellation is, perhaps, the most complex of Comca'ac ones, due to the fact that it covers a wide area in the sky and in it, one can find stars from Taurus, Twins, and the Capella star. It can be said that Haapjc (Deer hunter) has the following sections: the whitetail deer, the bura deer and bighorn deer (Hépem, Háap and Möjit, respectively), which are the stars known as Hassaleh, Elnath and 123 Tau; the spear with its flint at Aldebaran and the stars forming a 'V' of Taurus, while the feathers are Castor and Pollux of Gemini; and, finally, the hunter, properly said, is Cozaactim ("Who crosses"), with his head at Capella.<br> The legend says that Cozaactim threw his spear and hit the Bura deer. Háap was wounded and flew through the sky bleeding; then, a little drop of blood fell in the Tiburón Island, and that is the reason why bura deer are native of the island. This constellation can be observed in September morning skies.</td>
</tr>
</table>

##### <notr>Hácosa</notr>

<table class="layout">
<tr>
	<td><img src="illustrations/hacosa.png" height="100" /></td>
	<td>It is said that when this constellation is pointing to the top of the sky, at September 7th, it appears similar to the instrument Hácosa (Pitahaya-cutter), and it is time to collect the wild fruits: 'péchitas de mezquite' (Mesquite seeds) and pitahayas (cactus fruit), for example. When there is no sign of it, the season will be bad.</td>
</tr>
</table>

##### <notr>Hazoj Cöiquih</notr>

<table class="layout">
<tr>
	<td><img src="illustrations/hazoj_koii.png" height="100" /></td>
	<td>Between the twelve stars of Cöiquih (Person) is the star Antares. In this constellation, the person seems to be fishing; that is why the corresponding legend affirms that Zix hantpatj (cochito fish) has at the roof of its mouth a kind of jelly substance, coming from the pulp of a cactus that the ancestors used as bait. This constellation goes, month after month, revolving in the sky and it is seen in a recumbent position when it is over Tiburón Island on midnight at September 8th.</td>
</tr>
</table>

##### <notr>Caamooilcoj</notr>

<table class="layout">
<tr>
	<td><img src="illustrations/caamoilcoj.png" height="100" /></td>
	<td>This constellation named Caamooilcoj (Wheel Game), is one of the most important arrays of stars between Comca'ac people; it can be observed at plenitude at winter; with around fifteen stars in a wheeled shape, and stars as reed tablets (tablillas de carrizo) which play the role of dice. It is said that in ancient times, this game was played by men, exclusively, who put as bet their own life; now, the game is played at festivals and special occasions by women representing events of life and protection; in particular, it is played during puberty ceremonies for example; or at the feast of zaaptim (great basket). <br>For this game, several round pieces of Pitahayas (cactus fruits) or of 'cinita' (four lines cactus) made the circle (today, they are decorated stones with different motives); and, three reed pieces (tablillas de carrizo), painted in colours. The meaning of these three colours are: Red - the blood and death; Blue - the sky and the sea; and, White - purity, good health and protection.</td>
</tr>
</table>

##### <notr>Quetoh</notr>

<table class="layout">
<tr>
	<td><img src="illustrations/quetoh0.png" height="100" /></td>
	<td>This lonely star is known as Quetoh (little dove), it is modern Arcturus. It appears around October 8th announcing an epoch of good fishing. The ancestors did not have nets or other fishing arts, they used harpoons to capture their preys and a "flint" harpoon or double point tool. The legend says that many years ago, with the appearance of this star in the sky, the floriation of cactus begun and at the end of the week, there were Pitahayas on them; however, the next day, all the pitahayas disappeared: it was Quetoh yacaso or 'spell of the dove' responsible of eating that fruit.</td>
</tr>
</table>

##### <notr>Himatax</notr>

<table class="layout">
<tr>
	<td><img src="illustrations/himatax.png" height="100" /></td>
	<td>This lonely star is known as Hazoj canoj Himatax because its meaning is a star which does not move and around which all turns. It is present all night long, all the days of the year.</td>
</tr>
</table>

##### <notr>Yay Xapi Hanopas</notr>

<table class="layout">
<tr>
	<td><img src="illustrations/yay_xapi.png" height="100" /></td>
	<td>The young hunter, says the legend, was a boy who went hunting, and several weeks after his departure he was still absent, and the members of his camp considered him dead. But several months later, at daybreak, he has shown himself to his parents who were surprised telling him: "We thought you were dead, we have spent many days looking for you, until we were tired; we cried for you a lot". The young man told his parents: "I live near the beach, I found a good place and stayed there". "But what kind of water you drink?" They asked. "I found any water and that is I drink, Haxhaxaha tahomisi", he said to them while talking about the Tecomate Bay.<br> According to this legend, the young hunter became the Constellation with Canopus at its centre caused by a conflict with his elder brother. It appears directly towards the south.</td>
</tr>
</table>

### Conclusion

All this knowledge of Comca'ac people comes from prehispanic epoch, and it has prevailed through centuries, thanks to oral tradition and the strength of the community to colonization, at first, and his opposition to evangelization, later on. Still today, it is possible to hear the stories and legends behind the naming of constellations and the events on the sea and on the desert. With the recovery of these legends, by exercise of memory and lively events with his ancestors, Arturo Morales Blanco gave us a legacy that must be conserved for future generations: children, young people who will keep in their own language how and what to look for in the sky.

## References

 - [#1]: [Diccionario Seri - Espa&#241;ol - Ingl&#233;s, Universidad de Sonora/Plaza y Vald&#233;s, 2005.](https://www.dimensionantropologica.inah.gob.mx/?p=395)
 - [#2]: [Saaptim. Patrimonio de la cultura seri](https://www.inah.gob.mx/en/boletines/3729-mujeres-seris-tejen-su-historia)
 - [#3]: [Constelaciones Prehisp&#225;;nicas](http://www.montero.org.mx/constelaciones.htm)
 - [#4]: [Arqueoastronom&#237;a y desarrollo de las ciencias en el M&#233;xico prehisp&#225;;nico](http://bibliotecadigital.ilce.edu.mx/sites/ciencia/volumen1/cienc)
 - [#5]: [Museo Comca'ac en Bah&#237;a de Kino](http://isc.gob.mx/devel/2018/11/14/renueva-isc-museo-comcaac-en-bahia-de-kino/)
 - [#6]: [Pueblo Seri](https://es.wikipedia.org/wiki/Pueblo_seri)
 - [#7]: [Idioma Seri (Coiiqui itom)](https://es.wikipedia.org/wiki/Idioma_seri)
 - [#8]: [Isla de Tibur&#243;n](https://es.wikipedia.org/wiki/Isla_Tibur%C3%B3n)
 - [#9]: [Los navegantes del desierto: La naci&#243;n comca'ac en el siglo XXI](http://www.iifl.unam.mx/uploads/justiciadelotro/pdfs/rPdf29.pdf)

## Authors

**Ra&#250;l Pérez-Enríquez**: [raulpe55(at)gmail(dot)com](mailto:raulpe55@gmail.com)

### Thanks to

 - Arturo Morales Blanco
 - Alejandro Aguilar Zeleny
 - Julio Saucedo Morales
 - Alfredo Manríquez
 - UNISON

English translation by: Alfredo Manríquez

## License

CC BY-SA 4.0
