# Babylonian (Seleucid)

## Introduction

The Seleucid Era in Babylonian history is the era of the successors of Alexander the Great who conquered Babylon in 331 BCE. In these days MUL.APIN (already thousand years old) was still copied and, thus, appears to have developed to be an old-fashioned but not outdated standard. Moreover, there is no alternative compendium like MUL.APIN from the Late Babylonian epoch.

<p>This <em>Seleucid</em> or <em>Late Babylonian sky culture</em> is supposed to show the (estimated) state of Babylonian constellations contemporary to the Greek culture. There is no description of the full sky. Changes with regard to the MUL.APIN version have certainly applied in the zodiac since several centuries. This can be stated for sure because in this time, there is a blossoming zodiacal astrology. Since there had been no zodiac in MUL.APIN and the zodiac developed around the middle of the -1st millennium, in the 2nd half of the 1st millennium BCE, there had been different versions of the constellations around the ecliptic.
 </p>

 However, we do not know much about the rest of the sky. Hence, for the constellations far away from the zodiac, again the constellations of MUL.APIN can be taken as state of the art. Please see MUL.APIN sky culture for more information and use the MUL.APIN constellations for an impression of the Old Babylonian (or Middle Babylonian) sky culture.

## Description

### Single Stars

 <p>
 In contrast to constellations, there are much more lists of single stars preserved from the later epochs. We use this Late Babylonian or Seleucid sky culture to focus on the single star names. There are plenty of <i>ziqpu</i> lists (lists of culminating stars) and for measurements in the zodiac, "normal stars" have been introduced. Normal stars (from Latin "norma" = the measure) are a frame of reference for mathematical astrometry of the Late Babylonian epoch. While for most of the other stars the margin of error concerning their identification with a celestial counterpart is sometimes huge, the normal stars are identified properly because their coordinates can be derived from the planets standing next to them (Jones, 2004).
</p>

### Source(s)

<p>The lists of ziqpu stars and normal stars are mostly compiled from the modern compendium Hunger and Pingree: Astral Science in Mesopotamia, 1999 and some of the other papers given in "Further Reading". The book by Hoffmann, 2017 already contains several computations with these stars and more literature (e.g. Wayne Horowitz has worked on <i>ziqpu</i> stars for many years but is not mentioned here with a special paper although his translations contributed a lot for this study). A likely version of the Late Babylonian stick figures will be added in a later release of Stellarium.
</p>
<p>

### MUL.APIN constellations partially re-worked

<table cellpadding="7" cellspacing="1" style="background: transparent">
<tbody>
<tr valign="top" style="background: #e6e6e6; font-weight: bold">
<td width="5ex">constellation number</td>
<td>asterism</td>
<td>our commentary</td>
<td>position in the sky</td>
</tr>
<tr valign="top" style="background: #e7e6e6;">
<td><notr>1</notr></td>
<td><sup>STAR</sup><i>EPINNU</i>(Plough)</td>
<td></td>
<td><notr>Cas</notr></td>
</tr>
<tr valign="top" style="background: #e7e6e6;">
<td><notr>2</notr></td>
<td><sup>STAR</sup><i>BARBARU</i> (Wolf): seeder of <sup>STAR</sup><i>EPINNU</i></td>
<td>"wolf" here does not mean the animal but a part of the plough.</td>
<td><notr>&gamma; Cas (+?)</notr></td>
</tr>
<tr valign="top" style="background: #dee6ef">
<td><notr>3</notr></td>
<td><sup>STAR</sup><i>&Scaron;&#298;BU</i>(Old Man)</td>
<td></td>
<td><notr>Per</notr></td>
</tr>
<tr valign="top" style="background: #e7e6e6">
<td><notr>4</notr></td>
<td><sup>STAR</sup><i>GAMLU</i>(Throwing-stick)</td>
<td></td>
<td>in<notr> Aur</notr></td>
</tr>
<tr valign="top" style="background: #dee6ef">
<td><notr>5</notr></td>
<td><sup>STAR</sup><i>T&#362;'AM&#362;&middot;RAB&Ucirc;TU</i>(Great Twins)</td>
<td></td>
<td><notr>Gem</notr></td>
</tr>
</tbody>
<tbody>
<tr valign="top" style="background: #e7e6e6">
<td><notr>6</notr></td>
<td><sup>STAR</sup><i>T&#362;'AM&#362;&middot;&#7778;E&#7722;R&#362;TU</i>(Little Twins)</td>
<td>do not exist anymore (merged with Great Twins) </td>
<td><notr>Gem</notr></td>
</tr>
<tr valign="top" style="background: #dee6ef">
<td><notr>7</notr></td>
<td><sup>STAR</sup><i>ALLUTTU</i>(Crab)</td>
<td></td>
<td><notr>Cnc</notr></td>
</tr>
<tr valign="top" style="background: #e7e6e6">
<td><notr>8</notr></td>
<td><sup>STAR</sup><i>URGUL&Ucirc;</i>(Lion)</td>
<td></td>
<td><notr>Leo</notr></td>
</tr>
<tr valign="top" style="background: #e7e6e6">
<td><notr>9</notr></td>
<td>STAR opposite <sup>STAR</sup><i>URGUL&Ucirc;</i>: STAR (of the) King</td>
<td></td>
<td>Regulus</td>
</tr>
<tr valign="top" style="background: #e7e6e6">
<td><notr>10</notr></td>
<td>twinkling STARs in the tail of <sup>STAR</sup><i>URGUL&Ucirc;</i>: &quot;date-palm spadix&quot; (jewellery?) (of) <sup>GOD</sup>Erua</td>
<td></td>
<td><notr>Com</notr></td>
</tr>
<tr valign="top" style="background: #dee6ef">
<td><notr>11</notr></td>
<td><sup>STAR</sup>&Scaron;U.PA(The Bright?) = <sup>GOD</sup>Enlil</td>
<td></td>
<td><notr>Boo</notr></td>
</tr>
<tr valign="top" style="background: #dee6ef">
<td><notr>12</notr></td>
<td>STAR in front of it: <sup>STAR</sup><i>&#7722;ENGALL&#256;YU</i> (Abundant)</td>
<td></td>
<td><notr>&alpha; Boo </notr>or<notr> &alpha; CVn</notr></td>
</tr>
<tr valign="top" style="background: #dee6ef">
<td><notr>13</notr></td>
<td>STAR behind it: <sup>STAR</sup><i>B&#256;&Scaron;TUM</i> (Dignity)</td>
<td></td>
<td><notr>CrB</notr></td>
</tr>
<tr valign="top" style="background: #e7e6e6">
<td><notr>14</notr></td>
<td><sup>STAR</sup><i>EREQQU</i> (Wagon)</td>
<td></td>
<td><notr>UMa</notr></td>
</tr>
<tr valign="top" style="background: #e7e6e6">
<td><notr>15</notr></td>
<td>STAR by the pole of <sup>STAR</sup><i>EREQQU</i>: <sup>STAR</sup><i>&Scaron;&#274;LEBU</i>(Fox)</td>
<td></td>
<td>Alcor<notr> (80 UMa)</notr></td>
</tr>
<tr valign="top" style="background: #e7e6e6">
<td><notr>16</notr></td>
<td>STAR on the forehead of <sup>STAR</sup><i>EREQQU</i>: <sup>STAR</sup><i>LA&#7722;RU</i>(Ewe)</td>
<td></td>
<td><notr>&alpha; UMa (+)</notr></td>
</tr>
<tr valign="top" style="background: #e7e6e6">
<td><notr>17</notr></td>
<td><sup>STAR</sup>MU.BU.K&Eacute;&Scaron;.DA (Hitched yoke?)</td>
<td></td>
<td><notr>UMi</notr></td>
</tr>
<tr valign="top" style="background: #e7e6e6">
<td><notr>18</notr></td>
<td><sup>STAR</sup>MAR.G&Iacute;D.DA.AN.NA (Wagon of heaven)</td>
<td></td>
<td>somewhere betw UMi and Vega?</td>
</tr>
<tr valign="top" style="background: #e7e6e6">
<td><notr>19</notr></td>
<td>STAR in its bond: <sup>STAR</sup><i>APIL-EMA&#7722;</i> (Heir of the Ema&#7723;-temple)</td>
<td></td>
<td><notr>&alpha; UMi (?)</notr></td>
</tr>
<tr valign="top" style="background: #e7e6e6">
<td><notr>20</notr></td>
<td><sup>STAR</sup><i>ENZU</i>(She-Goat)</td>
<td></td>
<td><notr>Lyr</notr></td>
</tr>
<tr valign="top" style="background: #e7e6e6">
<td><notr>21</notr></td>
<td>STAR in front of <sup>STAR</sup><i>ENZU</i>: <sup>STAR</sup><i>KALBU</i>(Dog) [of Goddess Gula]</td>
<td></td>
<td>in<notr> Her</notr></td>
</tr>
<tr valign="top" style="background: #e7e6e6">
<td><notr>22</notr></td>
<td>bright STAR of <sup>STAR</sup><i>ENZU</i></td>
<td></td>
<td><notr>&alpha; Lyr</notr></td>
</tr>
<tr valign="top" style="background: #e7e6e6">
<td><notr>23</notr></td>
<td>2 STAR<sup>s</sup> behind it: <sup>GOD</sup>Nin-SAR and <sup>GOD</sup>Errakal</td>
<td></td>
<td><notr>&eta;, &theta; Lyr ?</notr></td>
</tr>
<tr valign="top" style="background: #dee6ef">
<td><notr>24</notr></td>
<td><sup>STAR</sup><i>nimru</i> (Panther)</td>
<td>In Late Babylonian language ("dictionaries") a new reading of this constellation name appears: it should be interpreted as Akkadian word "nimru" translating to "the Panther"; the old demon at this place seems to have been replaced.</td>
<td><notr>Cyg</notr></td>
</tr>
<tr valign="top" style="background: #dee6ef">
<td><notr>25</notr></td>
<td>STAR to the right of it: <sup>STAR</sup>&Scaron;<i>A&#7722;&Ucirc;</i> (Pig)</td>
<td></td>
<td><notr>?</notr></td>
</tr>
<tr valign="top" style="background: #dee6ef">
<td><notr>26</notr></td>
<td>STAR to the left of it: <sup>STARS</sup><i>SIS&Ucirc;</i> (Horse)</td>
<td></td>
<td><notr>?</notr></td>
</tr>
<tr valign="top" style="background: #dee6ef">
<td><notr>27</notr></td>
<td>STAR behind it: <sup>STAR</sup><i>LULIMMU</i> (Stag)</td>
<td>We shifted the Stag to display another suggestion and because the Panther occupies different areas than the UKADUA demon. It is still uncertain but in this version the breast of the Stag includes M31 which could be the "Field Mouse". </td>
<td><notr>?</notr></td>
</tr>
<tr valign="top" style="background: #dee6ef">
<td><notr>28</notr></td>
<td>twinkling STAR<sup>s</sup> opposite <sup>STAR</sup><i>LULIMMU</i>(Stag): <sup>GOD</sup>&#7722;arriru (Field Mouse)</td>
<td></td>
<td><notr>M31 ?</notr></td>
</tr>
<tr valign="top" style="background: #c6c6c6; color: #ff0000">
<td></td>
<td colspan="3">Path of <sup>GOD</sup>Enlil finished.</td>
</tr>
</tbody>
</table>
<table cellpadding="7" cellspacing="1">
<tbody>
<tr valign="top" style="background: #e6e6e6; font-weight: bold">
<td width="5ex">constellation number</td>
<td>asterism</td>
<td>our commentary</td>
<td>position in the sky</td>
</tr>
<tr valign="top" style="background: #e7e6e6">
<td><notr>32</notr></td>
<td><sup>STAR</sup>ONE&middot;&quot;FIELD&quot;(area measure)</td>
<td></td>
<td><notr>Peg</notr></td>
</tr>
<tr valign="top" style="background: #e7e6e6">
<td><notr>33</notr></td>
<td>STAR opposite <sup>STAR</sup>ONE&middot;'FIELD': <sup>STAR</sup><i>&Scaron;IN&#362;NUTU</i>(Swallow)</td>
<td>the southern one of the two ellipses of fish; in comparison to the earlier version a small constellation which shifted northwestwards</td>
<td><notr>Psc</notr></td>
</tr>
<tr valign="top" style="background: #e7e6e6">
<td><notr>33 (a)</notr></td>
<td><sup>STAR</sup><i>ZIBATI</i>(Tails)</td>
<td>Since the Old Babylonian 'Great Swallow' turned into a small swallow and was shifted to another place, the V-shaped tails of the Great Swallow remained without any meaning. Still, they are used as constellation (Tails - but nobody knows of whom). Later, the V-shape was interpreted as a band connecting the little swallow with a little fish below the constellation of Anunitu.</td>
<td><notr>Psc</notr></td>
</tr>
<tr valign="top" style="background: #e7e6e6">
<td><notr>34</notr></td>
<td>STAR behind <sup>STAR</sup>ONE&middot;'FIELD': <sup>STAR</sup><i>ANUNN&#298;TU</i></td>
<td>Our stick figure is prepared to transform to the Greek Andromeda: Anunitu is another name for the Babylonian goddess of sexual love Ishtar who was equalized with Greek Aphrodite whose myth in Syria was connected to fish.</td>
<td><notr>And</notr></td>
</tr>
<tr valign="top" style="background: #e7e6e6">
<td><notr>35</notr></td>
<td>STAR behind it: <sup>STAR</sup><i>AGRU</i>(Hired Worker)</td>
<td>Over centuries of abbreviation of the names of constellations, the Babylonian LU.HUN.GA transformed to HUN which is a sign similar to UDU (sheep). Therefore, the working man transformed to a sheep. This was likely a Babylonian wordplay only and therefore the constellation figure is not supposed to really look like a sheep.</td>
<td><notr>Ari</notr></td>
</tr>
<tr valign="top" style="background: #dee6ef">
<td><notr>36</notr></td>
<td>STAR.STAR(<i>ZAPPU</i>, Bristle): <sup>GOD</sup>Sebettu</td>
<td>Old Babylonian termed only "the Star Cluster", Middle Babylonian insists to equalize this with Sebettu (the Seven Gods, warriors) - reason unknown. Late Babylonian more often uses the term "the Bristle" on the neck of the Bull. This interpretation is equal to the Greek one.</td>
<td>Pleiades</td>
</tr>
<tr valign="top" style="background: #e7e6e6">
<td><notr>37</notr></td>
<td><sup>STAR</sup>BULL&middot;OF&middot;HEAVEN(<i>AL&Ucirc;</i>) and <sup>GOD</sup><i>Is-l&ecirc;</i> (Jaw of the Wild Bull)</td>
<td>The Bull of Heaven is a mythological figure from the epos of Gilgamesh. Gilgamesh fights him and divides him in halves (which explains its depiction in the sky). The "Jaw" are the Hyades.</td>
<td><notr>Tau </notr>and Hyades</td>
</tr>
<tr valign="top" style="background: #dee6ef">
<td><notr>38</notr></td>
<td><sup>STAR</sup>TRUE&middot;SHEPHERD&middot;OF&middot;HEAVEN (<i>&Scaron;ITADDALLU</i>, Orion)</td>
<td></td>
<td><notr>Ori</notr></td>
</tr>
<tr valign="top" style="background: #dee6ef">
<td><notr>39</notr></td>
<td>Twin STARs opposite <sup>STAR</sup><i>&Scaron;ITADDALLU</i></td>
<td></td>
<td><notr>&pi;<sub>3</sub>, &pi;<sub>4</sub> Ori ?</notr></td>
</tr>
<tr valign="top" style="background: #dee6ef">
<td><notr>40</notr></td>
<td>STAR behind it: <sup>STAR</sup><i>TARLUGALLU</i> (Cock)</td>
<td>Normally, the Cock is identified with modern Lepus but this does not make any sense to me: "behind" Orion, i.e. rising after him is Prokyon, a very bright star without any known Babylonian name. The Greeks named him "pro kyon" (rising before the dog) because in some of the conquered cultures Prokyon was an indicator for the soon rising of Sirius (the dog star for them). Sirius was not a dog star in Babylonian sky culture but, however, important for the calendar. That is why, I suggest to take Prokyon for a crowing rooster, somehow announcing the brighter Sirius.</td>
<td><notr>Lep (</notr>or<notr> &alpha; CMi ??)</notr></td>
</tr>
<tr valign="top" style="background: #e7e6e6">
<td><notr>41</notr></td>
<td><sup>STAR</sup>GAG.SI.S&Aacute; (Arrow)</td>
<td>The depicted version is a suggestion. Sure is only Sirius, for the rest, there are multiple options.</td>
<td>Sirius + </td>
</tr>
<tr valign="top" style="background: #dee6ef">
<td><notr>42</notr></td>
<td><sup>STAR</sup><i>QA&Scaron;TU</i> (Bow)</td>
<td>I suppose, this is the mostly accepted version (out of several existing options).</td>
<td>in<notr> CMa ?</notr></td>
</tr>
<tr valign="top" style="background: #e7e6e6">
<td><notr>43</notr></td>
<td>STAR (of) <sup>GOD</sup>NIRA&#7722; (Snake-god)</td>
<td></td>
<td><notr>Hya</notr></td>
</tr>
<tr valign="top" style="background: #dee6ef">
<td><notr>44</notr></td>
<td><sup>STAR</sup><i>&#256;RIBU</i> (Raven)</td>
<td></td>
<td><notr>Crv</notr></td>
</tr>
<tr valign="top" style="background: #e7e6e6">
<td><notr>45</notr></td>
<td><sup>STAR</sup><i><sup>GOD</sup>&Scaron;ala</i>, ear of grain</td>
<td>The old constellation of the Furrow vanished and left the Maiden (goddess &Scaron;ala) instead. The stable element is the 'ear of grain' as name for the brightest star (Greek Stachys, Latin Spica).</td>
<td><notr>Vir</notr></td>
</tr>
<tr valign="top" style="background: #dee6ef">
<td><notr>46</notr></td>
<td><sup>STAR</sup><i>ZIB&#256;N&#298;TU</i>(Scales)</td>
<td>Since MUL.APIN identifies the Scales with a part (horns) of the Scorpion this constellation vanished in early Greek astronomy and re-appeared only in early Roman times (Almagest and thereafter). We think, that the earlier versions of the Scales should have been a separate constellation and not part of the Scorpion. That's why, we turned it around 180° because in the Babylonian sky culture Virgo (as Furrow as well as the Maiden &Scaron;ala) does not need so much space.</td>
<td>circa Lib</td>
</tr>
<tr valign="top" style="background: #e7e6e6">
<td><notr>47</notr></td>
<td>STAR (of) <sup>GOD</sup>Zababa</td>
<td>Normally identified with the area of Ophiuchus. </td>
<td><notr>Oph</notr></td>
</tr>
<tr valign="top" style="background: #e7e6e6">
<td><notr>48, 49</notr></td>
<td><sup>STAR</sup><i>ER&Ucirc;</i> (Eagle) and <sup>STAR</sup><i>PAGRU</i> (Corpse)</td>
<td>The Eagle (Aql) is connected with a Corpse which reminds on the Almagest figure of the Eagle carrying dead Antinuos. It appears likely that the Eagle, in former times, had been a vulture because vultures are associated with dead bodies and eagles not and in Babylonian mythology an eagle carries preferably a living (not dead) man. Additionally, many early languages do not distinguish eagles and vultures. </td>
<td><notr>Aql +</notr></td>
</tr>
<tr valign="top" style="background: #c6c6c6; color: #ff0000">
<td></td>
<td colspan="3">Path of Anum completed.</td>
</tr>
</tbody>
</table>
<table cellpadding="7" cellspacing="1">
<tbody>
<tr valign="top" style="background: #e6e6e6; font-weight: bold">
<td width="5ex">constellation number</td>
<td>asterism</td>
<td>our commentary</td>
<td>position in the sky</td>
</tr>
<tr valign="top" style="background: #e7e6e6">
<td><notr>54</notr></td>
<td><sup>STAR</sup><i>N&#362;NU</i>(Fish)</td>
<td>Greek "the Great Fish" </td>
<td><notr>PsA</notr></td>
</tr>
<tr valign="top" style="background: #dee6ef">
<td><notr>55</notr></td>
<td>GREAT&middot;STAR: <sup>GOD</sup>Ea</td>
<td>The god of wisdom and witchcraft, Ea, is usually depicted with streams of water springing from his shoulders. For Babylonians this was a clear image of the springs of Euphrates and Tigris. Since this was not cler to the Greek, they named this figure simply "the Man with the Water" or "Water-Carrier".</td>
<td><notr>Aqr</notr></td>
</tr>
<tr valign="top" style="background: #dee6ef">
<td><notr>56</notr></td>
<td>STAR of (the city of) Eridu</td>
<td></td>
<td>Canopus<notr> (&alpha; Car)</notr></td>
</tr>
<tr valign="top" style="background: #dee6ef">
<td><notr>57</notr></td>
<td>STAR to its right: STAR (of) <sup>&lt;GOD&gt;</sup>Ninma&#7723;</td>
<td>Since Canopus is almost opposite Aquarius in the sky, it is unclear where this asterism is to be located.</td>
<td><notr>?</notr></td>
</tr>
<tr valign="top" style="background: #e7e6e6">
<td><notr>58</notr></td>
<td><sup>STAR</sup><i>&#7722;AB(B)A&#7778;&#7778;&#274;R&#256;NU</i></td>
<td>still unclear</td>
<td><notr>?</notr></td>
</tr>
<tr valign="top" style="background: #e7e6e6">
<td><notr>59</notr></td>
<td>STAR to its right: <sup>STAR</sup><i>MA&Scaron;KAK&#256;TU</i>(Harrow), in the centre of which the Aps&ucirc; is visible</td>
<td> still unclear - but maybe the Aps&ucirc; is the southernmost part of the Milky Way. </td>
<td>in<notr> Vela (Aps&ucirc;~MW?)</notr></td>
</tr>
<tr valign="top" style="background: #e7e6e6">
<td><notr>60</notr></td>
<td>2 STAR<sup>s</sup> behind it: <sup>GOD</sup>&Scaron;ullat and <sup>GOD</sup>&#7722;ani&scaron;</td>
<td>no hints, no clue</td>
<td><notr>?</notr></td>
</tr>
<tr valign="top" style="background: #e7e6e6">
<td><notr>61</notr></td>
<td>STAR behind it which lights up like <sup>GOD</sup>Ea (and) sets like Ea: STAR (of) <sup>GOD</sup>Numu&scaron;da</td>
<td>should be an male anthropomorphous figure (a god)</td>
<td><notr>Cen</notr></td>
</tr>
<tr valign="top" style="background: #dee6ef">
<td><notr>62</notr></td>
<td>STAR to the left of <sup>STAR</sup><i>ZUQAQ&#298;PU</i> (Scorpion): <sup>STAR</sup><i>URIDIMMU</i></td>
<td></td>
<td><notr>Lup</notr></td>
</tr>
<tr valign="top" style="background: #dee6ef">
<td><notr>63</notr></td>
<td><sup>STAR</sup><i>ZUQAQ&#298;PU</i></td>
<td></td>
<td><notr>Sco</notr></td>
</tr>
<tr valign="top" style="background: #dee6ef">
<td><notr>64</notr></td>
<td><sup>STAR</sup><i>IRAT&middot;ZUQAQ&#298;PI<br/></i> (Breast of the Scorpion): <sup>GOD</sup>Lisin</td>
<td>single star name</td>
<td>Antares<notr> (&alpha; Sco)</notr></td>
</tr>
<tr valign="top" style="background: #dee6ef">
<td><notr>65</notr></td>
<td>2 STAR<sup>s</sup> on the sting (<i>ZIQTU</i>) of <sup>STAR</sup><i>ZUQAQ&#298;PU</i>: <sup>GOD</sup>&Scaron;arur and <sup>GOD</sup>&Scaron;argaz</td>
<td>Since &Scaron;argaz is an old term for the sting, this is almost clear and re-applied as official modern star name by the IAU 2016.</td>
<td><notr>&lambda;, &nu; Sco</notr></td>
</tr>
<tr valign="top" style="background: #dee6ef">
<td><notr>66</notr></td>
<td>STAR behind them: <sup>GOD</sup>Pabilsa&#285;</td>
<td>The depiction of god Pabilsa&#285; is iconographically clear. It can easily be transformed to a Greek centaur (see Boll, 1903). </td>
<td><notr>Sgr</notr></td>
</tr>
<tr valign="top" style="background: #e7e6e6">
<td><notr>67, 68</notr></td>
<td><sup>STAR</sup><i>MAKURRU</i> (Bark) (and?) <sup>STAR</sup><i>SU&#7722;URM&#256;&Scaron;U</i> (Goat-fish) </td>
<td> Either the Bark was identified with the Goat-Fish implying that both terms designate the same constellation (esp. likely for Old Babylonian epochs before MUL.APIN, hypotheses published by Craig Crossen in Sky&Telescope). Alternatively (and esp. likely for later epochs) the Bark was shifted to the west, under the feet of Pabilsa&#285; (Sagittarius). That explains Eratosthenes's long debate on the illogial image of a centaur standing on a ship. In case The Bark was a standalone constellation, it should be identified with Ptolemy's Southern Crown (Corona Australis).</td>
<td><notr>(CrA &amp;) Cap</notr></td>
</tr>
<tr valign="top" style="background: #c6c6c6;; color: #ff0000">
<td></td>
<td colspan="3">Path of <sup>GOD</sup>Ea completed.</td>
</tr>
</tbody>
</table>
</p>

## References

 - [#1]: Franz Boll (1903), Sphaera. Teubner, Leipzig.
 - [#2]: Craig Crossen (2015), Sky and Telescope, March 2015, p.36-40.
 - [#3]: Hermann Hunger and David Pingree (1999), Astral Science in Mesopotamia, Brill, Leiden.
 - [#4]: Hermann Hunger and John Steele (2018), The Babylonian astronomical compendium MUL.APIN, Routledge, London/ New York.
 - [#5]: Susanne M. Hoffmann (2017), [Hipparchs Himmelsglobus](https://www.springer.com/de/book/9783658186821), Springer, Wiesbaden, New York.
 - [#6]: Susanne M. Hoffmann (2017), *History of Constellations as popularization of uranometry* in: Wolfschmidt, Gudrun [ed.]: [Popularisierung der Astronomie](https://tredition.de/autoren/gudrun-wolfschmidt-1029/popularisierung-der-astronomie-proceedings-der-tagung-des-arbeitskreises-astronomiegeschichte-in-der-astronomischen-gesellschaft-in-bochum-2016-hardcover-91756/), Nuncius Hamburgensis, Bd. 41, Hamburg.
 - [#7]: Alexander Jones (2004), “A Study of Babylonian Observations of Planets Near Normal Stars”, Archive for History of Exact Sciences.
 - [#8]: Jordi Pàmias and Klaus Geus (2007), Eratosthenes: Sternsagen (Catasterismi), Utopica, Oberhaid.
 - [#9]: Many publications on *ziqpu* star lists by Wayne Horowitz, John M. Steele, E. Weidner, J. Koch, and others are compiled or/and discussed in the above books, especially the one by Hunger and Pingree (1999) which is why we do not list them in detail here.

### Thanks to

Thanks to some very enthusiastic planetarium managers for their request and development time in their domes.

 - Dr. Björn Voss (Manager of LWL Planetarium Münster and head of Society of German-speaking Planetariums)
 - Stefan Harnisch (Manager of Planetarium Jena)

## Authors

Artwork by R. Perdok, LWL Planetarium Münster (Germany) and Susanne M Hoffmann (Planetarium Königsleiten, Austria).

The Babylonian star names were compiled and added to Stellarium and

the Babylonian constellation lines were prepared by:

<p><em>Susanne M Hoffmann:   service@uhura-uraniae.com </em></p>

## License

CC BY-ND 4.0
