# Arabic (Al-Sufi)

## Introduction

The Book of Fixed Stars was written shortly before 964 AD. Dr. Paul Kunitzsch described it as "the most outstanding among the works of the prominent astronomer Abu 'l-Ḥusayn 'Abd al-Raḥmān ibn 'Umar al-Şūfi (born in Rayy, 903; died 986), referred to as al-Sufi. In it, al-Şūfī treats the 48 classical constellations, which were established and transmitted in Ptolemy's Almagest. The description of each constellation comprises the following four sections: first, a general discussion of the constellation and its individual stars; this section also includes alŞūfi's criticism of the Ptolemaic tradition and notices of his own observations. Second, a record of the indigenous Arabic star names falling under that constellation, and the exact identification of the respective stars with the corresponding Ptolemaic stars. Third, two drawings of the constellation, one as it is seen on a celestial globe, and the other one as it is seen in the sky. Fourth, a table of the stars making up that constellation, giving a verbal description of each star's location and its longitude, latitude, and magnitude. This table closely follows the arrangement of Ptolemy's star catalogue in the Almagest." [#1]. In addition to the four sections of each constellation mentioned by dr. Kunitzsch, Al-Sufi would identify stars within the 6 magnitudes that were neglected by Ptolemy, but he did not catalogue them and was faithful to Ptolemy star catalog.

## Description

An important aspect of the general discussion section is Al-Sufi method of facilitating the star identification. He describes each individual star in more than way: By the star position related to the constellation figure, by its magnitude, by the asterism it forms with other stars like triangle or arc shapes, sometimes by the star position related to the Milky way, and by the angular distance from a close by star. I have counted more than 700 angular distances measured by al-Sufi in his book. The units he uses for angular distances are cubits, spear length, man-height, span, and finger. Al-Sufi explicitly said in his book that a cubit is equal to two degrees and 20 minutes [#2]. For the other units, Schjellerup concluded some values, but tracking the 700 measurements, I came up with different values. The following table summarizes the units and relationship to the cubit value from Schjellerup[#3] and from my research.

### Angular distance units used by Al-Sufi

<table>
<tr valign="top">
	<td><notr>&nbsp;</notr></td>
	<td colspan="2" style="text-align:center;"><b>Schjellerup</b></td>
	<td colspan="2" style="text-align:center;"><b>Khalid</b></td>
</tr>
<tr valign="top">
	<td><b>unit</b></td>
	<td><b>cubits</b></td>
	<td><b>Angular Value</b></td>
	<td><b>cubits</b></td>
	<td><b>Angular Value</b></td>
</tr>
<tr valign="top">
	<td>spear</td>
	<td>6 cubits</td>
	<td><notr>14°</notr></td>
	<td>6 cubits</td>
	<td><notr>14°</notr></td>
</tr>
<tr valign="top">
	<td>Man-Height</td>
	<td></td>
	<td></td>
	<td>3 cubits</td>
	<td><notr>7°</notr></td>
</tr>
<tr valign="top">
	<td>cubit</td>
	<td>1 cubit</td>
	<td><notr>2°20'</notr></td>
	<td>1 cubit</td>
	<td><notr>2°20'</notr></td>
</tr>
<tr valign="top">
	<td>span</td>
	<td>1/3 of a cubit</td>
	<td><notr>47'</notr></td>
	<td>1/2 of a cubit</td>
	<td><notr>1°10'</notr></td>
</tr>
<tr valign="top">
	<td>finger</td>
	<td>1/32 of a cubit</td>
	<td><notr>4.4'</notr></td>
	<td>1/16 of a cubit</td>
	<td><notr>8.75'</notr></td>
</tr>
</table>

Another important aspect of Al-Sufi book is his record of the indigenous Arabic star names falling under each constellation, and the exact identification of the respective stars with the corresponding Ptolemaic stars. This means that we are looking at two layers of stars knowledge at the same time: the Ptolemaic one and the indigenous Arab one.

### The Sky Culture

This sky culture is a result of a research done on several manuscripts of the book, oldest of which is the [#8].

First, the manuscripts of the Book of Fixed Stars were critically edited, and the text was produced. Second, each member star of the 48 constellations was identified according to Al-Sufi description, and new tables were built including modern star designations from the Hipparcos, Bright stars, and Bayer catalogues. Third, Arab indigenous star names were collected and identified as mapped by Al-Sufi to the Ptolemaic ones. All the previous steps were included in a book published digitally of the Book of Fixed Stars plus explanations and commentary by Khalid Al-Ajaji[#4].

The sky culture stick figures of the constellations are the images in the Ulugh Beg manuscript of the Book of Fixed Stars, extracted, and adapted for Stellarium by Mr. Kutaibaa Akraa [#5]. The star names file includes the star number in the constellation as the primary star name and the description of the star in the tables as a secondary name. For example, Polaris primary name that is displayed with the star is: UMi1, UMi being Ursa Minor and 1 is the first star of this constellation. If the star is selected other secondary names are displayed, which will display "The star on the end of the tail" on the top of the screen. The constellation lines are constructed according to the constellation shapes with an attempt to include most of the member stars. For indigenous Arab star knowledge, individual star names were added to the star file as secondary names, while names of group of stars were defined through asterism names and asterism lines files.

The translation of star descriptions from Arabic into English was extracted from Ernie Wright website[#6] which was transcribed from Toomer's translation of the Almagest[#7]. The translation was modified in a few places to agree with Al-Sufi wording.

The single source of the sky culture is the Book of Fixed Stars and the objective is to give a faithful representation of the book content.

## Authors

This sky culture was compiled and added to Stellarium by Khalid Al-Ajaji: turath.alfalak@gmail.com

## References

 - [#1]: The Arabs and the Stars, Paul Kunitzsch,The Astronomer Abu'L-Husayn Al-Sufi And His Book On The Constellations, XI, pg 57. Northampton [England]: Variorum Reprints, 1989.
 - [#2]: See Al-Sufi description in his book of the 14th star in Auriga.
 - [#3]: DESCRIPTIONS DES ETOILES FIXES, traduction littérale avec des notes par H C F C Schjellerup, St Petersbourg, 1874, pg 26-27.
 - [#4]: [Book of Fixed Stars: Critical edition with commentary by Khalid AlAjaji](https://drive.google.com/drive/folders/1s6JXzftwjMQ5rgZoGE3718EtBLBZtjzr?usp=sharing).
 - [#5]: [Oulough Beg copy of ʿAbd al-Raḥmān ibn ʿUmar al-Ṣūfī. Kitāb ṣuwar al-kawākib al-ṯābita, Paris, Bibliothèque nationale de France Ms. Arabe 5036](https://gallica.bnf.fr/ark:/12148/btv1b60006156.r=.langEN).
 - [#6]: [Seeing Ancient Stars, Visualization of the Almagest Catalog](http://www.etwright.org/astro/almagest.html#cat).
 - [#7]: Ptolemy’s ALMAGEST, G. J. Toomer, Princeton University Press, 2nd ed., 1998.
 - [#8]: [Oxford, Bodleian Library Ms. Marsh 144 dated 1009 AD](https://iiif.bodleian.ox.ac.uk/iiif/viewer/c1caa84c-f6d2-483f-9eb4-2439cccdc801#?c=0&m=0&s=0&cv=25&r=0&xywh=-4815%2C-378%2C14782%2C7535)

## License

CC BY-ND 4.0
