/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Objects;
import org.firebirdsql.gds.ng.FbBlob;
import org.firebirdsql.gds.ng.LockCloseable;
import org.firebirdsql.jdbc.FBBlob;
import org.firebirdsql.jdbc.FirebirdBlob;
import org.firebirdsql.util.ByteArrayHelper;
import org.firebirdsql.util.IOUtils;

public final class FBBlobInputStream
extends InputStream
implements FirebirdBlob.BlobInputStream {
    private byte[] buffer = ByteArrayHelper.emptyByteArray();
    private FbBlob blobHandle;
    private int pos;
    private int lim;
    private boolean closed;
    private final FBBlob owner;

    FBBlobInputStream(FBBlob owner) throws SQLException {
        if (owner.isNew()) {
            throw new SQLException("Cannot read a new blob", "0F000");
        }
        this.owner = owner;
        this.blobHandle = owner.openBlob();
    }

    @Override
    public FirebirdBlob getBlob() {
        return this.owner;
    }

    @Override
    public void seek(int position) throws IOException {
        this.seek(position, FbBlob.SeekMode.ABSOLUTE);
    }

    @Override
    public void seek(int position, int seekMode) throws IOException {
        this.seek(position, FbBlob.SeekMode.getById(seekMode));
    }

    public void seek(int position, FbBlob.SeekMode seekMode) throws IOException {
        try (LockCloseable ignored = this.owner.withLock();){
            this.checkClosed();
            this.blobHandle.seek(position, seekMode);
        }
        catch (SQLException ex) {
            throw new IOException(ex.getMessage(), ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long length() throws IOException {
        try (LockCloseable ignored = this.owner.withLock();){
            this.checkClosed();
            long l = this.blobHandle.length();
            return l;
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    @Override
    public int available() throws IOException {
        return this.lim - this.pos;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int checkBuffer() throws IOException {
        try (LockCloseable ignored = this.owner.withLock();){
            this.checkClosed();
            if (this.pos < this.lim) {
                int n = this.lim - this.pos;
                return n;
            }
            if (this.blobHandle.isEof()) {
                int n = -1;
                return n;
            }
            byte[] buffer = this.requireBuffer();
            this.lim = this.blobHandle.get(buffer, 0, buffer.length, 0.9f);
            this.pos = 0;
            int n = this.lim > 0 ? this.lim : -1;
            return n;
        }
        catch (SQLException e) {
            if (!(e.getCause() instanceof IOException)) throw FBBlobInputStream.blobReadProblem(e);
            throw (IOException)e.getCause();
        }
    }

    private static IOException blobReadProblem(Exception e) {
        return new IOException("Blob read problem: " + e, e);
    }

    private byte[] requireBuffer() {
        byte[] buffer = this.buffer;
        if (buffer.length > 0) {
            return buffer;
        }
        this.buffer = new byte[this.owner.getBufferLength()];
        return this.buffer;
    }

    @Override
    public int read() throws IOException {
        if (this.checkBuffer() == -1) {
            return -1;
        }
        return this.buffer[this.pos++] & 0xFF;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        IOUtils.checkFromIndexSize(off, len, b.length);
        if (len == 0) {
            return 0;
        }
        try (LockCloseable ignored = this.owner.withLock();){
            int avail;
            this.checkClosed();
            int smallBufferLimit = Math.min(this.owner.getBufferLength(), this.blobHandle.getMaximumSegmentSize()) / 2;
            int n = avail = len <= smallBufferLimit ? this.checkBuffer() : this.available();
            if (avail == -1) {
                int n2 = -1;
                return n2;
            }
            int count = Math.min(avail, len);
            if (count > 0) {
                System.arraycopy(this.buffer, this.pos, b, off, count);
                this.pos += count;
                if (len - count < smallBufferLimit) {
                    int n3 = count;
                    return n3;
                }
            }
            if (count < len) {
                count += this.blobHandle.get(b, off + count, len - count, 0.9f);
            }
            int n4 = count == 0 ? -1 : count;
            return n4;
        }
        catch (SQLException e) {
            if (!(e.getCause() instanceof IOException)) throw FBBlobInputStream.blobReadProblem(e);
            throw (IOException)e.getCause();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int readNBytes(byte[] b, int off, int len) throws IOException {
        IOUtils.checkFromIndexSize(off, len, b.length);
        if (len == 0) {
            return 0;
        }
        try (LockCloseable ignored = this.owner.withLock();){
            this.checkClosed();
            int count = Math.min(this.available(), len);
            if (count > 0) {
                System.arraycopy(this.buffer, this.pos, b, off, count);
                this.pos += count;
                if (count == len) {
                    int n = len;
                    return n;
                }
            }
            int n = count + this.blobHandle.get(b, off + count, len - count);
            return n;
        }
        catch (SQLException e) {
            if (!(e.getCause() instanceof IOException)) throw FBBlobInputStream.blobReadProblem(e);
            throw (IOException)e.getCause();
        }
    }

    @Override
    public byte[] readNBytes(int len) throws IOException {
        if (len < 0) {
            throw new IllegalArgumentException("len < 0");
        }
        if (len > 2 * this.blobHandle.getMaximumSegmentSize()) {
            len = (int)Math.min((long)len, this.length() - (long)this.pos);
        }
        if (len > 0x7FFFFFF7) {
            throw new OutOfMemoryError("Required array size too large");
        }
        byte[] bytes = new byte[len];
        int read = this.readNBytes(bytes, 0, len);
        if (read == len) {
            return bytes;
        }
        return Arrays.copyOf(bytes, read);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        int read = this.readNBytes(b, off, len);
        if (read != len) {
            throw new EOFException(String.format("End-of-blob reached after reading %d bytes, required %d bytes", read, len));
        }
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    @Override
    public long transferTo(OutputStream out) throws IOException {
        Objects.requireNonNull(out, "out");
        Throwable throwable = null;
        try (LockCloseable ignored = this.owner.withLock();){
            this.checkClosed();
            int read = this.checkBuffer();
            if (read == -1) {
                long l = 0L;
                return l;
            }
            byte[] buffer = this.requireBuffer();
            if (read != 0) {
                out.write(buffer, this.pos, read);
                this.lim = 0;
                this.pos = 0;
            }
            try {
                long transferred = read;
                while (!this.blobHandle.isEof()) {
                    read = this.blobHandle.get(buffer, 0, buffer.length, 0.9f);
                    out.write(buffer, 0, read);
                    transferred += (long)read;
                }
                long l = transferred;
                return l;
            }
            catch (SQLException e) {
                try {
                    if (e.getCause() instanceof IOException) {
                        throw (IOException)e.getCause();
                    }
                    throw FBBlobInputStream.blobReadProblem(e);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
    }

    @Override
    public void close() throws IOException {
        try (LockCloseable ignored = this.owner.withLock();){
            if (this.blobHandle == null) {
                return;
            }
            try {
                this.blobHandle.close();
                this.owner.notifyClosed(this);
            }
            catch (SQLException e) {
                throw new IOException("Couldn't close blob: " + e, e);
            }
            finally {
                this.blobHandle = null;
                this.closed = true;
                this.buffer = ByteArrayHelper.emptyByteArray();
                this.pos = 0;
                this.lim = 0;
            }
        }
    }

    private void checkClosed() throws IOException {
        if (this.closed) {
            throw new IOException("Input stream is already closed.");
        }
    }
}

