/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.bytecode_dsl;

import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.common.EconomicMapStorage;
import com.oracle.graal.python.builtins.objects.common.ObjectHashMap;
import com.oracle.graal.python.lib.PyObjectHashNode;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedIntValueProfile;

@GenerateInline
@GenerateUncached
@GenerateCached(value=false)
public abstract class MakeSetStorageNode
extends Node {
    public abstract EconomicMapStorage execute(VirtualFrame var1, Node var2, Object[] var3);

    @Specialization
    public static EconomicMapStorage doNonEmpty(VirtualFrame frame, Node inliningTarget, Object[] elements, @Cached InlinedIntValueProfile lengthProfile, @Cached PyObjectHashNode hashNode, @Cached ObjectHashMap.PutNode putNode) {
        int profiledLen = lengthProfile.profile(inliningTarget, elements.length);
        ObjectHashMap map = new ObjectHashMap(profiledLen);
        for (int i = 0; i < profiledLen; ++i) {
            Object key = elements[i];
            long keyHash = hashNode.execute((Frame)frame, inliningTarget, key);
            putNode.put((Frame)frame, inliningTarget, map, key, keyHash, PNone.NONE);
        }
        return new EconomicMapStorage(map, false);
    }
}

