/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.multiprocessing;

import com.oracle.graal.python.builtins.objects.thread.AbstractPythonLock;
import com.oracle.graal.python.builtins.objects.thread.PThread;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleSafepoint;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

public final class PGraalPySemLock
extends AbstractPythonLock {
    public static final int RECURSIVE_MUTEX = 0;
    public static final int SEMAPHORE = 1;
    private final Semaphore semaphore;
    private final int kind;
    private final TruffleString name;
    private long lastThreadID = -1L;
    private int count;

    public PGraalPySemLock(Object cls, Shape instanceShape, TruffleString name, int kind, Semaphore sharedSemaphore) {
        super(cls, instanceShape);
        this.name = name;
        this.semaphore = sharedSemaphore;
        this.kind = kind;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    protected boolean acquireNonBlocking() {
        boolean ret = this.semaphore.tryAcquire();
        if (ret) {
            this.lastThreadID = PThread.getThreadId(Thread.currentThread());
            ++this.count;
        }
        return ret;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    protected boolean acquireBlocking(Node node) {
        boolean[] b = new boolean[1];
        TruffleSafepoint.setBlockedThreadInterruptible((Node)node, s -> {
            s.acquire();
            b[0] = true;
        }, (Object)this.semaphore);
        if (b[0]) {
            this.lastThreadID = PThread.getThreadId(Thread.currentThread());
            ++this.count;
        }
        return b[0];
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    protected boolean acquireTimeout(Node node, long timeout) {
        boolean[] b = new boolean[1];
        TruffleSafepoint.setBlockedThreadInterruptible((Node)node, s -> {
            b[0] = s.tryAcquire(timeout, TimeUnit.MILLISECONDS);
        }, (Object)this.semaphore);
        if (b[0]) {
            this.lastThreadID = PThread.getThreadId(Thread.currentThread());
            ++this.count;
        }
        return b[0];
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public void release() {
        this.semaphore.release();
        --this.count;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean locked() {
        return this.semaphore.availablePermits() == 0;
    }

    @CompilerDirectives.TruffleBoundary
    public int getValue() {
        return this.semaphore.availablePermits();
    }

    public int getCount() {
        return this.count;
    }

    public void increaseCount() {
        ++this.count;
        this.lastThreadID = PThread.getThreadId(Thread.currentThread());
    }

    public void decreaseCount() {
        --this.count;
    }

    @CompilerDirectives.TruffleBoundary
    public boolean isMine() {
        return this.count > 0 && this.lastThreadID == PThread.getThreadId(Thread.currentThread());
    }

    public boolean isZero() {
        return this.semaphore.availablePermits() == 0;
    }

    public int getKind() {
        return this.kind;
    }

    public TruffleString getName() {
        return this.name;
    }
}

