/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.pegparser.scope;

import com.oracle.graal.python.pegparser.tokenizer.SourceRange;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class Scope {
    HashMap<String, EnumSet<DefUse>> symbols = new HashMap();
    private List<String> sortedSymbols;
    String name;
    ArrayList<String> varnames = new ArrayList();
    ArrayList<Scope> children = new ArrayList();
    HashMap<String, SourceRange> directives = new HashMap();
    ScopeType type;
    HashSet<String> mangledNames;
    EnumSet<ScopeFlags> flags = EnumSet.noneOf(ScopeFlags.class);
    int comprehensionIterExpression = 0;
    ComprehensionType comprehensionType = ComprehensionType.NoComprehension;
    SourceRange sourceRange;

    Scope(String name, ScopeType type, SourceRange sourceRange) {
        this.name = name;
        this.type = type;
        this.sourceRange = sourceRange;
    }

    public String toString() {
        return this.toString(0);
    }

    String toString(int indent) {
        int i;
        StringBuilder sb = new StringBuilder();
        for (i = 0; i < indent; ++i) {
            sb.append("  ");
        }
        sb.append("Scope ").append(this.name).append(" ").append((Object)this.type);
        if (!this.flags.isEmpty()) {
            sb.append('\n');
            for (i = 0; i < indent; ++i) {
                sb.append("    ");
            }
            sb.append("Flags: ").append(this.flags);
        }
        if (!this.varnames.isEmpty()) {
            sb.append('\n');
            for (i = 0; i < indent; ++i) {
                sb.append("    ");
            }
            sb.append("Varnames: ").append(this.varnames.get(0));
            for (i = 1; i < this.varnames.size(); ++i) {
                sb.append(", ").append(this.varnames.get(i));
            }
        }
        if (!this.symbols.isEmpty()) {
            sb.append('\n');
            for (i = 0; i < indent; ++i) {
                sb.append("    ");
            }
            sb.append("Symbols:");
            for (String k : this.getSortedSymbols()) {
                sb.append('\n');
                for (int i2 = 0; i2 < indent; ++i2) {
                    sb.append("      ");
                }
                sb.append(k).append(": ").append(this.symbols.get(k));
            }
        }
        for (Scope child : this.children) {
            sb.append("\n").append(child.toString(indent + 1));
        }
        return sb.toString();
    }

    void recordDirective(String directiveName, SourceRange directiveSourceRange) {
        this.directives.put(directiveName, directiveSourceRange);
    }

    SourceRange getDirective(String directiveName) {
        SourceRange range = this.directives.get(directiveName);
        assert (range != null) : "BUG: internal directive bookkeeping broken";
        return range;
    }

    public String getName() {
        return this.name;
    }

    public ArrayList<String> getVarnames() {
        return this.varnames;
    }

    private List<String> getSortedSymbols() {
        if (this.sortedSymbols == null) {
            this.sortedSymbols = new ArrayList<String>(this.symbols.keySet());
            this.sortedSymbols.sort(String::compareTo);
        }
        return this.sortedSymbols;
    }

    public boolean needsClassClosure() {
        return this.flags.contains((Object)ScopeFlags.NeedsClassClosure);
    }

    public boolean needsClassDict() {
        return this.flags.contains((Object)ScopeFlags.NeedsClassDict);
    }

    public boolean canSeeClassScope() {
        return this.flags.contains((Object)ScopeFlags.CanSeeClassScope);
    }

    public boolean isFunction() {
        return this.type.isFunctionLike();
    }

    public boolean isTypeParam() {
        return this.type == ScopeType.TypeParam;
    }

    public boolean isClass() {
        return this.type == ScopeType.Class;
    }

    public boolean isModule() {
        return this.type == ScopeType.Module;
    }

    public boolean isGenerator() {
        return this.flags.contains((Object)ScopeFlags.IsGenerator);
    }

    public boolean isCoroutine() {
        return this.flags.contains((Object)ScopeFlags.IsCoroutine);
    }

    public boolean isNested() {
        return this.flags.contains((Object)ScopeFlags.IsNested);
    }

    public HashMap<String, Integer> getSymbolsByType(EnumSet<DefUse> expectedFlags, int start) {
        return this.getSymbolsByType(expectedFlags, EnumSet.noneOf(DefUse.class), start);
    }

    public HashMap<String, Integer> getSymbolsByType(EnumSet<DefUse> expectedFlags, EnumSet<DefUse> unexpectedFlags, int start) {
        int i = start;
        HashMap<String, Integer> mapping = new HashMap<String, Integer>();
        for (String key : this.getSortedSymbols()) {
            EnumSet<DefUse> keyFlags = this.getUseOfName(key);
            if (Collections.disjoint(expectedFlags, keyFlags) || !Collections.disjoint(unexpectedFlags, keyFlags)) continue;
            mapping.put(key, i++);
        }
        return mapping;
    }

    public EnumSet<DefUse> getUseOfName(String usedName) {
        return this.symbols.getOrDefault(usedName, EnumSet.noneOf(DefUse.class));
    }

    public ArrayList<Scope> getChildren() {
        return this.children;
    }

    static enum ScopeFlags {
        IsNested,
        HasFreeVars,
        HasChildWithFreeVars,
        IsGenerator,
        IsCoroutine,
        IsComprehension,
        HasVarArgs,
        HasVarKeywords,
        ReturnsAValue,
        NeedsClassClosure,
        NeedsClassDict,
        IsVisitingIterTarget,
        CanSeeClassScope;

    }

    static enum ComprehensionType {
        NoComprehension,
        ListComprehension,
        DictComprehension,
        SetComprehension,
        GeneratorExpression;

    }

    static enum ScopeType {
        Function,
        Class,
        Module,
        Annotation,
        TypeVarBound,
        TypeAlias,
        TypeParam;


        boolean isFunctionLike() {
            return this == Function || this == TypeVarBound || this == TypeAlias || this == TypeParam;
        }
    }

    public static enum DefUse {
        DefGlobal,
        DefLocal,
        DefParam,
        DefNonLocal,
        Use,
        DefFree,
        DefFreeClass,
        DefImport,
        DefAnnot,
        DefCompIter,
        DefTypeParam,
        Local,
        GlobalExplicit,
        GlobalImplicit,
        Free,
        Cell;

        static EnumSet<DefUse> DefBound;

        static {
            DefBound = EnumSet.of(DefLocal, DefParam, DefImport);
        }
    }
}

