/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.util;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.modules.MathGuards;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.lib.PyIndexCheckNode;
import com.oracle.graal.python.lib.PyNumberIndexNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import java.math.BigInteger;

@GenerateUncached
@GenerateInline(inlineByDefault=true)
@GenerateCached
@ImportStatic(value={MathGuards.class})
public abstract class CastToJavaBigIntegerNode
extends Node {
    public abstract BigInteger execute(Node var1, boolean var2);

    public abstract BigInteger execute(Node var1, int var2);

    public abstract BigInteger execute(Node var1, long var2);

    public abstract BigInteger execute(Node var1, Object var2);

    @Specialization
    @CompilerDirectives.TruffleBoundary
    protected static BigInteger fromBoolean(boolean x) {
        return x ? BigInteger.ONE : BigInteger.ZERO;
    }

    @Specialization
    @CompilerDirectives.TruffleBoundary
    protected static BigInteger fromInt(int x) {
        return BigInteger.valueOf(x);
    }

    @Specialization
    @CompilerDirectives.TruffleBoundary
    protected static BigInteger fromLong(long x) {
        return BigInteger.valueOf(x);
    }

    @Specialization
    protected static BigInteger fromPInt(PInt x) {
        return x.getValue();
    }

    @Specialization
    protected static BigInteger generic(Node inliningTarget, Object x, @Cached PRaiseNode raise, @Cached(inline=false) CastToJavaBigIntegerNode rec, @Cached GetClassNode getClassNode, @Cached PyIndexCheckNode indexCheckNode, @Cached PyNumberIndexNode indexNode) {
        if (indexCheckNode.execute(inliningTarget, x)) {
            return rec.execute(null, indexNode.execute(null, inliningTarget, x));
        }
        throw raise.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.OBJ_CANNOT_BE_INTERPRETED_AS_INTEGER, getClassNode.execute(inliningTarget, x));
    }
}

