/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.options;

import java.util.Objects;
import schemacrawler.schemacrawler.OptionsBuilder;
import schemacrawler.tools.options.Config;
import schemacrawler.tools.options.ConfigOptionsBuilder;
import schemacrawler.tools.options.LanguageOptions;
import us.fatehi.utility.IOUtility;
import us.fatehi.utility.Utility;

public abstract class LanguageOptionsBuilder<O extends LanguageOptions>
implements OptionsBuilder<LanguageOptionsBuilder<O>, O>,
ConfigOptionsBuilder<LanguageOptionsBuilder<O>, O> {
    private final String defaultLanguage;
    private final String languageKey;
    private final String resourceKey;
    private String language;
    private String script;

    protected LanguageOptionsBuilder(String languageKey, String resourceKey, String defaultLanguage) {
        this.languageKey = Objects.requireNonNull(languageKey, "No language key provided");
        this.resourceKey = Objects.requireNonNull(resourceKey, "No resource key provided");
        this.defaultLanguage = Objects.requireNonNull(defaultLanguage, "No default language provided");
    }

    public LanguageOptionsBuilder<O> fromConfig(Config config) {
        this.script = this.getScript(config);
        this.language = this.getLanguage(config);
        return this;
    }

    public LanguageOptionsBuilder<O> fromOptions(LanguageOptions options) {
        if (options != null) {
            this.language = options.getLanguage();
            this.script = options.getScript();
        }
        return this;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getScript() {
        return this.script;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public void setScript(String script) {
        this.script = script;
    }

    public Config toConfig() {
        throw new UnsupportedOperationException();
    }

    private final String getLanguage(Config config) {
        String language = config.getStringValue(this.languageKey, null);
        if (!Utility.isBlank((CharSequence)language)) {
            return language;
        }
        String fileExtension = IOUtility.getFileExtension((String)this.script);
        if (!Utility.isBlank((CharSequence)fileExtension)) {
            return fileExtension;
        }
        return this.defaultLanguage;
    }

    private String getScript(Config config) {
        return config.getStringValue(this.resourceKey, null);
    }
}

