/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.internal.core;

import com.ibm.db2.cmx.internal.core.ConnectionImpl;
import com.ibm.db2.cmx.internal.core.CoreProcessor;
import com.ibm.db2.cmx.internal.core.Message;
import com.ibm.db2.cmx.internal.core.ProcessingException;
import com.ibm.db2.cmx.internal.core.Processor;
import com.ibm.db2.cmx.internal.core.Reply;
import com.ibm.db2.cmx.runtime.internal.trace.DataLogger;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MessageReader
implements Runnable {
    private Logger logger_ = null;
    Reply reply_ = null;
    ConnectionImpl cmxConnection_ = null;

    public MessageReader(ConnectionImpl connectionImpl) {
        this.cmxConnection_ = connectionImpl;
        this.reply_ = new Reply(connectionImpl);
        this.logger_ = connectionImpl.logger_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block10: while (true) {
            try {
                try {
                    while (true) {
                        Message message;
                        Message message2 = this.reply_.parseReply();
                        if (this.reply_.getType() == 2) {
                            if (this.logger_.isLoggable(Level.FINEST)) {
                                DataLogger.logMonitorBuffer(this.logger_, this, "run", "Reply received, processor: " + message2.getProcessorName() + " payload(UTF-8): ", message2);
                            }
                            this.cmxConnection_.setReply(message2);
                            continue;
                        }
                        try {
                            Processor processor;
                            if (this.logger_.isLoggable(Level.FINEST)) {
                                DataLogger.logMonitorBuffer(this.logger_, this, "run", "Message received, processor: " + message2.getProcessorName() + " payload(UTF-8): ", message2);
                            }
                            if ((processor = message2.getProcessorName().equals("CMXCoreProcessor") ? this.cmxConnection_.coreProcessor_ : this.cmxConnection_.supportedProcessors_.get(message2.getProcessorName())) == null) {
                                throw new ProcessingException("processor not found: " + message2.getProcessorName());
                            }
                            if (this.reply_.getType() == 1) {
                                message = processor.processRequest(message2, this.cmxConnection_);
                                if (message == null) {
                                    message = new Message(message2.getProcessorName(), ByteBuffer.allocate(0));
                                }
                                this.cmxConnection_.flushMessage(message, (byte)2);
                                continue block10;
                            }
                            if (this.reply_.getType() != 3) continue block10;
                            processor.processAsynchronousMessage(message2, this.cmxConnection_);
                            continue block10;
                        }
                        catch (Exception exception) {
                            DataLogger.logTrappedMonitoringException(this.logger_, this, "run", exception, null);
                            if (this.reply_.getType() != 1) continue;
                            message = CoreProcessor.createErrorReply(exception.getMessage(), -1);
                            this.cmxConnection_.flushMessage(message, (byte)2);
                            continue;
                        }
                        break;
                    }
                }
                catch (IOException iOException) {
                    if (this.logger_.isLoggable(Level.FINE)) {
                        this.logger_.log(Level.FINER, "Message loop exits: ", iOException);
                    }
                    if (this.logger_.isLoggable(Level.FINE)) {
                        DataLogger.logConnectedComponents(this.logger_, this, "run", "Disconnecting connection: " + this.cmxConnection_);
                    }
                    try {
                        this.cmxConnection_.close();
                    }
                    catch (Exception exception) {
                        DataLogger.logTrappedMonitoringException(this.logger_, this, "run", exception, null);
                    }
                    this.cmxConnection_.messageReaderThread_ = null;
                    break;
                }
            }
            catch (Throwable throwable) {
                if (this.logger_.isLoggable(Level.FINE)) {
                    DataLogger.logConnectedComponents(this.logger_, this, "run", "Disconnecting connection: " + this.cmxConnection_);
                }
                try {
                    this.cmxConnection_.close();
                }
                catch (Exception exception) {
                    DataLogger.logTrappedMonitoringException(this.logger_, this, "run", exception, null);
                }
                this.cmxConnection_.messageReaderThread_ = null;
                throw throwable;
            }
        }
    }
}

