/* Automatically generated by /build/sagemath/src/sage/src/sage_setup/autogen/interpreters/internal/generator.py.  Do not edit! */
#include <Python.h>


#include <stdlib.h>
#include <complex.h>

/* On Solaris, we need to define _Imaginary_I when compiling with GCC,
 * otherwise the constant I doesn't work. The definition below is based
 * on glibc. */
#ifdef __GNUC__
#undef  _Imaginary_I
#define _Imaginary_I  (__extension__ 1.0iF)
#endif

typedef double complex double_complex;

static inline double complex csquareX(double complex z) {
    double complex res;
    __real__(res) = __real__(z) * __real__(z) - __imag__(z) * __imag__(z);
    __imag__(res) = 2 * __real__(z) * __imag__(z);
    return res;
}

static inline double complex cpow_int(double complex z, int exp) {
    if (exp < 0) return 1/cpow_int(z, -exp);
    switch (exp) {
        case 0: return 1;
        case 1: return z;
        case 2: return csquareX(z);
        case 3: return csquareX(z) * z;
        case 4:
        case 5:
        case 6:
        case 7:
        case 8:
        {
            double complex z2 = csquareX(z);
            double complex z4 = csquareX(z2);
            if (exp == 4) return z4;
            if (exp == 5) return z4 * z;
            if (exp == 6) return z4 * z2;
            if (exp == 7) return z4 * z2 * z;
            if (exp == 8) return z4 * z4;
        }
    }
    if (cimag(z) == 0) return pow(creal(z), exp);
    if (creal(z) == 0) {
        double r = pow(cimag(z), exp);
        switch (exp % 4) {
            case 0:
                return r;
            case 1:
                return r * I;
            case 2:
                return -r;
            default /* case 3 */:
                return -r * I;
        }
    }
    return cpow(z, exp);
}

double_complex interp_cdf(double_complex* args,
        double_complex* constants,
        PyObject** py_constants,
        double_complex* stack,
        int* code) {
  while (1) {
    switch (*code++) {
    case 0: /* load_arg */
      {
        int ai0 = *code++;
        double_complex i0 = args[ai0];
        double_complex o0;
        o0 = i0;
        *stack++ = o0;
      }
      break;
    case 1: /* load_const */
      {
        int ai0 = *code++;
        double_complex i0 = constants[ai0];
        double_complex o0;
        o0 = i0;
        *stack++ = o0;
      }
      break;
    case 2: /* return */
      {
        double_complex i0 = *--stack;
        return i0;
      }
      break;
    case 3: /* py_call */
      {
        int ai0 = *code++;
        PyObject* i0 = py_constants[ai0];
        int n_i1 = *code++;
        stack -= n_i1;
        double_complex* i1 = stack;
        double_complex o0;

        if (!cdf_py_call_helper(i0, n_i1, i1, &o0)) {
          goto error;
        }
        *stack++ = o0;
      }
      break;
    case 4: /* add */
      {
        double_complex i1 = *--stack;
        double_complex i0 = *--stack;
        double_complex o0;
        o0 = i0 + i1;
        *stack++ = o0;
      }
      break;
    case 5: /* sub */
      {
        double_complex i1 = *--stack;
        double_complex i0 = *--stack;
        double_complex o0;
        o0 = i0 - i1;
        *stack++ = o0;
      }
      break;
    case 6: /* mul */
      {
        double_complex i1 = *--stack;
        double_complex i0 = *--stack;
        double_complex o0;
        o0 = i0 * i1;
        *stack++ = o0;
      }
      break;
    case 7: /* div */
      {
        double_complex i1 = *--stack;
        double_complex i0 = *--stack;
        double_complex o0;
        o0 = i0 / i1;
        *stack++ = o0;
      }
      break;
    case 8: /* truediv */
      {
        double_complex i1 = *--stack;
        double_complex i0 = *--stack;
        double_complex o0;
        o0 = i0 / i1;
        *stack++ = o0;
      }
      break;
    case 9: /* pow */
      {
        double_complex i1 = *--stack;
        double_complex i0 = *--stack;
        double_complex o0;
        o0 = cpow(i0, i1);
        *stack++ = o0;
      }
      break;
    case 10: /* ipow */
      {
        int i1 = *code++;
        double_complex i0 = *--stack;
        double_complex o0;
        o0 = cpow_int(i0, i1);
        *stack++ = o0;
      }
      break;
    case 11: /* neg */
      {
        double_complex i0 = *--stack;
        double_complex o0;
        o0 = -i0;
        *stack++ = o0;
      }
      break;
    case 12: /* invert */
      {
        double_complex i0 = *--stack;
        double_complex o0;
        o0 = 1/i0;
        *stack++ = o0;
      }
      break;
    case 13: /* abs */
      {
        double_complex i0 = *--stack;
        double_complex o0;
        o0 = cabs(i0);
        *stack++ = o0;
      }
      break;
    case 14: /* sqrt */
      {
        double_complex i0 = *--stack;
        double_complex o0;
        o0 = csqrt(i0);
        *stack++ = o0;
      }
      break;
    case 15: /* sin */
      {
        double_complex i0 = *--stack;
        double_complex o0;
        o0 = csin(i0);
        *stack++ = o0;
      }
      break;
    case 16: /* cos */
      {
        double_complex i0 = *--stack;
        double_complex o0;
        o0 = ccos(i0);
        *stack++ = o0;
      }
      break;
    case 17: /* tan */
      {
        double_complex i0 = *--stack;
        double_complex o0;
        o0 = ctan(i0);
        *stack++ = o0;
      }
      break;
    case 18: /* asin */
      {
        double_complex i0 = *--stack;
        double_complex o0;
        o0 = casin(i0);
        *stack++ = o0;
      }
      break;
    case 19: /* acos */
      {
        double_complex i0 = *--stack;
        double_complex o0;
        o0 = cacos(i0);
        *stack++ = o0;
      }
      break;
    case 20: /* atan */
      {
        double_complex i0 = *--stack;
        double_complex o0;
        o0 = catan(i0);
        *stack++ = o0;
      }
      break;
    case 21: /* sinh */
      {
        double_complex i0 = *--stack;
        double_complex o0;
        o0 = csinh(i0);
        *stack++ = o0;
      }
      break;
    case 22: /* cosh */
      {
        double_complex i0 = *--stack;
        double_complex o0;
        o0 = ccosh(i0);
        *stack++ = o0;
      }
      break;
    case 23: /* tanh */
      {
        double_complex i0 = *--stack;
        double_complex o0;
        o0 = ctanh(i0);
        *stack++ = o0;
      }
      break;
    case 24: /* asinh */
      {
        double_complex i0 = *--stack;
        double_complex o0;
        o0 = casinh(i0);
        *stack++ = o0;
      }
      break;
    case 25: /* acosh */
      {
        double_complex i0 = *--stack;
        double_complex o0;
        o0 = cacosh(i0);
        *stack++ = o0;
      }
      break;
    case 26: /* atanh */
      {
        double_complex i0 = *--stack;
        double_complex o0;
        o0 = catanh(i0);
        *stack++ = o0;
      }
      break;
    case 27: /* exp */
      {
        double_complex i0 = *--stack;
        double_complex o0;
        o0 = cexp(i0);
        *stack++ = o0;
      }
      break;
    case 28: /* log */
      {
        double_complex i0 = *--stack;
        double_complex o0;
        o0 = clog(i0);
        *stack++ = o0;
      }
      break;
    }
  }
error:
  return -1094648119105371;
}

