/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.eel.impl.local;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.platform.eel.EelArchiveApi;
import com.intellij.platform.eel.EelDescriptor;
import com.intellij.platform.eel.EelExecPosixApi;
import com.intellij.platform.eel.EelPlatform;
import com.intellij.platform.eel.EelResult;
import com.intellij.platform.eel.EelTunnelsPosixApi;
import com.intellij.platform.eel.EelUserPosixInfo;
import com.intellij.platform.eel.fs.EelFileSystemApi;
import com.intellij.platform.eel.fs.LocalEelFileSystemPosixApi;
import com.intellij.platform.eel.impl.fs.EelUserPosixInfoImpl;
import com.intellij.platform.eel.impl.fs.PosixNioBasedEelFileSystemApi;
import com.intellij.platform.eel.impl.local.EelLocalExecPosixApi;
import com.intellij.platform.eel.impl.local.LocalEelApiImplKt;
import com.intellij.platform.eel.impl.local.LocalEelArchiveApiImpl;
import com.intellij.platform.eel.impl.local.tunnels.EelLocalTunnelsApiImpl;
import com.intellij.platform.eel.path.EelPath;
import com.intellij.platform.eel.provider.LocalEelDescriptor;
import com.intellij.platform.eel.provider.LocalPosixEelApi;
import com.intellij.platform.eel.provider.utils.EelUtilsKt;
import com.intellij.util.system.CpuArch;
import com.sun.security.auth.module.UnixSystem;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u001bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u001fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!\u00a8\u0006\""}, d2={"Lcom/intellij/platform/eel/impl/local/LocalPosixEelApiImpl;", "Lcom/intellij/platform/eel/provider/LocalPosixEelApi;", "nioFs", "Ljava/nio/file/FileSystem;", "<init>", "(Ljava/nio/file/FileSystem;)V", "platform", "Lcom/intellij/platform/eel/EelPlatform$Posix;", "getPlatform", "()Lcom/intellij/platform/eel/EelPlatform$Posix;", "tunnels", "Lcom/intellij/platform/eel/EelTunnelsPosixApi;", "getTunnels", "()Lcom/intellij/platform/eel/EelTunnelsPosixApi;", "descriptor", "Lcom/intellij/platform/eel/EelDescriptor;", "getDescriptor", "()Lcom/intellij/platform/eel/EelDescriptor;", "archive", "Lcom/intellij/platform/eel/EelArchiveApi;", "getArchive", "()Lcom/intellij/platform/eel/EelArchiveApi;", "userInfo", "Lcom/intellij/platform/eel/EelUserPosixInfo;", "getUserInfo", "()Lcom/intellij/platform/eel/EelUserPosixInfo;", "exec", "Lcom/intellij/platform/eel/EelExecPosixApi;", "getExec", "()Lcom/intellij/platform/eel/EelExecPosixApi;", "fs", "Lcom/intellij/platform/eel/fs/LocalEelFileSystemPosixApi;", "getFs", "()Lcom/intellij/platform/eel/fs/LocalEelFileSystemPosixApi;", "intellij.platform.eel.impl"})
@VisibleForTesting
public final class LocalPosixEelApiImpl
implements LocalPosixEelApi {
    @NotNull
    private final FileSystem nioFs;
    @NotNull
    private final EelPlatform.Posix platform;
    @NotNull
    private final EelArchiveApi archive;
    @NotNull
    private final EelUserPosixInfo userInfo;
    @NotNull
    private final EelExecPosixApi exec;
    @NotNull
    private final LocalEelFileSystemPosixApi fs;

    public LocalPosixEelApiImpl(@NotNull FileSystem nioFs) {
        EelPlatform.Posix posix;
        Intrinsics.checkNotNullParameter((Object)nioFs, (String)"nioFs");
        this.nioFs = nioFs;
        if (!SystemInfo.isUnix) {
            throw new IllegalStateException("Check failed.");
        }
        if (SystemInfo.isMac) {
            CpuArch cpuArch = CpuArch.CURRENT;
            Intrinsics.checkNotNullExpressionValue((Object)cpuArch, (String)"CURRENT");
            posix = (EelPlatform.Posix)new EelPlatform.Darwin(EelUtilsKt.toEelArch((CpuArch)cpuArch));
        } else if (SystemInfo.isFreeBSD) {
            CpuArch cpuArch = CpuArch.CURRENT;
            Intrinsics.checkNotNullExpressionValue((Object)cpuArch, (String)"CURRENT");
            posix = (EelPlatform.Posix)new EelPlatform.FreeBSD(EelUtilsKt.toEelArch((CpuArch)cpuArch));
        } else {
            CpuArch cpuArch = CpuArch.CURRENT;
            Intrinsics.checkNotNullExpressionValue((Object)cpuArch, (String)"CURRENT");
            posix = (EelPlatform.Posix)new EelPlatform.Linux(EelUtilsKt.toEelArch((CpuArch)cpuArch));
        }
        this.platform = posix;
        this.archive = LocalEelArchiveApiImpl.INSTANCE;
        LocalPosixEelApiImpl localPosixEelApiImpl = this;
        LocalPosixEelApiImpl localPosixEelApiImpl2 = this;
        boolean bl = false;
        UnixSystem unix = new UnixSystem();
        localPosixEelApiImpl2.userInfo = new EelUserPosixInfoImpl((int)unix.getUid(), (int)unix.getGid(), LocalEelApiImplKt.access$getLocalUserHome());
        this.exec = new EelLocalExecPosixApi(this.getPlatform(), this.getUserInfo());
        FileSystem fileSystem = this.nioFs;
        localPosixEelApiImpl = this.getUserInfo();
        this.fs = new PosixNioBasedEelFileSystemApi(fileSystem, (EelUserPosixInfo)localPosixEelApiImpl){

            public EelDescriptor getDescriptor() {
                return (EelDescriptor)LocalEelDescriptor.INSTANCE;
            }

            public Object createTemporaryDirectory(EelFileSystemApi.CreateTemporaryEntryOptions options, Continuation<? super EelResult<? extends EelPath, ? extends EelFileSystemApi.CreateTemporaryEntryError>> $completion) {
                return LocalEelApiImplKt.access$doCreateTemporaryDirectory(options);
            }

            public Object createTemporaryFile(EelFileSystemApi.CreateTemporaryEntryOptions options, Continuation<? super EelResult<? extends EelPath, ? extends EelFileSystemApi.CreateTemporaryEntryError>> $completion) {
                return LocalEelApiImplKt.access$doCreateTemporaryFile(options);
            }
        };
    }

    public /* synthetic */ LocalPosixEelApiImpl(FileSystem fileSystem, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            FileSystem fileSystem2 = FileSystems.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)fileSystem2, (String)"getDefault(...)");
            fileSystem = fileSystem2;
        }
        this(fileSystem);
    }

    @NotNull
    public EelPlatform.Posix getPlatform() {
        return this.platform;
    }

    @NotNull
    public EelTunnelsPosixApi getTunnels() {
        return EelLocalTunnelsApiImpl.INSTANCE;
    }

    @NotNull
    public EelDescriptor getDescriptor() {
        return (EelDescriptor)LocalEelDescriptor.INSTANCE;
    }

    @NotNull
    public EelArchiveApi getArchive() {
        return this.archive;
    }

    @NotNull
    public EelUserPosixInfo getUserInfo() {
        return this.userInfo;
    }

    @NotNull
    public EelExecPosixApi getExec() {
        return this.exec;
    }

    @NotNull
    public LocalEelFileSystemPosixApi getFs() {
        return this.fs;
    }

    public LocalPosixEelApiImpl() {
        this(null, 1, null);
    }
}

