/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.editor;

import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesImplUtil;
import com.intellij.lang.properties.PropertiesUtil;
import com.intellij.lang.properties.editor.GotoPropertyParentDeclarationHandler;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.Property;
import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.searches.DefinitionsScopedSearch;
import com.intellij.util.Processor;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class PropertiesInheritorsSearcher
extends QueryExecutorBase<PsiElement, DefinitionsScopedSearch.SearchParameters> {
    private static final Logger LOG = Logger.getInstance(PropertiesInheritorsSearcher.class);

    public void processQuery(@NotNull DefinitionsScopedSearch.SearchParameters queryParameters, @NotNull Processor<? super PsiElement> consumer) {
        PsiElement element;
        Property prop;
        if (queryParameters == null) {
            PropertiesInheritorsSearcher.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            PropertiesInheritorsSearcher.$$$reportNull$$$0(1);
        }
        if ((prop = (Property)ReadAction.compute(() -> PropertiesInheritorsSearcher.lambda$processQuery$0(element = queryParameters.getElement()))) == null || !(queryParameters.getScope() instanceof GlobalSearchScope)) {
            return;
        }
        ReadAction.run(() -> {
            String key = prop.getKey();
            if (!prop.isValid() || key == null) {
                return;
            }
            PropertiesFile currentFile = PropertiesImplUtil.getPropertiesFile(prop.getContainingFile());
            LOG.assertTrue(currentFile != null);
            GlobalSearchScope scope = (GlobalSearchScope)queryParameters.getScope();
            for (PropertiesFile f : currentFile.getResourceBundle().getPropertiesFiles()) {
                IProperty byKey;
                if (!f.equals((Object)currentFile) || !scope.contains(f.getVirtualFile()) || PropertiesUtil.getParent((PropertiesFile)f, Collections.singleton(currentFile)) != currentFile || (byKey = f.findPropertyByKey(key)) == null) continue;
                PsiElement psiElement = byKey.getPsiElement();
                ProgressManager.checkCanceled();
                if (consumer.process((Object)psiElement)) continue;
                break;
            }
        });
    }

    private static /* synthetic */ Property lambda$processQuery$0(PsiElement element) throws RuntimeException {
        return GotoPropertyParentDeclarationHandler.findProperty(element);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "queryParameters";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "consumer";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/properties/editor/PropertiesInheritorsSearcher";
        objectArray[2] = "processQuery";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

