/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.keystroke;

import javax.swing.KeyStroke;
import org.assertj.core.util.Preconditions;
import org.assertj.swing.dependency.jsr305.Nonnull;

public class KeyStrokeMapping {
    private final char character;
    private final KeyStroke keyStroke;

    @Nonnull
    public static KeyStrokeMapping mapping(char character, int keyCode, int modifiers) {
        return new KeyStrokeMapping(character, keyCode, modifiers);
    }

    public KeyStrokeMapping(char character, int keyCode, int modifiers) {
        this(character, (KeyStroke)Preconditions.checkNotNull((Object)KeyStroke.getKeyStroke(keyCode, modifiers)));
    }

    public KeyStrokeMapping(char character, @Nonnull KeyStroke keyStroke) {
        this.character = character;
        this.keyStroke = keyStroke;
    }

    public char character() {
        return this.character;
    }

    @Nonnull
    public KeyStroke keyStroke() {
        return this.keyStroke;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof KeyStrokeMapping)) {
            return false;
        }
        KeyStrokeMapping other = (KeyStrokeMapping)o;
        return this.character == other.character && this.keyStroke.getKeyCode() == other.keyStroke.getKeyCode() && this.keyStroke.getModifiers() == other.keyStroke.getModifiers();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = prime * result + this.character;
        if (this.keyStroke != null) {
            result = prime * result + this.keyStroke.getKeyCode();
            result = prime * result + this.keyStroke.getModifiers();
        }
        return result;
    }

    public String toString() {
        String format = "%s[character='%s', keyStroke=%s]";
        return String.format(format, this.getClass().getSimpleName(), String.valueOf(this.character), this.keyStroke.toString());
    }
}

