/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.ru;

import ai.grazie.rules.common.CommonPatterns;
import ai.grazie.rules.common.TreeDisambiguator;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.Tree;
import java.util.List;

class RussianTreeDisambiguator
extends TreeDisambiguator {
    RussianTreeDisambiguator(Tree tree) {
        super(tree);
    }

    @Override
    public Tree disambiguateByTree() {
        String finiteVerb = "VB:(Past|Real|Fut).*";
        for (Node dep : this.currentNodes()) {
            String rel;
            List<Tree.Reading> voda;
            Node head = dep.head();
            if (head == null) continue;
            if ("\u0431\u0440\u0430\u043a\u0443".equals(dep.lowForm())) {
                dep = this.removeIfPossible(dep, ".*2P.*");
            }
            if (head.lowForm().startsWith("\u0432\u043e\u0434") && head.hasLemma("\u0432\u043e\u0434") && !(voda = head.tagIndependently().tokenReadings().stream().filter(l -> "\u0432\u043e\u0434\u0430".equals(l.lemma())).toList()).isEmpty()) {
                head = this.addReadings(head, voda);
                head = this.removeReadings(head, head.tokenReadings().stream().filter(r -> "\u0432\u043e\u0434".equals(r.lemma())).toList());
            }
            if ((rel = dep.headRelation()).matches("nsubj(:pass)?|i?obj|obl(:agent)?|nmod|compound")) {
                this.removeIfPossible(dep, "ADJ:Short:.*|" + finiteVerb);
                if (rel.startsWith("nsubj")) {
                    if (head.hasPos("ADJ:Comp")) {
                        head = this.removeIfPossible(head, "ADJ:Short:.*");
                    }
                    if (head.hasForm("\u0431\u044b\u043b\u0438")) {
                        head = this.removeIfPossible(head, "NN.*");
                    }
                    if (!CommonPatterns.capitalized.matches(head)) {
                        head = this.removeIfPossible(head, "NN:Fam.*");
                    }
                }
                if (!rel.equals("obj")) continue;
                this.removeIfPossible(head, "PT_Short:.*");
                continue;
            }
            if (rel.matches("cop|aux.*")) {
                if (!(head = this.removeIfPossible(head, finiteVerb)).hasPos("ADV")) continue;
                this.removeIfPossible(head, "NN.*");
                continue;
            }
            if (rel.equals("amod")) {
                this.removeIfPossible(head, "VB.*");
                this.removeIfPossible(dep, "NN.*");
                continue;
            }
            if (rel.equals("det")) {
                if (!head.hasDependent("i?obj|obl|nsubj.*")) {
                    this.removeIfPossible(head, "VB.*");
                }
                this.removeIfPossible(dep, "NN.*");
                continue;
            }
            if (!rel.matches("case|advmod")) continue;
            this.removeIfPossible(dep, "NN.*");
        }
        return this.tree;
    }
}

