/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.de;

import ai.grazie.nlp.langs.Language;
import ai.grazie.rules.common.CommonPatterns;
import ai.grazie.rules.de.AdjDeclination;
import ai.grazie.rules.de.AgreementSet;
import ai.grazie.rules.de.Capitalization;
import ai.grazie.rules.de.Case;
import ai.grazie.rules.de.SpellingRules;
import ai.grazie.rules.de.WordSeparation;
import ai.grazie.rules.tree.CrazyParseDetector;
import ai.grazie.rules.tree.NodePattern;

class GermanCrazyParseDetector {
    static final NodePattern softHyphen = NodePattern.custom(n -> {
        String sentence = n.tree().text();
        return n.endOffset() < sentence.length() && sentence.charAt(n.endOffset()) == '\u00ad';
    }).message("soft hyphen");
    static final CrazyParseDetector INSTANCE = new CrazyParseDetector(Language.GERMAN, CommonPatterns.severalDependents("csubj|nsubj").message("Several of csubj|nsubj").andNot(WordSeparation.mass.directlyBefore(WordSeparation.wordsStartingWithMass)).andNot(NodePattern.N.withHeadRelation("ccomp").pos("(ADJ|PA2):PRD:GRU.*")).andNot(NodePattern.N.withHeadRelation("acl")).noDependents("nsubj", NodePattern.or(NodePattern.N.pos("(VER|PRO:IND).*"), NodePattern.N.form("dass?").directlyBefore(NodePattern.N.form("alles")))).andNot(NodePattern.N.withDependent("csubj", NodePattern.N.withDependent("nsubj"))).andNot(NodePattern.ROOT.withDependent("punct", CommonPatterns.colon)).andNot(NodePattern.N.withDependent("nsubj", SpellingRules.noun.withDependent("det(:poss)?").directlyBefore(SpellingRules.noun.withHeadRelation("nsubj")))).andNot(NodePattern.N.withDependent("nsubj", NodePattern.N.beforeHead().markAs("Subj")).withDependent("nsubj", NodePattern.not(NodePattern.N.alreadyMarkedAs("nsubj")).afterHead().directlyAfter(NodePattern.N.withHeadRelation("mark")).andNot(CommonPatterns.lastWord))).andNot(NodePattern.N.withDependent("nsubj", NodePattern.N.pos("SUB.*").directlyBefore(NodePattern.N.withHeadRelation("nsubj").pos("PRO:PER.*")))).noDependents("nsubj", NodePattern.N.lemma("alle")).noDependents("[cn]subj", NodePattern.or(NodePattern.N.form("kein|im|es"), Capitalization.etwasNichtsVielWenig, WordSeparation.infinitiveWithZuPhraseHead.withDependent("det", NodePattern.N.directlyBeforeHead()))).noDependents("csubj", NodePattern.N.noDependents()).withOptionalDependent("ccomp|obj", NodePattern.N), NodePattern.N.markAs("Det").beforeHead().withHead("det", NodePattern.N.withDependent("cc", NodePattern.N.after("Det").beforeHead()).noForm("Entweder|Sowohl")).message("cc after det"), NodePattern.N.pos("VER.*").noPos("SUB.*").noDependents("amod|det:poss").withHead("conj", NodePattern.N.withDependent("conj", NodePattern.N.pos("SUB.*").markAs("Conj").noDependents("advmod", NodePattern.N.inFormSequence(1, "viel", "mehr"))).andNot(NodePattern.N.pos("ART:IND.*"))).andNot(NodePattern.N.before(NodePattern.N.alreadyMarkedAs("Conj")).noPos("ADV.*")).andNot(NodePattern.N.withDependent("cc", NodePattern.N.beforeHead()).withDependent("nsubj")).andNot(WordSeparation.compoundNounWithInFrage).message("noun conj verb"), NodePattern.N.pos("VER.*").withDependent("mark", NodePattern.N.form("wohl")).message("wohl has head relation mark"), NodePattern.N.withHeadRelation("cop").withNextSibling(NodePattern.N.withHeadRelation("conj")).directlyAfter(NodePattern.N.withHeadRelation("conj")).message("cop between two conjuncts"), NodePattern.N.withHead("aux", NodePattern.N).pos("ADJ.*|SUB.*").noPos("VER.*").message("Nominal aux"), NodePattern.N.withHeadRelation("det").withDependent("case").message("case on det"), NodePattern.N.withHead("advmod", NodePattern.ROOT).withDependent("advmod", NodePattern.N.form("je")).message("misparsed je-dependent clause"), NodePattern.N.form("Python").message("possibly das Python"), NodePattern.N.form("Agile").message("English"), NodePattern.N.form("befunden").message("LT misses infinitive POS"), NodePattern.N.form("Tasks?").andNot(NodePattern.N.directlyBefore(NodePattern.N.form("Forces?"))).message("Task"), NodePattern.N.onlyPos("SUB.*SIN.*ADJ").form(".+ende").noForm("folgend.*").message("missing PA POS"), NodePattern.N.form("Debugger").message("Debugger"), NodePattern.N.form("Cursor").noPos(":PLU:").withDependent("det|amod", NodePattern.N.noPos(".*:SIN:.*")).message("Cursor: only sg morphology with plural modifier"), NodePattern.N.form(".+beamte").message("Beamte"), NodePattern.N.form(".*schlie\u00dft").noPos(".*2.*").message("...schlie\u00dft: no 2 Person morphology"), NodePattern.N.form("Workspaces").noPos(".*GEN:SIN.*").message("Workspaces without genitive singular morphology"), NodePattern.N.form("Eingangsports").noPos(".*:PLU:.*").message("Eingangsports without plural morphology"), NodePattern.N.form(".*forsten|Triefaugen").noPos("SUB:(NOM|GEN|AKK):PLU:MAS").message("Forsten/Triefaugen: only dative plural morphology"), NodePattern.N.form("Spa\u00df").withDependent("det", NodePattern.N.pos(".*DAT.*")).message("dative argument misparsed as a determiner inside NP"), NodePattern.N.form("Deichseln").noPos(".*PLU.*").message("Deichseln without plural morphology"), NodePattern.N.form(".+klamm").noPos(".*FEM.*").message("...klamm: no feminine morphology"), NodePattern.N.form(".+gemurmel").noPos(".*NEU.*").message("...gemurmel: no neutral morphology"), NodePattern.N.form("Striemen").noPos(".*MAS.*").message("Striemen: no masculine morphology"), NodePattern.N.form("Profilen").noPos(".*SIN.*").message("Profilen: no singular morphology"), NodePattern.N.form("allen").noPos(".*:ACC:SIN.*").andOr(NodePattern.N.label("PERSON"), NodePattern.N.withHead(NodePattern.N.onlyPos(".*SIN.*"))).andNot(NodePattern.N.directlyBefore(NodePattern.N.form("falls"))).message("allen without AccSg morphology"), NodePattern.N.form("TeamCity").noPos(".*NEU.*").message("TeamCity: no neutral morphology"), NodePattern.N.form("Tier").inFormSequence(2, "Middle|Upper|Lower", "-", ".*").noPos(".*MAS.*").message("Tier: no masculine morphology"), NodePattern.N.form("Bridge").noPos("SUB:.*FEM").message("Non-fem Bridge"), CommonPatterns.capitalized.andOr(NodePattern.N.form("Olympia").withDependent("nmod").noPos("SUB:.*:SIN:FEM").message("Olympia XXXX without feminine morphology"), NodePattern.N.form("Linker").noPos("SUB:(NOM|GEN|AKK):SIN:MAS").message("Linker: no noun morphology"), NodePattern.N.form("Forken|Orange").noPos("SUB:.*:SIN:NEU").message("Forken|Orange: no neutral singular morphology"), NodePattern.N.form("Ellen|Chvatal|Aiden").noPos("EIG:.*SIN.*").message("no proper name singular morphology"), NodePattern.N.form("Scheu").noPos("SUB:.*:SIN:FEM").message("Scheu: no nominal morphology"), NodePattern.N.form(".+(spielen|teilen?)").noPos(".*PLU.*").message("compound with Spielen/Teile: no plural morphology"), NodePattern.N.form(".*wales").noPos("EIG:.*").message("Wales: no proper name morphology")), NodePattern.N.form("links").withHead("obj", NodePattern.N).noPos("SUB.*").message("links: no noun morphology"), NodePattern.N.form("den").withHead("det", NodePattern.N.form(".+s").pos("SUB:.*").noPos("SUB:DAT:PLU.*").withDependent("case", Case.datPreposition)).message("missing DAT:PLU tag"), NodePattern.N.form("aller").withHead("det", NodePattern.N.withHeadRelation("nmod").noDependents("case").pos(".*:GEN.*").noForm("Hand").andNot(AgreementSet.alleXtimeUnit)).noPos(".*:GEN:SIN:.*").andNot(NodePattern.N.directlyBefore(NodePattern.N.form("dings"))).message("no-gen-sin determiner in nmod without case"), NodePattern.N.lemma("der|ich").noPos(".*:NOM.*").and(CommonPatterns.skipUp("det", NodePattern.N.withHead("nsubj.*", NodePattern.N.withHeadRelation("conj")))).message("no-nom article in nsubj"), NodePattern.N.form("sich|hat").withHeadRelation("nsubj(:pass)?").message("sich|hat nsubj"), NodePattern.N.form(".+fache").onlyPos("SUB:DAT:SIN:.*").andOr(NodePattern.N.withDependent(".*", AdjDeclination.accFusedPreposition), NodePattern.N.withDependent("det", NodePattern.N.form("das"))).message("only dative sg morphology for a substantive adj in acc"), NodePattern.N.inFormSequence(1, "die", "vielen").message("die vielen (missing accusative)"));

    GermanCrazyParseDetector() {
    }
}

