/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.console;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.console.PyConsoleProcessFinishedException;
import com.jetbrains.python.console.PydevConsoleCommunication;
import com.jetbrains.python.console.PythonConsoleBackendServiceDisposable;
import com.jetbrains.python.console.PythonConsoleClientUtil;
import com.jetbrains.python.console.protocol.PythonConsoleBackendService;
import com.jetbrains.python.console.protocol.PythonConsoleFrontendService;
import com.jetbrains.python.console.transport.client.TNettyClientTransport;
import com.jetbrains.python.console.transport.server.TNettyServer;
import com.jetbrains.python.debugger.PyDebugValueExecutionService;
import com.jetbrains.python.debugger.PyFrameAccessor;
import com.jetbrains.python.debugger.PyFrameListener;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.thrift.TProcessor;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.transport.TServerTransport;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000  2\u00020\u0001:\u0001 B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0006\u0010\u001a\u001a\u00020\u001bJ\b\u0010\u001c\u001a\u00020\u000fH\u0014J\f\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u001eH\u0014J\b\u0010\u001f\u001a\u00020\u0019H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/jetbrains/python/console/PydevConsoleCommunicationClient;", "Lcom/jetbrains/python/console/PydevConsoleCommunication;", "project", "Lcom/intellij/openapi/project/Project;", "host", "", "port", "", "_pythonConsoleProcess", "Ljava/lang/Process;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;ILjava/lang/Process;)V", "server", "Lcom/jetbrains/python/console/transport/server/TNettyServer;", "client", "Lcom/jetbrains/python/console/PythonConsoleBackendServiceDisposable;", "clientTransport", "Lcom/jetbrains/python/console/transport/client/TNettyClientTransport;", "stateLock", "Ljava/util/concurrent/locks/Lock;", "stateChanged", "Ljava/util/concurrent/locks/Condition;", "initialPythonConsoleClient", "Lcom/jetbrains/python/console/protocol/PythonConsoleBackendService$Iface;", "isClosed", "", "connect", "", "getPythonConsoleBackendClient", "closeCommunication", "Ljava/util/concurrent/Future;", "isCommunicationClosed", "Companion", "intellij.python.community.impl"})
@SourceDebugExtension(value={"SMAP\nPydevConsoleCommunicationClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PydevConsoleCommunicationClient.kt\ncom/jetbrains/python/console/PydevConsoleCommunicationClient\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,201:1\n1#2:202\n*E\n"})
public final class PydevConsoleCommunicationClient
extends PydevConsoleCommunication {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String host;
    private final int port;
    @NotNull
    private final Process _pythonConsoleProcess;
    @Nullable
    private TNettyServer server;
    @Nullable
    private PythonConsoleBackendServiceDisposable client;
    @NotNull
    private final TNettyClientTransport clientTransport;
    @NotNull
    private final Lock stateLock;
    @NotNull
    private final Condition stateChanged;
    @Nullable
    private PythonConsoleBackendService.Iface initialPythonConsoleClient;
    private boolean isClosed;
    @NotNull
    private static final Logger LOG;

    public PydevConsoleCommunicationClient(@NotNull Project project, @NotNull String host, int port, @NotNull Process _pythonConsoleProcess) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)_pythonConsoleProcess, (String)"_pythonConsoleProcess");
        super(project);
        this.host = host;
        this.port = port;
        this._pythonConsoleProcess = _pythonConsoleProcess;
        this.clientTransport = new TNettyClientTransport(this.host, this.port);
        this.stateLock = new ReentrantLock();
        Condition condition = this.stateLock.newCondition();
        Intrinsics.checkNotNullExpressionValue((Object)condition, (String)"newCondition(...)");
        this.stateChanged = condition;
    }

    public final void connect() {
        ApplicationManager.getApplication().executeOnPooledThread(() -> PydevConsoleCommunicationClient.connect$lambda$0(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected PythonConsoleBackendServiceDisposable getPythonConsoleBackendClient() {
        Lock lock2 = this.stateLock;
        lock2.lock();
        try {
            boolean bl = false;
            while (!this.isClosed && this._pythonConsoleProcess.isAlive()) {
                PythonConsoleBackendServiceDisposable pythonConsoleBackendServiceDisposable = this.client;
                if (pythonConsoleBackendServiceDisposable != null) {
                    void var3_4;
                    PythonConsoleBackendServiceDisposable it = pythonConsoleBackendServiceDisposable;
                    boolean bl2 = false;
                    void var8_7 = var3_4;
                    return var8_7;
                }
                PythonConsoleBackendService.Iface initialPythonConsoleClient = this.initialPythonConsoleClient;
                if (initialPythonConsoleClient != null) {
                    PythonConsoleBackendServiceDisposable newClient;
                    ClassLoader classLoader = PydevConsoleCommunication.class.getClassLoader();
                    Intrinsics.checkNotNullExpressionValue((Object)classLoader, (String)"getClassLoader(...)");
                    this.client = newClient = PythonConsoleClientUtil.synchronizedPythonConsoleClient(classLoader, initialPythonConsoleClient, this._pythonConsoleProcess);
                    PythonConsoleBackendServiceDisposable pythonConsoleBackendServiceDisposable2 = newClient;
                    return pythonConsoleBackendServiceDisposable2;
                }
                this.stateChanged.await();
            }
            if (!this._pythonConsoleProcess.isAlive()) {
                throw new PyConsoleProcessFinishedException(this._pythonConsoleProcess.exitValue());
            }
            throw new PydevConsoleCommunication.CommunicationClosedException();
        }
        finally {
            lock2.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    protected Future<?> closeCommunication() {
        Lock lock2 = this.stateLock;
        lock2.lock();
        try {
            boolean bl = false;
            try {
                this.isClosed = true;
            }
            finally {
                this.stateChanged.signalAll();
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock2.unlock();
        }
        ProgressIndicator progressIndicator = ProgressIndicatorProvider.getInstance().getProgressIndicator();
        try {
            PythonConsoleBackendServiceDisposable pythonConsoleBackendServiceDisposable = this.client;
            if (pythonConsoleBackendServiceDisposable != null) {
                PythonConsoleBackendServiceDisposable pythonConsoleBackendServiceDisposable2;
                PythonConsoleBackendServiceDisposable $this$closeCommunication_u24lambda_u241 = pythonConsoleBackendServiceDisposable2 = pythonConsoleBackendServiceDisposable;
                boolean bl = false;
                ProgressIndicator progressIndicator2 = progressIndicator;
                if (progressIndicator2 != null) {
                    progressIndicator2.setText2(PyBundle.message("debugger.sending.close.message", new Object[0]));
                }
                $this$closeCommunication_u24lambda_u241.close();
                $this$closeCommunication_u24lambda_u241.dispose();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Process it = this._pythonConsoleProcess;
        boolean bl = false;
        ProgressIndicator progressIndicator3 = progressIndicator;
        if (progressIndicator3 != null) {
            progressIndicator3.setText2(PyBundle.message("debugger.waiting.to.finish", new Object[0]));
        }
        try {
            do {
                ProgressIndicator progressIndicator4 = progressIndicator;
                if (progressIndicator4 == null) continue;
                progressIndicator4.checkCanceled();
            } while (!it.waitFor(500L, TimeUnit.MILLISECONDS));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        this.clientTransport.close();
        Object object = this.server;
        if (object == null || (object = ((TNettyServer)object).stop()) == null) {
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
            object = completableFuture;
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCommunicationClosed() {
        boolean bl;
        Lock lock2 = this.stateLock;
        lock2.lock();
        try {
            boolean bl2 = false;
            bl = this.isClosed;
        }
        finally {
            lock2.unlock();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void connect$lambda$0(PydevConsoleCommunicationClient this$0) {
        try {
            this$0.clientTransport.open();
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
            Lock lock2 = this$0.stateLock;
            lock2.lock();
            try {
                boolean $i$a$-withLock-PydevConsoleCommunicationClient$connect$1$32 = false;
                this$0.isClosed = true;
                this$0.stateChanged.signalAll();
                Unit $i$a$-withLock-PydevConsoleCommunicationClient$connect$1$32 = Unit.INSTANCE;
            }
            finally {
                lock2.unlock();
            }
            return;
        }
        TBinaryProtocol clientProtocol = new TBinaryProtocol(this$0.clientTransport);
        PythonConsoleBackendService.Client client = new PythonConsoleBackendService.Client(clientProtocol);
        TServerTransport serverTransport2 = this$0.clientTransport.getServerTransport();
        PythonConsoleFrontendService.Iface iface = this$0.createPythonConsoleFrontendHandler();
        Intrinsics.checkNotNullExpressionValue((Object)iface, (String)"createPythonConsoleFrontendHandler(...)");
        PythonConsoleFrontendService.Iface serverHandler = iface;
        PythonConsoleFrontendService.Processor<PythonConsoleFrontendService.Iface> serverProcessor = new PythonConsoleFrontendService.Processor<PythonConsoleFrontendService.Iface>(serverHandler);
        TNettyServer server = new TNettyServer(serverTransport2, (TProcessor)serverProcessor);
        Lock lock3 = this$0.stateLock;
        lock3.lock();
        try {
            boolean bl = false;
            if (this$0.isClosed) {
                throw new ProcessCanceledException();
            }
            this$0.server = server;
            this$0.initialPythonConsoleClient = client;
            this$0.stateChanged.signalAll();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock3.unlock();
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> PydevConsoleCommunicationClient.connect$lambda$0$2(server));
        PyDebugValueExecutionService executionService = PyDebugValueExecutionService.getInstance((Project)this$0.myProject);
        executionService.sessionStarted((PyFrameAccessor)this$0);
        this$0.addFrameListener(new PyFrameListener(executionService, this$0){
            final /* synthetic */ PyDebugValueExecutionService $executionService;
            final /* synthetic */ PydevConsoleCommunicationClient this$0;
            {
                this.$executionService = $executionService;
                this.this$0 = $receiver;
            }

            public void frameChanged() {
                this.$executionService.cancelSubmittedTasks((PyFrameAccessor)this.this$0);
            }

            public void sessionStopped(PyFrameAccessor communication) {
                this.$executionService.cancelSubmittedTasks((PyFrameAccessor)this.this$0);
            }
        });
    }

    private static final void connect$lambda$0$2(TNettyServer $server) {
        $server.serve();
    }

    static {
        Logger logger = Logger.getInstance(Logger.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/python/console/PydevConsoleCommunicationClient$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.python.community.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

