/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.configuration;

import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ComboboxSpeedSearch;
import com.intellij.ui.components.DropDownLink;
import com.intellij.util.ui.JBUI;
import com.intellij.webcore.packaging.PackagesNotificationPanel;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.configuration.PyConfigurableInterpreterList;
import com.jetbrains.python.configuration.PyPanelWithPromo;
import com.jetbrains.python.configuration.PythonInterpreterConfigurable;
import com.jetbrains.python.packaging.PyPackageManagers;
import com.jetbrains.python.packaging.PyPackagesNotificationPanel;
import com.jetbrains.python.packaging.ui.PyInstalledPackagesPanel;
import com.jetbrains.python.sdk.AddInterpreterActions;
import com.jetbrains.python.sdk.DialogAction;
import com.jetbrains.python.sdk.ModuleOrProject;
import com.jetbrains.python.sdk.PyCustomSdkUiProvider;
import com.jetbrains.python.sdk.PyRenderedSdkType;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.PySdkListCellRenderer;
import com.jetbrains.python.sdk.PySdkRenderingKt;
import com.jetbrains.python.sdk.PyTransferredSdkRootsKt;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.sdk.legacy.PythonSdkUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class PyActiveSdkConfigurable
implements UnnamedConfigurable {
    @NotNull
    protected final Project myProject;
    @Nullable
    protected final Module myModule;
    @NotNull
    private final PyConfigurableInterpreterList myInterpreterList;
    @NotNull
    protected final ProjectSdksModel myProjectSdksModel;
    @NotNull
    private final JPanel myMainPanel;
    @NotNull
    private final ComboBox<Object> mySdkCombo;
    @NotNull
    private final PyInstalledPackagesPanel myPackagesPanel;
    @Nullable
    private final PyPanelWithPromo myPanelWithPromo;
    @Nullable
    private final Disposable myDisposable;

    public PyActiveSdkConfigurable(@NotNull Project project) {
        if (project == null) {
            PyActiveSdkConfigurable.$$$reportNull$$$0(0);
        }
        this(project, null);
    }

    public PyActiveSdkConfigurable(@NotNull Module module2) {
        if (module2 == null) {
            PyActiveSdkConfigurable.$$$reportNull$$$0(1);
        }
        this(module2.getProject(), module2);
    }

    private PyActiveSdkConfigurable(@NotNull Project project, @Nullable Module module2) {
        if (project == null) {
            PyActiveSdkConfigurable.$$$reportNull$$$0(2);
        }
        this.myProject = project;
        this.myModule = module2;
        this.mySdkCombo = PyActiveSdkConfigurable.buildSdkComboBox(this::onShowAllSelected, this::onSdkSelected);
        PyPackagesNotificationPanel packagesNotificationPanel = new PyPackagesNotificationPanel();
        this.myPackagesPanel = new PyInstalledPackagesPanel(this.myProject, packagesNotificationPanel);
        this.myPackagesPanel.setShowGrid(false);
        boolean freeTier = PythonSdkUtil.isFreeTier();
        this.myPanelWithPromo = freeTier ? new PyPanelWithPromo((JPanel)((Object)this.myPackagesPanel)) : null;
        PyCustomSdkUiProvider customUiProvider = PyCustomSdkUiProvider.getInstance();
        this.myDisposable = customUiProvider == null ? null : Disposer.newDisposable();
        Pair customizer = customUiProvider == null ? null : new Pair((Object)customUiProvider, (Object)this.myDisposable);
        DropDownLink additionalAction = new DropDownLink((Object)PyBundle.message("active.sdk.dialog.link.add.interpreter.text", new Object[0]), link -> PyActiveSdkConfigurable.createAddInterpreterPopup(project, module2, (Component)link, this::updateSdkListAndSelect));
        this.myMainPanel = PyActiveSdkConfigurable.buildPanel(project, this.mySdkCombo, (JComponent)additionalAction, (JPanel)(freeTier ? this.myPanelWithPromo.getPanel() : this.myPackagesPanel), packagesNotificationPanel, (Pair<PyCustomSdkUiProvider, Disposable>)customizer);
        this.myInterpreterList = PyConfigurableInterpreterList.getInstance(this.myProject);
        this.myProjectSdksModel = this.myInterpreterList.getModel();
    }

    @ApiStatus.Internal
    @NotNull
    public static ListPopup createAddInterpreterPopup(@NotNull Project project, @Nullable Module module2, @NotNull Component dataContextComponent, @NotNull Consumer<Sdk> onSdkCreated) {
        if (project == null) {
            PyActiveSdkConfigurable.$$$reportNull$$$0(3);
        }
        if (dataContextComponent == null) {
            PyActiveSdkConfigurable.$$$reportNull$$$0(4);
        }
        if (onSdkCreated == null) {
            PyActiveSdkConfigurable.$$$reportNull$$$0(5);
        }
        DataContext dataContext = DataManager.getInstance().getDataContext(dataContextComponent);
        ModuleOrProject moduleOrProject = module2 != null ? new ModuleOrProject.ModuleAndProject(module2) : new ModuleOrProject.ProjectOnly(project);
        List<DialogAction> actions = AddInterpreterActions.collectAddInterpreterActions(moduleOrProject, onSdkCreated);
        ListPopup listPopup = JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)new DefaultActionGroup(actions), dataContext, JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, false, null, -1, action -> false, null);
        if (listPopup == null) {
            PyActiveSdkConfigurable.$$$reportNull$$$0(6);
        }
        return listPopup;
    }

    @NotNull
    private static ComboBox<Object> buildSdkComboBox(final @NotNull Runnable onShowAllSelected, @NotNull Runnable onSdkSelected) {
        if (onShowAllSelected == null) {
            PyActiveSdkConfigurable.$$$reportNull$$$0(7);
        }
        if (onSdkSelected == null) {
            PyActiveSdkConfigurable.$$$reportNull$$$0(8);
        }
        ComboBox<Object> result2 = new ComboBox<Object>(){

            public void setSelectedItem(Object item) {
                if (PyActiveSdkConfigurable.getShowAll().equals(item)) {
                    ApplicationManager.getApplication().invokeLater(onShowAllSelected);
                } else if (!"separator".equals(item)) {
                    super.setSelectedItem(item);
                }
            }
        };
        result2.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                onSdkSelected.run();
            }
        });
        ComboboxSpeedSearch.installOn((JComboBox)result2);
        result2.setPreferredSize(result2.getPreferredSize());
        ComboBox<Object> comboBox = result2;
        if (comboBox == null) {
            PyActiveSdkConfigurable.$$$reportNull$$$0(9);
        }
        return comboBox;
    }

    @NotNull
    private static JPanel buildPanel(@NotNull Project project, @NotNull ComboBox<?> sdkComboBox, @NotNull JComponent additionalAction, @NotNull JPanel promotionPanel, @NotNull PackagesNotificationPanel packagesNotificationPanel, @Nullable Pair<PyCustomSdkUiProvider, Disposable> customizer) {
        if (project == null) {
            PyActiveSdkConfigurable.$$$reportNull$$$0(10);
        }
        if (sdkComboBox == null) {
            PyActiveSdkConfigurable.$$$reportNull$$$0(11);
        }
        if (additionalAction == null) {
            PyActiveSdkConfigurable.$$$reportNull$$$0(12);
        }
        if (promotionPanel == null) {
            PyActiveSdkConfigurable.$$$reportNull$$$0(13);
        }
        if (packagesNotificationPanel == null) {
            PyActiveSdkConfigurable.$$$reportNull$$$0(14);
        }
        JPanel result2 = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.insets = JBUI.insets((int)2);
        c.gridx = 0;
        c.gridy = 0;
        JLabel label = new JLabel(PyBundle.message("active.sdk.dialog.project.interpreter", new Object[0]));
        label.setLabelFor((Component)sdkComboBox);
        result2.add((Component)label, c);
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 0.1;
        result2.add((Component)sdkComboBox, c);
        c.insets = JBUI.insets((int)2, (int)0, (int)2, (int)2);
        c.gridx = 2;
        c.gridy = 0;
        c.weightx = 0.0;
        result2.add((Component)additionalAction, c);
        if (customizer != null) {
            ((PyCustomSdkUiProvider)customizer.first).customizeActiveSdkPanel(project, sdkComboBox, result2, c, (Disposable)customizer.second);
        }
        c.gridx = 0;
        ++c.gridy;
        c.weighty = 1.0;
        c.gridwidth = 3;
        c.gridheight = -1;
        c.fill = 1;
        result2.add((Component)promotionPanel, c);
        c.gridheight = 0;
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 3;
        c.weighty = 0.0;
        c.fill = 2;
        c.anchor = 15;
        result2.add((Component)packagesNotificationPanel.getComponent(), c);
        JPanel jPanel = result2;
        if (jPanel == null) {
            PyActiveSdkConfigurable.$$$reportNull$$$0(15);
        }
        return jPanel;
    }

    private void onShowAllSelected() {
        Sdk selectedSdk = PythonInterpreterConfigurable.openInDialog(this.myProject, this.myModule, this.getEditableSelectedSdk());
        this.onShowAllInterpretersDialogClosed(selectedSdk);
    }

    protected void onSdkSelected() {
        Sdk sdk2 = this.getOriginalSelectedSdk();
        if (sdk2 != null && this.myPanelWithPromo != null) {
            boolean remote = PythonSdkUtil.isRemote((Sdk)sdk2);
            this.myPanelWithPromo.setPromoMode(remote);
            if (remote) {
                return;
            }
        }
        this.refreshPackages(sdk2);
    }

    protected void refreshPackages(@Nullable Sdk sdk2) {
        PyPackageManagers packageManagers = PyPackageManagers.getInstance();
        this.myPackagesPanel.updatePackages(sdk2 != null ? packageManagers.getManagementService(this.myProject, sdk2) : null);
        this.myPackagesPanel.updateNotifications(sdk2);
    }

    private void onShowAllInterpretersDialogClosed(@Nullable Sdk selectedSdk) {
        if (selectedSdk != null) {
            this.updateSdkListAndSelect(selectedSdk);
        } else {
            Sdk currentSelectedSdk = this.getEditableSelectedSdk();
            if (currentSelectedSdk != null && this.myProjectSdksModel.findSdk(currentSelectedSdk.getName()) != null) {
                this.updateSdkListAndSelect(currentSelectedSdk);
            } else {
                this.updateSdkListAndSelect(null);
            }
        }
    }

    public JComponent createComponent() {
        return this.myMainPanel;
    }

    public boolean isModified() {
        return !Comparing.equal((Object)this.getSdk(), (Object)this.getOriginalSelectedSdk());
    }

    @Nullable
    protected Sdk getOriginalSelectedSdk() {
        Sdk editableSdk = this.getEditableSelectedSdk();
        return editableSdk == null ? null : this.myProjectSdksModel.findSdk(editableSdk);
    }

    @Nullable
    protected Sdk getEditableSelectedSdk() {
        return (Sdk)this.mySdkCombo.getSelectedItem();
    }

    @Nullable
    protected Sdk getSdk() {
        Sdk sdk2 = null;
        sdk2 = this.myModule == null ? ProjectRootManager.getInstance((Project)this.myProject).getProjectSdk() : ModuleRootManager.getInstance((Module)this.myModule).getSdk();
        if (sdk2 != null && PythonSdkUtil.isPythonSdk((Sdk)sdk2)) {
            return sdk2;
        }
        return null;
    }

    public void apply() {
        Sdk selectedSdk = this.getOriginalSelectedSdk();
        if (selectedSdk != null) {
            ((PythonSdkType)selectedSdk.getSdkType()).setupSdkPaths(selectedSdk);
        }
        this.setSdk(selectedSdk);
    }

    protected void setSdk(@Nullable Sdk item) {
        Sdk currentSdk = this.getSdk();
        PyTransferredSdkRootsKt.removeTransferredRootsFromModulesWithInheritedSdk(this.myProject, currentSdk);
        PySdkExtKt.setPythonSdk(this.myProject, item);
        PyTransferredSdkRootsKt.transferRootsToModulesWithInheritedSdk(this.myProject, item);
        if (this.myModule != null) {
            PyTransferredSdkRootsKt.removeTransferredRoots(this.myModule, currentSdk);
            PySdkExtKt.setPythonSdk(this.myModule, item);
            PyTransferredSdkRootsKt.transferRoots(this.myModule, item);
        }
    }

    public void reset() {
        Sdk sdk2 = this.getSdk();
        this.updateSdkListAndSelect(sdk2);
    }

    @NotNull
    protected List<Sdk> getAvailableSdks() {
        List<Sdk> list = this.myInterpreterList.getAllPythonSdks(this.myProject, this.myModule, true);
        if (list == null) {
            PyActiveSdkConfigurable.$$$reportNull$$$0(16);
        }
        return list;
    }

    private void updateSdkListAndSelect(@Nullable Sdk selectedSdk) {
        List<Sdk> allPythonSdks = this.getAvailableSdks();
        ArrayList<String> items = new ArrayList<String>();
        items.add(null);
        Map<PyRenderedSdkType, List<Sdk>> moduleSdksByTypes = PySdkRenderingKt.groupModuleSdksByTypes(allPythonSdks, this.myModule, (Function1<? super Sdk, Boolean>)((Function1)sdk2 -> !PySdkExtKt.getSdkSeemsValid(sdk2)));
        PyRenderedSdkType[] renderedSdkTypes = PyRenderedSdkType.values();
        for (int i = 0; i < renderedSdkTypes.length; ++i) {
            PyRenderedSdkType currentSdkType = renderedSdkTypes[i];
            if (!moduleSdksByTypes.containsKey((Object)currentSdkType)) continue;
            if (i != 0) {
                items.add("separator");
            }
            items.addAll((Collection)moduleSdksByTypes.get((Object)currentSdkType));
        }
        items.add("separator");
        items.add(PyActiveSdkConfigurable.getShowAll());
        this.mySdkCombo.setRenderer((ListCellRenderer)((Object)new PySdkListCellRenderer()));
        Sdk selection = this.getEditableSdkUsingOriginal(selectedSdk);
        this.mySdkCombo.setModel((ComboBoxModel)new CollectionComboBoxModel(items, (Object)selection));
        this.mySdkCombo.setSelectedItem((Object)selection);
        this.onSdkSelected();
    }

    @Nullable
    protected Sdk getEditableSdkUsingOriginal(@Nullable Sdk sdk2) {
        return sdk2 == null ? null : this.myProjectSdksModel.findSdk(sdk2.getName());
    }

    public void disposeUIResources() {
        this.myInterpreterList.disposeModel();
        if (this.myDisposable != null) {
            Disposer.dispose((Disposable)this.myDisposable);
        }
    }

    private static String getShowAll() {
        return PyBundle.message("active.sdk.dialog.show.all.item", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 9, 15, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContextComponent";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onSdkCreated";
                break;
            }
            case 6: 
            case 9: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/configuration/PyActiveSdkConfigurable";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onShowAllSelected";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onSdkSelected";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkComboBox";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalAction";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "promotionPanel";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packagesNotificationPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/configuration/PyActiveSdkConfigurable";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createAddInterpreterPopup";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "buildSdkComboBox";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "buildPanel";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableSdks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createAddInterpreterPopup";
                break;
            }
            case 6: 
            case 9: 
            case 15: 
            case 16: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "buildSdkComboBox";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "buildPanel";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 9, 15, 16 -> new IllegalStateException(string);
        };
    }
}

