/*
 * Decompiled with CFR 0.152.
 */
package tech.units.indriya.internal.format;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.measure.format.UnitFormat;
import javax.measure.spi.UnitFormatService;
import tec.uom.lib.common.function.IntPrioritySupplier;
import tech.units.indriya.format.EBNFUnitFormat;
import tech.units.indriya.format.LocalUnitFormat;
import tech.units.indriya.format.SimpleUnitFormat;

public class DefaultUnitFormatService
implements UnitFormatService,
IntPrioritySupplier {
    static final int PRIO = 1000;
    private static final String DEFAULT_FORMAT = SimpleUnitFormat.Flavor.Default.name();
    protected final Map<String, UnitFormat> unitFormats = new HashMap<String, UnitFormat>();

    public DefaultUnitFormatService() {
        this.unitFormats.put(DEFAULT_FORMAT, SimpleUnitFormat.getInstance());
        this.unitFormats.put(SimpleUnitFormat.Flavor.ASCII.name(), SimpleUnitFormat.getInstance(SimpleUnitFormat.Flavor.ASCII));
        this.unitFormats.put("EBNF", EBNFUnitFormat.getInstance());
        this.unitFormats.put("Local", LocalUnitFormat.getInstance());
    }

    public UnitFormat getUnitFormat(String formatName) {
        Objects.requireNonNull(formatName, "Format name required");
        return this.unitFormats.get(formatName);
    }

    public UnitFormat getUnitFormat() {
        return this.getUnitFormat(DEFAULT_FORMAT);
    }

    public Set<String> getAvailableFormatNames() {
        return this.unitFormats.keySet();
    }

    public int getPriority() {
        return 1000;
    }
}

