/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.configmanagement;

import com.intellij.application.options.CodeStyle;
import com.intellij.editorconfig.common.EditorConfigBundle;
import com.intellij.ide.actions.searcheverywhere.FileSearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import org.editorconfig.configmanagement.EditorConfigNavigationActionsFactory;
import org.editorconfig.settings.EditorConfigSettings;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class EditorConfigActionUtil {
    public static AnAction @NotNull [] createNavigationActions(@NotNull PsiFile file) {
        if (file == null) {
            EditorConfigActionUtil.$$$reportNull$$$0(0);
        }
        AnAction[] anActionArray = EditorConfigNavigationActionsFactory.INSTANCE.getNavigationActions(file.getProject(), file.getVirtualFile()).toArray(AnAction.EMPTY_ARRAY);
        if (anActionArray == null) {
            EditorConfigActionUtil.$$$reportNull$$$0(1);
        }
        return anActionArray;
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static AnAction createDisableAction(@NotNull Project project, @NotNull @Nls String message) {
        if (project == null) {
            EditorConfigActionUtil.$$$reportNull$$$0(2);
        }
        if (message == null) {
            EditorConfigActionUtil.$$$reportNull$$$0(3);
        }
        DumbAwareAction dumbAwareAction = DumbAwareAction.create((String)message, e -> EditorConfigActionUtil.setEditorConfigEnabled(project, false));
        if (dumbAwareAction == null) {
            EditorConfigActionUtil.$$$reportNull$$$0(4);
        }
        return dumbAwareAction;
    }

    @Contract(value=" -> new")
    @NotNull
    public static AnAction createShowEditorConfigFilesAction() {
        return new DumbAwareAction(EditorConfigBundle.message((String)"editor.config.files.show")){

            public void actionPerformed(@NotNull AnActionEvent e) {
                Project project;
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((project = e.getProject()) != null) {
                    EditorConfigActionUtil.showEditorConfigFiles(e.getProject(), e);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/editorconfig/configmanagement/EditorConfigActionUtil$1", "actionPerformed"));
            }
        };
    }

    public static void showEditorConfigFiles(@NotNull Project project, @NotNull AnActionEvent event) {
        if (project == null) {
            EditorConfigActionUtil.$$$reportNull$$$0(5);
        }
        if (event == null) {
            EditorConfigActionUtil.$$$reportNull$$$0(6);
        }
        SearchEverywhereManager seManager = SearchEverywhereManager.getInstance((Project)project);
        String searchProviderID = FileSearchEverywhereContributor.class.getSimpleName();
        if (seManager.isShown() && !searchProviderID.equals(seManager.getSelectedTabID())) {
            seManager.setSelectedTabID(searchProviderID);
        }
        seManager.show(searchProviderID, ".editorconfig", event);
    }

    public static void setEditorConfigEnabled(@NotNull Project project, boolean ecEnabled) {
        if (project == null) {
            EditorConfigActionUtil.$$$reportNull$$$0(7);
        }
        EditorConfigSettings settings = (EditorConfigSettings)CodeStyle.getSettings((Project)project).getCustomSettings(EditorConfigSettings.class);
        if (settings.ENABLED == ecEnabled) {
            return;
        }
        settings.ENABLED = ecEnabled;
        CodeStyleSettingsManager.getInstance((Project)project).notifyCodeStyleSettingsChanged();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/editorconfig/configmanagement/EditorConfigActionUtil";
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/editorconfig/configmanagement/EditorConfigActionUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createNavigationActions";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createDisableAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createNavigationActions";
                break;
            }
            case 1: 
            case 4: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createDisableAction";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "showEditorConfigFiles";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setEditorConfigEnabled";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4 -> new IllegalStateException(string);
        };
    }
}

