/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate.preserveorder;

import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.graph.Layer;
import org.eclipse.elk.alg.layered.intermediate.preserveorder.ModelOrderPortComparator;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.options.LongEdgeOrderingStrategy;
import org.eclipse.elk.alg.layered.options.OrderingStrategy;

public class ModelOrderNodeComparator
implements Comparator<LNode> {
    private LNode[] previousLayer;
    private final OrderingStrategy orderingStrategy;
    private HashMap<LNode, HashSet<LNode>> biggerThan = new HashMap();
    private HashMap<LNode, HashSet<LNode>> smallerThan = new HashMap();
    private LongEdgeOrderingStrategy longEdgeNodeOrder = LongEdgeOrderingStrategy.EQUAL;
    private boolean beforePorts;

    public ModelOrderNodeComparator(Layer thePreviousLayer, OrderingStrategy orderingStrategy, LongEdgeOrderingStrategy longEdgeOrderingStrategy, boolean beforePorts) {
        this(orderingStrategy, longEdgeOrderingStrategy, beforePorts);
        this.previousLayer = new LNode[thePreviousLayer.getNodes().size()];
        thePreviousLayer.getNodes().toArray(this.previousLayer);
    }

    public ModelOrderNodeComparator(LNode[] previousLayer, OrderingStrategy orderingStrategy, LongEdgeOrderingStrategy longEdgeOrderingStrategy, boolean beforePorts) {
        this(orderingStrategy, longEdgeOrderingStrategy, beforePorts);
        this.previousLayer = previousLayer;
    }

    private ModelOrderNodeComparator(OrderingStrategy orderingStrategy, LongEdgeOrderingStrategy longEdgeOrderingStrategy, boolean beforePorts) {
        this.orderingStrategy = orderingStrategy;
        this.longEdgeNodeOrder = longEdgeOrderingStrategy;
        this.beforePorts = beforePorts;
    }

    @Override
    public int compare(LNode n1, LNode n2) {
        if (!this.biggerThan.containsKey(n1)) {
            this.biggerThan.put(n1, new HashSet());
        } else if (this.biggerThan.get(n1).contains(n2)) {
            return 1;
        }
        if (!this.biggerThan.containsKey(n2)) {
            this.biggerThan.put(n2, new HashSet());
        } else if (this.biggerThan.get(n2).contains(n1)) {
            return -1;
        }
        if (!this.smallerThan.containsKey(n1)) {
            this.smallerThan.put(n1, new HashSet());
        } else if (this.smallerThan.get(n1).contains(n2)) {
            return -1;
        }
        if (!this.smallerThan.containsKey(n2)) {
            this.smallerThan.put(n2, new HashSet());
        } else if (this.biggerThan.get(n2).contains(n1)) {
            return 1;
        }
        if (this.orderingStrategy == OrderingStrategy.PREFER_EDGES || !n1.hasProperty(InternalProperties.MODEL_ORDER) || !n2.hasProperty(InternalProperties.MODEL_ORDER)) {
            int comparedWithLongEdgeFeedback;
            LPort p1SourcePort = null;
            for (LPort p : n1.getPorts()) {
                if (p.getIncomingEdges().isEmpty() || p.getIncomingEdges().get((int)0).getSource().getNode().getLayer().id != n1.getLayer().id - 1) continue;
                p1SourcePort = p.getIncomingEdges().get(0).getSource();
            }
            LPort p2SourcePort = null;
            for (LPort p : n2.getPorts()) {
                if (p.getIncomingEdges().isEmpty() || p.getIncomingEdges().get((int)0).getSource().getNode().getLayer().id != n2.getLayer().id - 1) continue;
                p2SourcePort = p.getIncomingEdges().get(0).getSource();
            }
            if (p1SourcePort != null && p2SourcePort != null) {
                LNode p1Node = p1SourcePort.getNode();
                LNode p2Node = p2SourcePort.getNode();
                if (p1Node != null && p1Node.equals(p2Node)) {
                    int n2EdgeOrder;
                    for (LPort port : p1Node.getPorts()) {
                        if (port.equals(p1SourcePort)) {
                            this.updateBiggerAndSmallerAssociations(n2, n1);
                            return -1;
                        }
                        if (!port.equals(p2SourcePort)) continue;
                        this.updateBiggerAndSmallerAssociations(n1, n2);
                        return 1;
                    }
                    assert (false);
                    int n1EdgeOrder = this.getModelOrderFromConnectedEdges(n1);
                    if (n1EdgeOrder > (n2EdgeOrder = this.getModelOrderFromConnectedEdges(n2))) {
                        this.updateBiggerAndSmallerAssociations(n1, n2);
                        return 1;
                    }
                    this.updateBiggerAndSmallerAssociations(n2, n1);
                    return -1;
                }
                LNode[] lNodeArray = this.previousLayer;
                int n = this.previousLayer.length;
                int n3 = 0;
                while (n3 < n) {
                    LNode previousNode = lNodeArray[n3];
                    if (previousNode.equals(p1Node)) {
                        this.updateBiggerAndSmallerAssociations(n2, n1);
                        return -1;
                    }
                    if (previousNode.equals(p2Node)) {
                        this.updateBiggerAndSmallerAssociations(n1, n2);
                        return 1;
                    }
                    ++n3;
                }
            }
            if (p1SourcePort != null && p2SourcePort == null || p1SourcePort == null && p2SourcePort != null) {
                int comparedWithLongEdgeFeedback2 = this.handleHelperDummyNodes(n1, n2);
                if (comparedWithLongEdgeFeedback2 != 0) {
                    if (comparedWithLongEdgeFeedback2 > 0) {
                        this.updateBiggerAndSmallerAssociations(n1, n2);
                    } else {
                        this.updateBiggerAndSmallerAssociations(n2, n1);
                    }
                    return comparedWithLongEdgeFeedback2;
                }
                if (!n1.hasProperty(InternalProperties.MODEL_ORDER) || !n2.hasProperty(InternalProperties.MODEL_ORDER)) {
                    int n2ModelOrder;
                    int n1ModelOrder = this.getModelOrderFromConnectedEdges(n1);
                    if (n1ModelOrder > (n2ModelOrder = this.getModelOrderFromConnectedEdges(n2))) {
                        this.updateBiggerAndSmallerAssociations(n1, n2);
                        return 1;
                    }
                    this.updateBiggerAndSmallerAssociations(n2, n1);
                    return -1;
                }
            }
            if (p1SourcePort == null && p2SourcePort == null && (comparedWithLongEdgeFeedback = this.handleHelperDummyNodes(n1, n2)) != 0) {
                if (comparedWithLongEdgeFeedback > 0) {
                    this.updateBiggerAndSmallerAssociations(n1, n2);
                } else {
                    this.updateBiggerAndSmallerAssociations(n2, n1);
                }
                return comparedWithLongEdgeFeedback;
            }
        }
        if (n1.hasProperty(InternalProperties.MODEL_ORDER) && n2.hasProperty(InternalProperties.MODEL_ORDER)) {
            int n2ModelOrder;
            int n1ModelOrder = n1.getProperty(InternalProperties.MODEL_ORDER);
            if (n1ModelOrder > (n2ModelOrder = n2.getProperty(InternalProperties.MODEL_ORDER).intValue())) {
                this.updateBiggerAndSmallerAssociations(n1, n2);
                return 1;
            }
            this.updateBiggerAndSmallerAssociations(n2, n1);
            return -1;
        }
        this.updateBiggerAndSmallerAssociations(n2, n1);
        return -1;
    }

    private int getModelOrderFromConnectedEdges(LNode n) {
        LEdge edge;
        LPort sourcePort = n.getPorts().stream().filter(p -> !p.getIncomingEdges().isEmpty()).findFirst().orElse(null);
        if (sourcePort != null && (edge = sourcePort.getIncomingEdges().get(0)) != null) {
            return edge.getProperty(InternalProperties.MODEL_ORDER);
        }
        return this.longEdgeNodeOrder.returnValue();
    }

    private void updateBiggerAndSmallerAssociations(LNode bigger, LNode smaller) {
        HashSet<LNode> biggerNodeBiggerThan = this.biggerThan.get(bigger);
        HashSet<LNode> smallerNodeBiggerThan = this.biggerThan.get(smaller);
        HashSet<LNode> biggerNodeSmallerThan = this.smallerThan.get(bigger);
        HashSet<LNode> smallerNodeSmallerThan = this.smallerThan.get(smaller);
        biggerNodeBiggerThan.add(smaller);
        smallerNodeSmallerThan.add(bigger);
        for (LNode verySmall : smallerNodeBiggerThan) {
            biggerNodeBiggerThan.add(verySmall);
            this.smallerThan.get(verySmall).add(bigger);
            this.smallerThan.get(verySmall).addAll(biggerNodeSmallerThan);
        }
        for (LNode veryBig : biggerNodeSmallerThan) {
            smallerNodeSmallerThan.add(veryBig);
            this.biggerThan.get(veryBig).add(smaller);
            this.biggerThan.get(veryBig).addAll(smallerNodeBiggerThan);
        }
    }

    private int handleHelperDummyNodes(LNode n1, LNode n2) {
        if (n1.getType() == LNode.NodeType.LONG_EDGE && n2.getType() == LNode.NodeType.NORMAL) {
            LPort dummyNodeSourcePort = this.getFirstIncomingSourcePortOfNode(n1);
            LNode dummyNodeSourceNode = dummyNodeSourcePort.getNode();
            LPort dummyNodeTargetPort = this.getFirstOutgoingTargetPortOfNode(n1);
            LNode dummyNodeTargetNode = dummyNodeTargetPort.getNode();
            int dummyLayerId = n1.getLayer().id;
            if (dummyNodeSourceNode.getLayer().id != dummyLayerId && dummyNodeTargetNode.getLayer().id != dummyLayerId) {
                return 0;
            }
            if (dummyNodeSourceNode.equals(n2)) {
                this.updateBiggerAndSmallerAssociations(n1, n2);
                return 1;
            }
            if (dummyNodeTargetNode.equals(n2)) {
                this.updateBiggerAndSmallerAssociations(n1, n2);
                return 1;
            }
            return this.compare(dummyNodeSourceNode, n2);
        }
        if (n1.getType() == LNode.NodeType.NORMAL && n2.getType() == LNode.NodeType.LONG_EDGE) {
            LPort dummyNodeSourcePort = this.getFirstIncomingSourcePortOfNode(n2);
            LNode dummyNodeSourceNode = dummyNodeSourcePort.getNode();
            LPort dummyNodeTargetPort = this.getFirstOutgoingTargetPortOfNode(n2);
            LNode dummyNodeTargetNode = dummyNodeTargetPort.getNode();
            int dummyLayerId = n1.getLayer().id;
            if (dummyNodeSourceNode.getLayer().id != dummyLayerId && dummyNodeTargetNode.getLayer().id != dummyLayerId) {
                return 0;
            }
            if (dummyNodeSourceNode.equals(n1)) {
                this.updateBiggerAndSmallerAssociations(n2, n1);
                return -1;
            }
            if (dummyNodeTargetNode.equals(n1)) {
                this.updateBiggerAndSmallerAssociations(n2, n1);
                return -1;
            }
            return this.compare(n1, dummyNodeSourceNode);
        }
        if (n1.getType() == LNode.NodeType.LONG_EDGE && n2.getType() == LNode.NodeType.LONG_EDGE) {
            LPort n1dummyNodeSourcePort = this.getFirstIncomingSourcePortOfNode(n1);
            LPort n1dummyNodeTargetPort = this.getFirstOutgoingTargetPortOfNode(n1);
            LNode n1dummySourceNode = n1dummyNodeSourcePort.getNode();
            LNode n1dummyTargetNode = n1dummyNodeTargetPort.getNode();
            int n1LayerId = n1.getLayer().id;
            boolean n1SourceFeedbackNode = false;
            boolean n1TargetFeedbackNode = false;
            LPort n2dummyNodeSourcePort = this.getFirstIncomingSourcePortOfNode(n2);
            LPort n2dummyNodeTargetPort = this.getFirstOutgoingTargetPortOfNode(n2);
            LNode n2dummySourceNode = n2dummyNodeSourcePort.getNode();
            LNode n2dummyTargetNode = n2dummyNodeTargetPort.getNode();
            int n2LayerId = n2.getLayer().id;
            boolean n2SourceFeedbackNode = false;
            boolean n2TargetFeedbackNode = false;
            LNode n1ReferenceNode = n1;
            LNode n2ReferenceNode = n2;
            if (n1dummySourceNode.getLayer().id == n1LayerId) {
                n1SourceFeedbackNode = true;
                n1ReferenceNode = n1dummySourceNode;
            } else if (n1dummyTargetNode.getLayer().id == n1LayerId) {
                n1TargetFeedbackNode = true;
                n1ReferenceNode = n1dummyTargetNode;
            }
            if (n2dummySourceNode.getLayer().id == n2LayerId) {
                n2SourceFeedbackNode = true;
                n2ReferenceNode = n2dummySourceNode;
            } else if (n2dummyTargetNode.getLayer().id == n2LayerId) {
                n2TargetFeedbackNode = true;
                n2ReferenceNode = n2dummyTargetNode;
            }
            if (n1ReferenceNode.equals(n2ReferenceNode)) {
                if (this.beforePorts) {
                    if (n1SourceFeedbackNode && n2SourceFeedbackNode) {
                        int returnValue = new ModelOrderPortComparator(this.previousLayer, this.orderingStrategy, null, n2TargetFeedbackNode).compare(n1dummyNodeSourcePort, n2dummyNodeSourcePort);
                        if (returnValue > 0) {
                            this.updateBiggerAndSmallerAssociations(n2, n1);
                            return 1;
                        }
                        this.updateBiggerAndSmallerAssociations(n1, n2);
                        return -1;
                    }
                    if (n1SourceFeedbackNode && n2TargetFeedbackNode) {
                        this.updateBiggerAndSmallerAssociations(n2, n1);
                        return 1;
                    }
                    if (n1TargetFeedbackNode && n2SourceFeedbackNode) {
                        this.updateBiggerAndSmallerAssociations(n1, n2);
                        return -1;
                    }
                    if (n1TargetFeedbackNode && n2TargetFeedbackNode) {
                        return 0;
                    }
                } else {
                    for (LPort port : n1ReferenceNode.getPorts()) {
                        if (n1dummyNodeSourcePort.equals(port)) {
                            this.updateBiggerAndSmallerAssociations(n2, n1);
                            return -1;
                        }
                        if (!n2dummyNodeSourcePort.equals(port)) continue;
                        this.updateBiggerAndSmallerAssociations(n1, n2);
                        return 1;
                    }
                }
            }
            return this.compare(n1ReferenceNode, n2ReferenceNode);
        }
        return 0;
    }

    private LPort getFirstIncomingPortOfNode(LNode node) {
        return node.getPorts().stream().filter(p -> !p.getIncomingEdges().isEmpty()).findFirst().orElse(null);
    }

    private LPort getFirstIncomingSourcePortOfNode(LNode node) {
        return this.getFirstIncomingPortOfNode(node).getIncomingEdges().get(0).getSource();
    }

    private LPort getFirstOutgoingPortOfNode(LNode node) {
        return node.getPorts().stream().filter(p -> !p.getOutgoingEdges().isEmpty()).findFirst().orElse(null);
    }

    private LPort getFirstOutgoingTargetPortOfNode(LNode node) {
        return this.getFirstOutgoingPortOfNode(node).getOutgoingEdges().get(0).getTarget();
    }

    public void clearTransitiveOrdering() {
        this.biggerThan = new HashMap();
        this.smallerThan = new HashMap();
    }
}

