/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.timingdiagram.command;

import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.ParserPass;
import net.sourceforge.plantuml.klimt.color.NoSuchColorException;
import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.regex.RegexConcat;
import net.sourceforge.plantuml.regex.RegexLeaf;
import net.sourceforge.plantuml.regex.RegexOptional;
import net.sourceforge.plantuml.regex.RegexResult;
import net.sourceforge.plantuml.timingdiagram.Player;
import net.sourceforge.plantuml.timingdiagram.TimeTick;
import net.sourceforge.plantuml.timingdiagram.TimingDiagram;
import net.sourceforge.plantuml.timingdiagram.command.CommandChangeState;
import net.sourceforge.plantuml.utils.LineLocation;

public class CommandChangeStateByPlayerCode
extends CommandChangeState {
    public CommandChangeStateByPlayerCode() {
        super(CommandChangeStateByPlayerCode.getRegexConcat());
    }

    private static IRegex getRegexConcat() {
        return RegexConcat.build(CommandChangeStateByPlayerCode.class.getName(), RegexLeaf.start(), new RegexLeaf(1, "CODE", "([\\p{L}_][%pLN_.]*)"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("is"), RegexLeaf.spaceZeroOrMore(), CommandChangeStateByPlayerCode.getStateOrHidden(), RegexLeaf.spaceZeroOrMore(), CommandChangeStateByPlayerCode.color().getRegex(), RegexLeaf.spaceZeroOrMore(), new RegexOptional((IRegex)new RegexConcat(RegexLeaf.spaceZeroOrMore(), new RegexLeaf(":"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf(1, "COMMENT", "(.*?)"))), RegexLeaf.spaceZeroOrMore(), RegexLeaf.end());
    }

    @Override
    protected final CommandExecutionResult executeArg(TimingDiagram diagram, LineLocation location, RegexResult arg, ParserPass currentPass) throws NoSuchColorException {
        String code = arg.get("CODE", 0);
        Player player = diagram.getPlayer(code);
        if (player == null) {
            return CommandExecutionResult.error("Unkown \"" + code + "\"");
        }
        TimeTick now = diagram.getNow();
        return this.addState(diagram, arg, player, now);
    }
}

