/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.BlockUml;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.SourceStringReader;
import net.sourceforge.plantuml.Stdrpt;
import net.sourceforge.plantuml.UmlDiagram;
import net.sourceforge.plantuml.cli.CliFlag;
import net.sourceforge.plantuml.cli.CliOptions;
import net.sourceforge.plantuml.cli.ErrorStatus;
import net.sourceforge.plantuml.core.Diagram;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.error.PSystemError;
import net.sourceforge.plantuml.preproc.Defines;
import net.sourceforge.plantuml.security.SFile;

public class Pipe {
    private final CliOptions option;
    private final BufferedReader br;
    private final PrintStream ps;
    private final Stdrpt stdrpt;

    public Pipe(CliOptions option, PrintStream ps, InputStream is, String charset) {
        this.option = option;
        try {
            this.br = new BufferedReader(new InputStreamReader(is, charset != null ? charset : Charset.defaultCharset().name()));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Invalid charset provided", e);
        }
        this.ps = ps;
        this.stdrpt = option.getStdrpt();
    }

    public void managePipe(ErrorStatus error) throws IOException {
        boolean noStdErr = this.option.isTrue(CliFlag.PIPENOSTDERR);
        String source = this.readFirstDiagram();
        while (source != null) {
            Defines defines = this.option.getDefaultDefines();
            SFile newCurrentDir = this.option.getFileDir() == null ? null : new SFile(this.option.getFileDir());
            SourceStringReader sourceStringReader = new SourceStringReader(defines, source, StandardCharsets.UTF_8, this.option.getConfig(), newCurrentDir);
            if (this.option.isTrue(CliFlag.COMPUTE_URL)) {
                this.computeUrlForDiagram(sourceStringReader);
            } else if (this.option.isTrue(CliFlag.SYNTAX)) {
                this.syntaxCheckDiagram(sourceStringReader, error);
            } else if (this.option.isTrue(CliFlag.PIPEMAP)) {
                this.createPipeMapForDiagram(sourceStringReader, error);
            } else {
                this.generateDiagram(sourceStringReader, error, noStdErr);
            }
            this.ps.flush();
            source = this.readSubsequentDiagram();
        }
    }

    private void generateDiagram(SourceStringReader sourceStringReader, ErrorStatus error, boolean noStdErr) throws IOException {
        OutputStream os = noStdErr ? new ByteArrayOutputStream() : this.ps;
        DiagramDescription result = sourceStringReader.outputImage(os, this.option.getImageIndex(), this.option.getFileFormatOption());
        this.printInfo(noStdErr ? this.ps : System.err, sourceStringReader);
        if (result != null && "(error)".equalsIgnoreCase(result.getDescription())) {
            error.incError();
        } else {
            error.incOk();
            if (noStdErr) {
                OutputStream baos = os;
                ((ByteArrayOutputStream)baos).close();
                this.ps.write(((ByteArrayOutputStream)baos).toByteArray());
            }
        }
        if (this.option.getString(CliFlag.PIPEDELIMITOR) != null) {
            this.ps.println(this.option.getString(CliFlag.PIPEDELIMITOR));
        }
    }

    private void createPipeMapForDiagram(SourceStringReader sourceStringReader, ErrorStatus error) throws IOException {
        String result = sourceStringReader.getCMapData(this.option.getImageIndex(), new FileFormatOption(FileFormat.PNG));
        error.incOk();
        if (result == null) {
            this.ps.println();
        } else {
            this.ps.println(result);
        }
    }

    private void computeUrlForDiagram(SourceStringReader sourceStringReader) throws IOException {
        for (BlockUml s : sourceStringReader.getBlocks()) {
            this.ps.println(s.getEncodedUrl());
        }
    }

    private void syntaxCheckDiagram(SourceStringReader sourceStringReader, ErrorStatus error) {
        Diagram system = sourceStringReader.getBlocks().get(0).getDiagram();
        if (system instanceof UmlDiagram) {
            error.incOk();
            this.ps.println(((UmlDiagram)system).getUmlDiagramType().name());
            this.ps.println(system.getDescription());
        } else if (system instanceof PSystemError) {
            error.incError();
            this.stdrpt.printInfo(this.ps, system);
        } else {
            error.incOk();
            this.ps.println("OTHER");
            this.ps.println(system.getDescription());
        }
    }

    private void printInfo(PrintStream output, SourceStringReader sourceStringReader) {
        List<BlockUml> blocks = sourceStringReader.getBlocks();
        if (blocks.size() == 0) {
            this.stdrpt.printInfo(output, null);
        } else {
            this.stdrpt.printInfo(output, blocks.get(0).getDiagram());
        }
    }

    String readFirstDiagram() throws IOException {
        return this.readSingleDiagram(true);
    }

    String readSubsequentDiagram() throws IOException {
        return this.readSingleDiagram(false);
    }

    String readSingleDiagram(boolean unmarkedAllowed) throws IOException {
        String line;
        State state = State.NO_CONTENT;
        String expectedEnd = null;
        StringBuilder sb = new StringBuilder();
        while (state != State.COMPLETE && (line = this.br.readLine()) != null) {
            if (line.startsWith("@@@format ")) {
                this.manageFormat(line);
                continue;
            }
            if (state == State.NO_CONTENT && line.trim().length() > 0) {
                state = State.START_MARK_NOT_FOUND;
            }
            if (state == State.START_MARK_NOT_FOUND && line.startsWith("@start")) {
                sb.setLength(0);
                state = State.START_MARK_FOUND;
                Matcher m = Pattern.compile("@start([A-Za-z]*)").matcher(line);
                expectedEnd = m.matches() ? "@end" + m.group(1) : "@end";
            } else if (state == State.START_MARK_FOUND && line.startsWith(expectedEnd)) {
                state = State.COMPLETE;
            }
            if (state == State.NO_CONTENT) continue;
            sb.append(line).append("\n");
        }
        switch (state.ordinal()) {
            case 0: {
                return null;
            }
            case 1: {
                return unmarkedAllowed ? "@startuml\n" + sb.toString() + "@enduml\n" : null;
            }
            case 2: {
                return sb.toString() + expectedEnd;
            }
            case 3: {
                return sb.toString();
            }
        }
        throw new IllegalStateException("Unexpected value: " + (Object)((Object)state));
    }

    void manageFormat(String s) {
        if ((s = s.toLowerCase()).contains("png")) {
            this.option.setFileFormatOption(new FileFormatOption(FileFormat.PNG));
        } else if (s.contains("svg")) {
            this.option.setFileFormatOption(new FileFormatOption(FileFormat.SVG));
        } else if (s.contains("atxt")) {
            this.option.setFileFormatOption(new FileFormatOption(FileFormat.ATXT));
        } else if (s.contains("utxt")) {
            this.option.setFileFormatOption(new FileFormatOption(FileFormat.UTXT));
        }
    }

    static enum State {
        NO_CONTENT,
        START_MARK_NOT_FOUND,
        START_MARK_FOUND,
        COMPLETE;

    }
}

