/*
 * Decompiled with CFR 0.152.
 */
package com.github.kokorin.jaffree.nut;

import com.github.kokorin.jaffree.nut.Timestamp;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class NutInputStream
implements AutoCloseable {
    private final InputStream input;
    private long position = 0L;

    public NutInputStream(InputStream input) {
        this.input = NutInputStream.asBuffered(input);
    }

    public long getPosition() {
        return this.position;
    }

    public long readValue() throws IOException {
        long result = 0L;
        boolean hasMore = true;
        while (hasMore) {
            int read = this.input.read();
            if (read == -1) {
                throw new EOFException("No more data");
            }
            hasMore = (read & 0x80) > 0;
            result = (result << 7) + (long)(read & 0x7F);
            ++this.position;
        }
        return result;
    }

    public long readSignedValue() throws IOException {
        long tmp = this.readValue();
        if ((++tmp & 1L) > 0L) {
            return -(tmp >> 1);
        }
        return tmp >> 1;
    }

    public long readLong() throws IOException {
        long result = 0L;
        for (int i = 0; i < 8; ++i) {
            int read = this.input.read();
            if (read == -1) {
                throw new EOFException("No more data");
            }
            result = (result << 8) + (long)read;
            ++this.position;
        }
        return result;
    }

    long readInt() throws IOException {
        long result = 0L;
        for (int i = 0; i < 4; ++i) {
            int read = this.input.read();
            if (read == -1) {
                throw new EOFException("No more data");
            }
            result = (result << 8) + (long)read;
            ++this.position;
        }
        return result;
    }

    public int readByte() throws IOException {
        int result = this.input.read();
        if (result == -1) {
            throw new EOFException("No more data");
        }
        ++this.position;
        return result;
    }

    public String readVariableString() throws IOException {
        byte[] bytes = this.readVariableBytes();
        return new String(bytes);
    }

    public String readCString() throws IOException {
        try (ByteArrayOutputStream buffer = new ByteArrayOutputStream(32);){
            while (true) {
                int read;
                if ((read = this.input.read()) == -1) {
                    throw new EOFException("No more data");
                }
                ++this.position;
                if (read == 0) break;
                buffer.write(read);
            }
            String string = buffer.toString();
            return string;
        }
    }

    public byte[] readVariableBytes() throws IOException {
        int length = (int)this.readValue();
        return this.readBytes(length);
    }

    public Timestamp readTimestamp(int timeBaseCount) throws IOException {
        long tmp = this.readValue();
        int timebaseId = (int)(tmp % (long)timeBaseCount);
        long pts = tmp / (long)timeBaseCount;
        return new Timestamp(timebaseId, pts);
    }

    public int checkNextByte() throws IOException {
        this.input.mark(1);
        int result = this.input.read();
        this.input.reset();
        return result;
    }

    public boolean hasMoreData() throws IOException {
        this.input.mark(1);
        int result = this.input.read();
        this.input.reset();
        return result != -1;
    }

    public byte[] readBytes(long toRead) throws IOException {
        byte[] result = new byte[(int)toRead];
        int start = 0;
        while ((long)start < toRead) {
            long read = this.input.read(result, start, (int)toRead - start);
            if (read == -1L) {
                throw new EOFException("No more data");
            }
            this.position += read;
            start = (int)((long)start + read);
        }
        return result;
    }

    public void skipBytes(long toSkip) throws IOException {
        long skipped;
        for (long leftToSkip = toSkip; leftToSkip > 0L; leftToSkip -= skipped) {
            skipped = this.input.skip(leftToSkip);
            if (skipped == 0L) {
                int read = this.input.read();
                if (read == -1) {
                    throw new EOFException("No more data");
                }
                skipped = 1L;
            }
            this.position += skipped;
        }
    }

    @Override
    public void close() throws IOException {
        this.input.close();
    }

    private static BufferedInputStream asBuffered(InputStream inputStream) {
        if (inputStream instanceof BufferedInputStream) {
            return (BufferedInputStream)inputStream;
        }
        return new BufferedInputStream(inputStream);
    }
}

