/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.tabs.tab_film;

import com.formdev.flatlaf.util.ScaledImageIcon;
import java.awt.Dimension;
import javax.swing.Icon;
import javax.swing.JLabel;
import mediathek.tool.GuiFunktionen;
import mediathek.tool.sender_icon_cache.MVSenderIconCache;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SenderIconLabel
extends JLabel {
    private static final Dimension ICON_DIMENSION = new Dimension(96, 96);

    public SenderIconLabel() {
        this.setText("");
        this.setIcon(null);
    }

    private void sizeToIcon(@NotNull Icon icon) {
        int height = icon.getIconHeight();
        int width = icon.getIconWidth();
        Dimension d = new Dimension(width, height);
        this.setPreferredSize(d);
    }

    public void setSender(@Nullable String sender) {
        if (sender == null) {
            this.setIcon(null);
        } else {
            MVSenderIconCache.get(sender).ifPresentOrElse(icon -> {
                Dimension imageDim = new Dimension(icon.getIconWidth(), icon.getIconHeight());
                Dimension destDim = GuiFunktionen.calculateFittedDimension(imageDim, ICON_DIMENSION);
                ScaledImageIcon origIcon = new ScaledImageIcon(icon, destDim.width, destDim.height);
                this.setText("");
                this.setIcon((Icon)origIcon);
                this.sizeToIcon((Icon)origIcon);
            }, () -> {
                this.setIcon(null);
                this.setText(sender);
            });
        }
    }
}

