/*
 * Decompiled with CFR 0.152.
 */
package mediathek.filmlisten;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.UnknownHostException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import mediathek.config.Daten;
import mediathek.config.Konstanten;
import mediathek.config.StandardLocations;
import mediathek.daten.DatenFilm;
import mediathek.daten.IndexedFilmList;
import mediathek.daten.ListeFilme;
import mediathek.filmeSuchen.ListenerFilmeLaden;
import mediathek.filmeSuchen.ListenerFilmeLadenEvent;
import mediathek.filmlisten.FilmListDownloadType;
import mediathek.filmlisten.ImportFilmliste;
import mediathek.filmlisten.reader.FilmListReader;
import mediathek.gui.duplicates.CommonStatsEvaluationTask;
import mediathek.gui.duplicates.FilmDuplicateEvaluationTask;
import mediathek.gui.messages.FilmListReadStopEvent;
import mediathek.gui.tasks.BlacklistFilterWorker;
import mediathek.gui.tasks.FilmlistWriterWorker;
import mediathek.gui.tasks.LuceneIndexWorker;
import mediathek.gui.tasks.RefreshAboWorker;
import mediathek.mainwindow.MediathekGui;
import mediathek.tool.ApplicationConfiguration;
import mediathek.tool.FilmListUpdateType;
import mediathek.tool.GuiFunktionen;
import mediathek.tool.MessageBus;
import mediathek.tool.SwingErrorDialog;
import mediathek.tool.http.MVHttpClient;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class FilmeLaden {
    private static final Logger logger = LogManager.getLogger(FilmeLaden.class);
    private static final String NETWORK_NOT_AVAILABLE = "Netzwerk nicht verf\u00fcgbar";
    private static final String NO_UPDATE_AVAILABLE = "Es ist keine aktuellere Filmliste verf\u00fcgbar.";
    private static final int HTTP_NOT_FOUND = 404;
    private final HashSet<String> hashSet = new HashSet();
    private final ListeFilme diffListe = new ListeFilme();
    private final Daten daten;
    private final ImportFilmliste importFilmliste;
    private final EventListenerList listeners = new EventListenerList();
    private boolean istAmLaufen;
    private boolean onlyOne;

    public FilmeLaden(Daten aDaten) {
        this.daten = aDaten;
        this.importFilmliste = new ImportFilmliste();
        this.importFilmliste.addAdListener(new ListenerFilmeLaden(){

            @Override
            public synchronized void start(ListenerFilmeLadenEvent event) {
                FilmeLaden.this.notifyStart(event);
            }

            @Override
            public synchronized void progress(ListenerFilmeLadenEvent event) {
                FilmeLaden.this.notifyProgress(event);
            }

            @Override
            public synchronized void fertig(ListenerFilmeLadenEvent event) {
                logger.trace("Filme laden, ende");
                FilmeLaden.this.undEnde(event);
            }
        });
    }

    private void showNoUpdateAvailableDialog() {
        JOptionPane.showMessageDialog(MediathekGui.ui(), NO_UPDATE_AVAILABLE, "MediathekView", 1);
    }

    private boolean hasNewRemoteFilmlist() {
        boolean result2;
        block25: {
            result2 = false;
            logger.trace("hasNewRemoteFilmList()");
            String id = Daten.getInstance().getListeFilme().getMetaData().getId();
            boolean showDialogs = GuiFunktionen.getFilmListUpdateType() != FilmListUpdateType.AUTOMATIC;
            HttpUrl filmListUrl = Konstanten.ROUTER_BASE_URL.resolve("filmliste.id");
            Request request = new Request.Builder().url(Objects.requireNonNull(filmListUrl)).build();
            try (Response response = MVHttpClient.getInstance().getHttpClient().newCall(request).execute();
                 ResponseBody body = response.body();){
                if (response.isSuccessful()) {
                    String remoteId = body.string();
                    if (!remoteId.isEmpty() && !remoteId.equalsIgnoreCase(id)) {
                        result2 = true;
                    }
                } else {
                    logger.warn("hasNewRemoteFilmlist HTTP Response Code: {} for {}", (Object)response.code(), (Object)response.request().url());
                    if (response.code() == 404) {
                        result2 = true;
                    }
                }
                if (!result2) {
                    if (showDialogs) {
                        this.showNoUpdateAvailableDialog();
                    } else {
                        logger.info(NO_UPDATE_AVAILABLE);
                    }
                }
            }
            catch (UnknownHostException ex) {
                logger.debug((Object)ex);
                if (showDialogs) {
                    SwingErrorDialog.showExceptionMessage(MediathekGui.ui(), NETWORK_NOT_AVAILABLE, ex);
                } else {
                    logger.warn(NETWORK_NOT_AVAILABLE);
                }
            }
            catch (IOException ex) {
                logger.error("IOxception:", (Throwable)ex);
                SwingErrorDialog.showExceptionMessage(MediathekGui.ui(), "Netzwerkfehler aufgetreten!", ex);
            }
            catch (Exception ex) {
                logger.error("check for filmliste.id failed", (Throwable)ex);
                if (!showDialogs) break block25;
                SwingErrorDialog.showExceptionMessage(MediathekGui.ui(), "Ein unbekannter Fehler ist aufgetreten.", ex);
            }
        }
        return result2;
    }

    private boolean performUpdateCheck(ListeFilme listeFilme, String dateiUrl) {
        boolean result2 = true;
        if (listeFilme.isEmpty()) {
            return true;
        }
        if ((dateiUrl.isEmpty() || dateiUrl.startsWith("http")) && !listeFilme.getMetaData().canUseDiffList() && !this.hasNewRemoteFilmlist()) {
            result2 = false;
        }
        return result2;
    }

    private void prepareHashTable() {
        this.hashSet.clear();
        this.fillHash(this.daten.getListeFilme());
    }

    private void displayLogInfo(@NotNull ListeFilme listeFilme) {
        logger.info("Alte Liste erstellt am: {}", (Object)listeFilme.getMetaData().getGenerationDateTimeAsString());
        logger.info("  Anzahl Filme: {}", (Object)listeFilme.size());
        logger.info("  Anzahl Neue: {}", (Object)listeFilme.countNewFilms());
    }

    public boolean loadFilmlist(String dateiUrl, boolean immerNeuLaden) {
        ListeFilme listeFilme = this.daten.getListeFilme();
        if (!this.performUpdateCheck(listeFilme, dateiUrl)) {
            return false;
        }
        logger.trace("loadFilmlist(String,boolean)");
        logger.info("");
        this.displayLogInfo(listeFilme);
        if (!this.istAmLaufen) {
            this.istAmLaufen = true;
            this.prepareHashTable();
            if (immerNeuLaden) {
                listeFilme.clear();
            }
            this.daten.getListeFilmeNachBlackList().clear();
            int days = ApplicationConfiguration.getConfiguration().getInt("filmlist.load.days", 0);
            if (dateiUrl.isEmpty()) {
                logger.info("Filmliste laden (Netzwerk)");
                this.importFilmliste.importFromUrl(listeFilme, this.diffListe, days);
            } else {
                logger.info("Filmliste laden von: {}", (Object)dateiUrl);
                listeFilme.clear();
                this.importFilmliste.importFromFile(dateiUrl, listeFilme, days);
            }
        }
        return true;
    }

    public void updateFilmlist(String dateiUrl) {
        logger.debug("Filme laden (Update), start");
        logger.info("");
        this.displayLogInfo(this.daten.getListeFilme());
        if (!this.istAmLaufen) {
            this.istAmLaufen = true;
            this.prepareHashTable();
            this.daten.getListeFilmeNachBlackList().clear();
            logger.info("Filmliste laden von: {}", (Object)dateiUrl);
            int num_days = ApplicationConfiguration.getConfiguration().getInt("filmlist.load.days", 0);
            if (dateiUrl.isEmpty()) {
                dateiUrl = StandardLocations.getFilmListUrl(FilmListDownloadType.FULL);
            }
            this.importFilmliste.importFromFile(dateiUrl, this.diffListe, num_days);
        }
    }

    public void addAdListener(ListenerFilmeLaden listener) {
        this.listeners.add(ListenerFilmeLaden.class, listener);
    }

    private void undEnde(ListenerFilmeLadenEvent event) {
        boolean writeFilmList;
        logger.debug("undEnde()");
        ListeFilme listeFilme = this.daten.getListeFilme();
        String readDate = DateTimeFormatter.ofPattern("dd.MM.yyyy, HH:mm").format(LocalDateTime.ofInstant(Instant.now(), ZoneId.systemDefault()));
        if (!this.diffListe.isEmpty()) {
            logger.info("Liste Diff gelesen am: {}", (Object)readDate);
            logger.info("  Liste Diff erstellt am: {}", (Object)this.diffListe.getMetaData().getGenerationDateTimeAsString());
            logger.info("  Anzahl Filme: {}", (Object)this.diffListe.size());
            listeFilme.updateFromFilmList(this.diffListe);
            listeFilme.setMetaData(this.diffListe.getMetaData());
            Collections.sort(listeFilme);
            this.diffListe.clear();
        } else {
            logger.info("Liste Kompl. gelesen am: {}", (Object)readDate);
            logger.info("  Liste Kompl erstellt am: {}", (Object)listeFilme.getMetaData().getGenerationDateTimeAsString());
            logger.info("  Anzahl Filme: {}", (Object)listeFilme.size());
        }
        this.findAndMarkNewFilms(this.daten.getListeFilme());
        MediathekGui ui = MediathekGui.ui();
        this.istAmLaufen = false;
        if (event.fehler) {
            logger.info("");
            logger.info("Filmliste laden war fehlerhaft, alte Liste wird wieder geladen");
            SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(MediathekGui.ui(), "Das Laden der Filmliste hat nicht geklappt!", "MediathekView", 0));
            listeFilme.clear();
            try (FilmListReader reader = new FilmListReader();){
                int num_days = ApplicationConfiguration.getConfiguration().getInt("filmlist.load.days", 0);
                reader.readFilmListe(StandardLocations.getFilmlistFilePathString(), listeFilme, num_days);
            }
            logger.info("");
            writeFilmList = false;
        } else {
            writeFilmList = !Daten.dontWriteFilmlistOnStartup.get();
        }
        logger.info("");
        logger.info("Jetzige Liste erstellt am: {}", (Object)listeFilme.getMetaData().getGenerationDateTimeAsString());
        logger.info("  Anzahl Filme: {}", (Object)listeFilme.size());
        logger.info("  Anzahl Neue:  {}", (Object)listeFilme.countNewFilms());
        logger.info("");
        MessageBus.getMessageBus().publishAsync((Object)new FilmListReadStopEvent());
        JLabel progLabel = MediathekGui.ui().progressLabel;
        JProgressBar progressBar = MediathekGui.ui().progressBar;
        try {
            SwingUtilities.invokeAndWait(() -> {
                ui.swingStatusBar.add(progLabel);
                ui.swingStatusBar.add(progressBar);
            });
        }
        catch (InterruptedException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        CompletionStage workerTask = CompletableFuture.runAsync(new RefreshAboWorker(progLabel, progressBar)).thenRun(new BlacklistFilterWorker(progLabel, progressBar));
        boolean evaluateDuplicates = ApplicationConfiguration.getConfiguration().getBoolean("film.evaluate_duplicates", true);
        if (evaluateDuplicates) {
            workerTask = ((CompletableFuture)workerTask).thenRun(new FilmDuplicateEvaluationTask());
        }
        workerTask = ((CompletableFuture)workerTask).thenRun(new CommonStatsEvaluationTask());
        if (writeFilmList) {
            workerTask = ((CompletableFuture)workerTask).thenRun(new FilmlistWriterWorker(progLabel, progressBar));
        }
        if (this.daten.getListeFilmeNachBlackList() instanceof IndexedFilmList) {
            workerTask = ((CompletableFuture)workerTask).thenRun(new LuceneIndexWorker(progLabel, progressBar));
        }
        ((CompletableFuture)((CompletableFuture)workerTask).thenRun(() -> SwingUtilities.invokeLater(() -> Daten.getInstance().getFilmeLaden().notifyFertig(new ListenerFilmeLadenEvent("", "", 100, 100, false))))).thenRun(() -> {
            try {
                SwingUtilities.invokeAndWait(() -> {
                    ui.swingStatusBar.remove(progressBar);
                    ui.swingStatusBar.remove(progLabel);
                });
            }
            catch (InterruptedException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private void fillHash(ListeFilme listeFilme) {
        this.hashSet.addAll(listeFilme.parallelStream().map(DatenFilm::getUrlNormalQuality).toList());
    }

    private void findAndMarkNewFilms(@NotNull ListeFilme listeFilme) {
        listeFilme.parallelStream().filter(DatenFilm::isNew).forEach(film -> film.setNew(false));
        listeFilme.parallelStream().filter(film -> !this.hashSet.contains(film.getUrlNormalQuality())).forEach(film -> film.setNew(true));
        this.hashSet.clear();
    }

    public void notifyStart(ListenerFilmeLadenEvent e) {
        try {
            SwingUtilities.invokeLater(() -> {
                for (ListenerFilmeLaden l : (ListenerFilmeLaden[])this.listeners.getListeners(ListenerFilmeLaden.class)) {
                    l.start(e);
                }
            });
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
    }

    public void notifyProgress(ListenerFilmeLadenEvent e) {
        try {
            SwingUtilities.invokeLater(() -> {
                for (ListenerFilmeLaden l : (ListenerFilmeLaden[])this.listeners.getListeners(ListenerFilmeLaden.class)) {
                    l.progress(e);
                }
            });
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
    }

    public void notifyFertig(ListenerFilmeLadenEvent e) {
        ListenerFilmeLaden[] listListeners = (ListenerFilmeLaden[])this.listeners.getListeners(ListenerFilmeLaden.class);
        try {
            SwingUtilities.invokeLater(() -> {
                for (ListenerFilmeLaden lst : listListeners) {
                    lst.fertig(e);
                }
            });
            if (!this.onlyOne) {
                this.onlyOne = true;
                SwingUtilities.invokeLater(() -> {
                    for (ListenerFilmeLaden lst : listListeners) {
                        lst.fertigOnlyOne(e);
                    }
                });
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
    }
}

