/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.range;

import com.jidesoft.range.AbstractNumericRange;
import com.jidesoft.range.Range;

public class LongRange
extends AbstractNumericRange<Long> {
    protected long _min;
    protected long _max;

    public LongRange() {
        this(0L, 1L);
    }

    public LongRange(long min, long max) {
        this._min = Math.min(min, max);
        this._max = Math.max(min, max);
    }

    public LongRange(LongRange integerRange) {
        this((long)integerRange.minimum(), (long)integerRange.maximum());
    }

    @Override
    public Range<Long> copy() {
        return new LongRange(this);
    }

    @Override
    public double minimum() {
        return this._min;
    }

    @Override
    public double maximum() {
        return this._max;
    }

    public long getMin() {
        return this._min;
    }

    public void setMin(long min) {
        long old = this._min;
        if (old == min) {
            return;
        }
        assert (min <= this._max) : "minimum " + min + " not <= " + this._max;
        this._min = min;
        this.firePropertyChange("min", old, min);
    }

    public long getMax() {
        return this._max;
    }

    public void setMax(long max) {
        long old = this._max;
        if (old == max) {
            return;
        }
        assert (max >= this._min) : "maximum " + max + " not >= " + this._min;
        this._max = max;
        this.firePropertyChange("max", old, max);
    }

    @Override
    public void adjust(Long lower, Long upper) {
        double size = this.size();
        if (lower != null) {
            this.setMin(lower);
        } else if (upper != null) {
            this.setMin(upper - (long)size);
        }
        if (upper != null) {
            this.setMax(upper);
        } else if (lower != null) {
            this.setMin(lower + (long)size);
        }
    }

    @Override
    public double size() {
        return this._max - this._min;
    }

    @Override
    public Long lower() {
        return (long)this.minimum();
    }

    @Override
    public Long upper() {
        return (long)this.maximum();
    }

    @Override
    public boolean contains(Long x) {
        return x >= this._min && x <= this._max;
    }

    @Override
    public Range<Long> createIntermediate(Range<Long> targetRange, double position) {
        double sourceMin = this.minimum();
        double sourceMax = this.maximum();
        double targetMin = targetRange.minimum();
        double targetMax = targetRange.maximum();
        double min = sourceMin + position * (targetMin - sourceMin);
        double max = sourceMax + position * (targetMax - sourceMax);
        return new LongRange((int)Math.round(min), (int)Math.round(max));
    }

    public boolean equals(Object other) {
        if (other instanceof LongRange) {
            LongRange otherRange = (LongRange)other;
            return this._min == otherRange._min && this._max == otherRange._max;
        }
        return false;
    }

    public int hashCode() {
        return (int)(this._max * 29L + this._min);
    }

    public String toString() {
        return String.format("#<LongRange min=%d max=%d>", this._min, this._max);
    }
}

