/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.Result;
import org.hsqldb.Select;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.View;
import org.hsqldb.lib.ObjectComparator;

class SubQuery
implements ObjectComparator {
    int level;
    boolean hasParams;
    boolean isResolved;
    boolean isExistsPredicate;
    boolean uniqueRows;
    Select select;
    Table table;
    View view;
    boolean isMaterialised;

    SubQuery() {
    }

    void populateTable(Session session) throws HsqlException {
        Result result = this.select.getResult(session, this.isExistsPredicate ? 1 : 0);
        if (this.uniqueRows) {
            result.removeDuplicates(session, this.select.iResultLen);
        }
        this.table.insertResult(session, result);
    }

    @Override
    public int compare(Object object, Object object2) {
        SubQuery subQuery = (SubQuery)object;
        SubQuery subQuery2 = (SubQuery)object2;
        if (subQuery.view == null && subQuery2.view == null) {
            return subQuery2.level - subQuery.level;
        }
        if (subQuery.view != null && subQuery2.view != null) {
            int n;
            Database database = subQuery.view.database;
            int n2 = database.schemaManager.getTableIndex(subQuery.view);
            int n3 = database.schemaManager.getTableIndex(subQuery2.view);
            if (n2 == -1) {
                n2 = database.schemaManager.getTables(subQuery.view.getSchemaName()).size();
            }
            if (n3 == -1) {
                n3 = database.schemaManager.getTables(subQuery2.view.getSchemaName()).size();
            }
            return (n = n2 - n3) == 0 ? subQuery2.level - subQuery.level : n;
        }
        return subQuery.view == null ? 1 : -1;
    }
}

