/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.core.Response;
import org.jboss.resteasy.reactive.NoCache;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.representations.idm.TestLdapConnectionRepresentation;
import org.keycloak.services.ErrorResponse;
import org.keycloak.services.managers.LDAPServerCapabilitiesManager;
import org.keycloak.services.resources.admin.fgap.AdminPermissionEvaluator;

public class TestLdapConnectionResource {
    protected final RealmModel realm;
    protected final AdminPermissionEvaluator auth;
    protected final KeycloakSession session;

    public TestLdapConnectionResource(KeycloakSession session, AdminPermissionEvaluator auth) {
        this.session = session;
        this.auth = auth;
        this.realm = session.getContext().getRealm();
    }

    @POST
    @NoCache
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Deprecated
    public Response testLDAPConnection(@FormParam(value="action") String action, @FormParam(value="connectionUrl") String connectionUrl, @FormParam(value="bindDn") String bindDn, @FormParam(value="bindCredential") String bindCredential, @FormParam(value="useTruststoreSpi") String useTruststoreSpi, @FormParam(value="connectionTimeout") String connectionTimeout, @FormParam(value="componentId") String componentId, @FormParam(value="startTls") String startTls) {
        this.auth.realm().requireManageRealm();
        TestLdapConnectionRepresentation config = new TestLdapConnectionRepresentation(action, connectionUrl, bindDn, bindCredential, useTruststoreSpi, connectionTimeout, startTls, "simple");
        config.setComponentId(componentId);
        try {
            LDAPServerCapabilitiesManager.testLDAP(config, this.session, this.realm);
            return Response.noContent().build();
        }
        catch (Exception e) {
            String errorMsg = LDAPServerCapabilitiesManager.getErrorCode(e);
            throw ErrorResponse.error((String)errorMsg, (Response.Status)Response.Status.BAD_REQUEST);
        }
    }

    @POST
    @NoCache
    @Consumes(value={"application/json"})
    public Response testLDAPConnection(TestLdapConnectionRepresentation config) {
        this.auth.realm().requireManageRealm();
        try {
            LDAPServerCapabilitiesManager.testLDAP(config, this.session, this.realm);
            return Response.noContent().build();
        }
        catch (Exception e) {
            String errorMsg = LDAPServerCapabilitiesManager.getErrorCode(e);
            throw ErrorResponse.error((String)errorMsg, (Response.Status)Response.Status.BAD_REQUEST);
        }
    }
}

