/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data.attestation.statement;

import com.webauthn4j.data.attestation.statement.TPMAObject;
import com.webauthn4j.data.attestation.statement.TPMIAlgHash;
import com.webauthn4j.data.attestation.statement.TPMIAlgPublic;
import com.webauthn4j.data.attestation.statement.TPMUPublicId;
import com.webauthn4j.data.attestation.statement.TPMUPublicParms;
import com.webauthn4j.data.attestation.statement.TPMUtil;
import com.webauthn4j.util.ArrayUtil;
import com.webauthn4j.util.UnsignedNumberUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TPMTPublic {
    private final TPMIAlgPublic type;
    private final TPMIAlgHash nameAlg;
    private final TPMAObject objectAttributes;
    private final byte[] authPolicy;
    private final TPMUPublicParms parameters;
    private final TPMUPublicId unique;

    public TPMTPublic(@NotNull TPMIAlgPublic type, @NotNull TPMIAlgHash nameAlg, @NotNull TPMAObject objectAttributes, @NotNull byte[] authPolicy, @NotNull TPMUPublicParms parameters, @NotNull TPMUPublicId unique) {
        this.type = type;
        this.nameAlg = nameAlg;
        this.objectAttributes = objectAttributes;
        this.authPolicy = authPolicy;
        this.parameters = parameters;
        this.unique = unique;
    }

    @NotNull
    public TPMIAlgPublic getType() {
        return this.type;
    }

    @NotNull
    public TPMIAlgHash getNameAlg() {
        return this.nameAlg;
    }

    @NotNull
    public TPMAObject getObjectAttributes() {
        return this.objectAttributes;
    }

    @NotNull
    public byte[] getAuthPolicy() {
        return ArrayUtil.clone(this.authPolicy);
    }

    @NotNull
    public TPMUPublicParms getParameters() {
        return this.parameters;
    }

    @NotNull
    public TPMUPublicId getUnique() {
        return this.unique;
    }

    @NotNull
    public byte[] getBytes() {
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            int typeValue = this.type.getValue();
            stream.write(UnsignedNumberUtil.toBytes(typeValue));
            int nameAlgValue = this.getNameAlg().getValue();
            stream.write(UnsignedNumberUtil.toBytes(nameAlgValue));
            stream.write(this.getObjectAttributes().getBytes());
            TPMUtil.writeSizedArray(stream, this.getAuthPolicy());
            stream.write(this.getParameters().getBytes());
            stream.write(this.getUnique().getBytes());
            return stream.toByteArray();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TPMTPublic that = (TPMTPublic)o;
        return this.type == that.type && this.nameAlg == that.nameAlg && Objects.equals(this.objectAttributes, that.objectAttributes) && Arrays.equals(this.authPolicy, that.authPolicy) && Objects.equals(this.parameters, that.parameters) && Objects.equals(this.unique, that.unique);
    }

    public int hashCode() {
        int result = Objects.hash(new Object[]{this.type, this.nameAlg, this.objectAttributes, this.parameters, this.unique});
        result = 31 * result + Arrays.hashCode(this.authPolicy);
        return result;
    }
}

