/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.lock.internal;

import jakarta.persistence.Timeout;
import java.sql.Connection;
import org.hibernate.HibernateException;
import org.hibernate.Timeouts;
import org.hibernate.dialect.RowLockStrategy;
import org.hibernate.dialect.lock.internal.Helper;
import org.hibernate.dialect.lock.spi.ConnectionLockTimeoutStrategy;
import org.hibernate.dialect.lock.spi.LockTimeoutType;
import org.hibernate.dialect.lock.spi.LockingSupport;
import org.hibernate.dialect.lock.spi.OuterJoinLockingType;
import org.hibernate.engine.spi.SessionFactoryImplementor;

public class PostgreSQLLockingSupport
implements LockingSupport,
LockingSupport.Metadata,
ConnectionLockTimeoutStrategy {
    public static final LockingSupport LOCKING_SUPPORT = new PostgreSQLLockingSupport();
    private final boolean supportsNoWait;
    private final boolean supportsSkipLocked;

    public PostgreSQLLockingSupport() {
        this(true, true);
    }

    public PostgreSQLLockingSupport(boolean supportsNoWait, boolean supportsSkipLocked) {
        this.supportsNoWait = supportsNoWait;
        this.supportsSkipLocked = supportsSkipLocked;
    }

    @Override
    public LockingSupport.Metadata getMetadata() {
        return this;
    }

    @Override
    public RowLockStrategy getWriteRowLockStrategy() {
        return RowLockStrategy.TABLE;
    }

    @Override
    public LockTimeoutType getLockTimeoutType(Timeout timeout) {
        return switch (timeout.milliseconds()) {
            case 0 -> {
                if (this.supportsNoWait) {
                    yield LockTimeoutType.QUERY;
                }
                yield LockTimeoutType.NONE;
            }
            case -2 -> {
                if (this.supportsSkipLocked) {
                    yield LockTimeoutType.QUERY;
                }
                yield LockTimeoutType.NONE;
            }
            case -1 -> LockTimeoutType.NONE;
            default -> LockTimeoutType.CONNECTION;
        };
    }

    @Override
    public OuterJoinLockingType getOuterJoinLockingType() {
        return OuterJoinLockingType.UNSUPPORTED;
    }

    @Override
    public ConnectionLockTimeoutStrategy getConnectionLockTimeoutStrategy() {
        return this;
    }

    @Override
    public ConnectionLockTimeoutStrategy.Level getSupportedLevel() {
        return ConnectionLockTimeoutStrategy.Level.SUPPORTED;
    }

    @Override
    public Timeout getLockTimeout(Connection connection, SessionFactoryImplementor factory) {
        return Helper.getLockTimeout("select current_setting('lock_timeout', true)", resultSet -> {
            String value = resultSet.getString(1);
            if ("0".equals(value)) {
                return Timeouts.WAIT_FOREVER;
            }
            assert (value.endsWith("s"));
            int secondsValue = Integer.parseInt(value.substring(0, value.length() - 1));
            return Timeout.seconds((int)secondsValue);
        }, connection, factory);
    }

    @Override
    public void setLockTimeout(Timeout timeout, Connection connection, SessionFactoryImplementor factory) {
        Helper.setLockTimeout(timeout, t -> {
            int milliseconds = timeout.milliseconds();
            if (milliseconds == -2) {
                throw new HibernateException("Connection lock-timeout does not accept skip-locked");
            }
            if (milliseconds == 0) {
                throw new HibernateException("Connection lock-timeout does not accept no-wait");
            }
            return milliseconds == -1 ? 0 : milliseconds;
        }, "set local lock_timeout = %s", connection, factory);
    }
}

