/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.aggregate;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.aggregate.AggregateSupport;
import org.hibernate.dialect.aggregate.AggregateSupportImpl;
import org.hibernate.dialect.function.json.HANAJsonValueFunction;
import org.hibernate.dialect.function.xml.HANAXmlTableFunction;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.AggregateColumn;
import org.hibernate.mapping.Column;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.mapping.SelectablePath;
import org.hibernate.metamodel.mapping.SqlTypedMapping;
import org.hibernate.sql.ast.SqlAstNodeRenderingMode;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.type.SqlTypes;
import org.hibernate.type.descriptor.jdbc.AggregateJdbcType;
import org.hibernate.type.spi.TypeConfiguration;

public class HANAAggregateSupport
extends AggregateSupportImpl {
    private static final AggregateSupport INSTANCE = new HANAAggregateSupport();
    private static final String JSON_QUERY_START = "json_query(";
    private static final String JSON_QUERY_END = "' error on error)";
    private static final String XML_EXTRACT_START = "xmlextract(";
    private static final String XML_EXTRACT_END = "')";
    private static final String XML_EXTRACT_READ_START = "case when ";
    private static final String XML_EXTRACT_READ_NULL_CHECK = " is null then null else ";
    private static final String XML_EXTRACT_READ_INVOCATION_START = "'<e>'||xmlextract(";
    private static final String XML_EXTRACT_READ_END = "/*')||'</e>' end";

    private HANAAggregateSupport() {
    }

    public static AggregateSupport valueOf(Dialect dialect) {
        return dialect.getVersion().isSameOrAfter(2, 0, 40) ? INSTANCE : AggregateSupportImpl.INSTANCE;
    }

    @Override
    public String aggregateComponentCustomReadExpression(String template, String placeholder, String aggregateParentReadExpression, String columnExpression, int aggregateColumnTypeCode, SqlTypedMapping column, TypeConfiguration typeConfiguration) {
        switch (aggregateColumnTypeCode) {
            case 3001: 
            case 3018: {
                String jsonParentPartExpression = HANAAggregateSupport.determineJsonParentPartExpression(aggregateParentReadExpression);
                switch (column.getJdbcMapping().getJdbcType().getDefaultSqlTypeCode()) {
                    case 16: {
                        if (SqlTypes.isNumericType(column.getJdbcMapping().getJdbcType().getDdlTypeCode())) {
                            return template.replace(placeholder, "case json_value(" + jsonParentPartExpression + columnExpression + "') when 'true' then 1 when 'false' then 0 end");
                        }
                        return template.replace(placeholder, "case json_value(" + jsonParentPartExpression + columnExpression + "') when 'true' then true when 'false' then false end");
                    }
                    case 91: 
                    case 92: 
                    case 93: 
                    case 3003: {
                        return template.replace(placeholder, "cast(json_value(" + jsonParentPartExpression + columnExpression + "') as " + column.getColumnDefinition() + ")");
                    }
                    case -3: 
                    case -2: 
                    case 2004: 
                    case 4003: {
                        return template.replace(placeholder, "hextobin(json_value(" + jsonParentPartExpression + columnExpression + "' error on error))");
                    }
                    case 3001: 
                    case 3018: {
                        return template.replace(placeholder, JSON_QUERY_START + jsonParentPartExpression + columnExpression + JSON_QUERY_END);
                    }
                    case 3000: {
                        if (!SqlTypes.isBinaryType(column.getJdbcMapping().getJdbcType().getDdlTypeCode())) break;
                        return template.replace(placeholder, "hextobin(replace(json_value(" + jsonParentPartExpression + columnExpression + "'),'-',''))");
                    }
                }
                return template.replace(placeholder, "json_value(" + jsonParentPartExpression + columnExpression + "' returning " + HANAJsonValueFunction.jsonValueReturningType(column) + " error on error)");
            }
            case 2009: 
            case 3019: {
                String xmlParentPartExpression;
                Object caseExpression;
                int patternIdx;
                if (aggregateParentReadExpression.startsWith(XML_EXTRACT_READ_START) && aggregateParentReadExpression.endsWith(XML_EXTRACT_READ_END) && (patternIdx = aggregateParentReadExpression.indexOf(XML_EXTRACT_READ_NULL_CHECK)) != -1 && aggregateParentReadExpression.regionMatches(patternIdx + XML_EXTRACT_READ_NULL_CHECK.length(), XML_EXTRACT_READ_INVOCATION_START, 0, XML_EXTRACT_READ_INVOCATION_START.length())) {
                    caseExpression = aggregateParentReadExpression.substring(0, patternIdx + XML_EXTRACT_READ_NULL_CHECK.length());
                    xmlParentPartExpression = aggregateParentReadExpression.substring(patternIdx + XML_EXTRACT_READ_NULL_CHECK.length() + XML_EXTRACT_READ_INVOCATION_START.length(), aggregateParentReadExpression.length() - XML_EXTRACT_READ_END.length()) + "/";
                } else {
                    caseExpression = XML_EXTRACT_READ_START + aggregateParentReadExpression + XML_EXTRACT_READ_NULL_CHECK;
                    xmlParentPartExpression = aggregateParentReadExpression + ",'/e/";
                }
                switch (column.getJdbcMapping().getJdbcType().getDefaultSqlTypeCode()) {
                    case -3: 
                    case -2: 
                    case 2004: 
                    case 4003: {
                        return template.replace(placeholder, (String)caseExpression + "hextobin(xmlextractvalue(" + xmlParentPartExpression + columnExpression + "')) end");
                    }
                    case 91: 
                    case 92: 
                    case 93: 
                    case 3003: {
                        return template.replace(placeholder, (String)caseExpression + "cast(cast(xmlextractvalue(" + xmlParentPartExpression + columnExpression + "') as varchar(36)) as " + HANAXmlTableFunction.xmlValueReturningType(column, column.getColumnDefinition()) + ") end");
                    }
                    case 2009: {
                        return template.replace(placeholder, (String)caseExpression + XML_EXTRACT_READ_INVOCATION_START + xmlParentPartExpression + columnExpression + XML_EXTRACT_READ_END);
                    }
                    case 3019: {
                        if (typeConfiguration.getCurrentBaseSqlTypeIndicators().isXmlFormatMapperLegacyFormatEnabled()) {
                            throw new IllegalArgumentException("XML array '" + columnExpression + "' in '" + aggregateParentReadExpression + "' is not supported with legacy format enabled.");
                        }
                        return template.replace(placeholder, (String)caseExpression + "'<Collection>'||xmlextract(" + xmlParentPartExpression + columnExpression + "/*')||'</Collection>' end");
                    }
                    case 3000: {
                        if (!SqlTypes.isBinaryType(column.getJdbcMapping().getJdbcType().getDdlTypeCode())) break;
                        return template.replace(placeholder, (String)caseExpression + "hextobin(replace(xmlextractvalue(" + xmlParentPartExpression + columnExpression + "'),'-','')) end");
                    }
                }
                return template.replace(placeholder, (String)caseExpression + "cast(xmlextractvalue(" + xmlParentPartExpression + columnExpression + "') as " + HANAXmlTableFunction.xmlValueReturningType(column, column.getColumnDefinition()) + ") end");
            }
        }
        throw new IllegalArgumentException("Unsupported aggregate SQL type: " + aggregateColumnTypeCode);
    }

    private static String determineJsonParentPartExpression(String aggregateParentReadExpression) {
        String parentPartExpression = aggregateParentReadExpression.startsWith(JSON_QUERY_START) && aggregateParentReadExpression.endsWith(JSON_QUERY_END) ? aggregateParentReadExpression.substring(JSON_QUERY_START.length(), aggregateParentReadExpression.length() - JSON_QUERY_END.length()) + "." : aggregateParentReadExpression + ",'$.";
        return parentPartExpression;
    }

    private static String determineXmlParentPartExpression(String aggregateParentReadExpression) {
        String parentPartExpression = aggregateParentReadExpression.startsWith(XML_EXTRACT_START) && aggregateParentReadExpression.endsWith(XML_EXTRACT_END) ? aggregateParentReadExpression.substring(XML_EXTRACT_START.length(), aggregateParentReadExpression.length() - XML_EXTRACT_END.length()) + "/" : aggregateParentReadExpression + ",'/e/";
        return parentPartExpression;
    }

    private static String customWriteExpression(String customWriteExpression, JdbcMapping jdbcMapping) {
        int sqlTypeCode = jdbcMapping.getJdbcType().getDefaultSqlTypeCode();
        switch (sqlTypeCode) {
            case 3000: {
                return "replace_regexpr('^(.{8})(.{4})(.{4})(.{4})(.{12})$' in lower(bintohex(" + customWriteExpression + ")) with '\\1-\\2-\\3-\\4-\\5')";
            }
            case -3: 
            case -2: 
            case 2004: 
            case 4003: {
                return "bintohex(" + customWriteExpression + ")";
            }
            case 93: {
                return "to_varchar(" + customWriteExpression + ",'YYYY-MM-DD\"T\"HH24:MI:SS.FF9')";
            }
            case 3003: {
                return "to_varchar(" + customWriteExpression + ",'YYYY-MM-DD\"T\"HH24:MI:SS.FF9\"Z\"')";
            }
        }
        return customWriteExpression;
    }

    @Override
    public String aggregateComponentAssignmentExpression(String aggregateParentAssignmentExpression, String columnExpression, int aggregateColumnTypeCode, Column column) {
        switch (aggregateColumnTypeCode) {
            case 2009: 
            case 3001: 
            case 3018: 
            case 3019: {
                return aggregateParentAssignmentExpression;
            }
        }
        throw new IllegalArgumentException("Unsupported aggregate SQL type: " + aggregateColumnTypeCode);
    }

    @Override
    public String aggregateCustomWriteExpression(AggregateColumn aggregateColumn, List<Column> aggregatedColumns) {
        int sqlTypeCode = aggregateColumn.getType().getJdbcType().getDefaultSqlTypeCode();
        switch (sqlTypeCode == 2003 ? aggregateColumn.getTypeCode() : sqlTypeCode) {
            case 2009: 
            case 3001: 
            case 3018: 
            case 3019: {
                return null;
            }
        }
        throw new IllegalArgumentException("Unsupported aggregate SQL type: " + aggregateColumn.getTypeCode());
    }

    @Override
    public boolean requiresAggregateCustomWriteExpressionRenderer(int aggregateSqlTypeCode) {
        return aggregateSqlTypeCode == 3001 || aggregateSqlTypeCode == 2009;
    }

    @Override
    public AggregateSupport.WriteExpressionRenderer aggregateCustomWriteExpressionRenderer(SelectableMapping aggregateColumn, SelectableMapping[] columnsToUpdate, TypeConfiguration typeConfiguration) {
        int aggregateSqlTypeCode = aggregateColumn.getJdbcMapping().getJdbcType().getDefaultSqlTypeCode();
        switch (aggregateSqlTypeCode) {
            case 3001: {
                return new RootJsonWriteExpression(aggregateColumn, columnsToUpdate);
            }
            case 2009: {
                return new RootXmlWriteExpression(aggregateColumn, columnsToUpdate);
            }
        }
        throw new IllegalArgumentException("Unsupported aggregate SQL type: " + aggregateSqlTypeCode);
    }

    private static class RootJsonWriteExpression
    extends AggregateJsonWriteExpression
    implements AggregateSupport.WriteExpressionRenderer {
        private final String path;

        RootJsonWriteExpression(SelectableMapping aggregateColumn, SelectableMapping[] columns) {
            super(aggregateColumn, aggregateColumn.getColumnDefinition());
            this.path = aggregateColumn.getSelectionExpression();
            this.initializeSubExpressions(aggregateColumn, columns);
        }

        @Override
        public void render(SqlAppender sqlAppender, SqlAstTranslator<?> translator, AggregateSupport.AggregateColumnWriteExpression aggregateColumnWriteExpression, String qualifier) {
            Object basePath = qualifier == null || qualifier.isBlank() ? this.path : qualifier + "." + this.path;
            this.append(sqlAppender, (String)basePath, translator, aggregateColumnWriteExpression);
        }
    }

    private static class RootXmlWriteExpression
    extends AggregateXmlWriteExpression
    implements AggregateSupport.WriteExpressionRenderer {
        private final String path;

        RootXmlWriteExpression(SelectableMapping aggregateColumn, SelectableMapping[] columns) {
            super(aggregateColumn, aggregateColumn.getColumnDefinition());
            this.path = aggregateColumn.getSelectionExpression();
            this.initializeSubExpressions(aggregateColumn, columns);
        }

        @Override
        protected String getTagName() {
            return "e";
        }

        @Override
        public void render(SqlAppender sqlAppender, SqlAstTranslator<?> translator, AggregateSupport.AggregateColumnWriteExpression aggregateColumnWriteExpression, String qualifier) {
            Object basePath = qualifier == null || qualifier.isBlank() ? this.path : qualifier + "." + this.path;
            this.append(sqlAppender, (String)basePath, translator, aggregateColumnWriteExpression);
        }
    }

    private static class PassThroughXmlWriteExpression
    implements XmlWriteExpression {
        private final SelectableMapping selectableMapping;

        PassThroughXmlWriteExpression(SelectableMapping selectableMapping) {
            this.selectableMapping = selectableMapping;
        }

        @Override
        public boolean isAggregate() {
            return this.selectableMapping.getJdbcMapping().getJdbcType().isXml();
        }

        @Override
        public void append(SqlAppender sb, String path, SqlAstTranslator<?> translator, AggregateSupport.AggregateColumnWriteExpression expression) {
            String parentPartExpression = HANAAggregateSupport.determineXmlParentPartExpression(path);
            switch (this.selectableMapping.getJdbcMapping().getJdbcType().getDefaultSqlTypeCode()) {
                case 2009: 
                case 3019: {
                    sb.append(HANAAggregateSupport.XML_EXTRACT_START);
                    sb.append(parentPartExpression);
                    sb.append(this.selectableMapping.getSelectableName());
                    sb.append(HANAAggregateSupport.XML_EXTRACT_END);
                    break;
                }
                default: {
                    sb.append("xmlextractvalue(");
                    sb.append(parentPartExpression);
                    sb.append(this.selectableMapping.getSelectableName());
                    sb.append(HANAAggregateSupport.XML_EXTRACT_END);
                }
            }
        }
    }

    private static class BasicXmlWriteExpression
    implements XmlWriteExpression {
        private final SelectableMapping selectableMapping;
        private final String customWriteExpressionStart;
        private final String customWriteExpressionEnd;

        BasicXmlWriteExpression(SelectableMapping selectableMapping, String customWriteExpression) {
            this.selectableMapping = selectableMapping;
            if (customWriteExpression.equals("?")) {
                this.customWriteExpressionStart = "";
                this.customWriteExpressionEnd = "";
            } else {
                String[] parts = StringHelper.split("?", customWriteExpression);
                assert (parts.length == 2);
                this.customWriteExpressionStart = parts[0];
                this.customWriteExpressionEnd = parts[1];
            }
        }

        @Override
        public boolean isAggregate() {
            return this.selectableMapping.getJdbcMapping().getJdbcType().isXml();
        }

        @Override
        public void append(SqlAppender sb, String path, SqlAstTranslator<?> translator, AggregateSupport.AggregateColumnWriteExpression expression) {
            boolean isArray;
            boolean bl = isArray = this.selectableMapping.getJdbcMapping().getJdbcType().getDefaultSqlTypeCode() == 3019;
            if (this.isAggregate()) {
                sb.append("coalesce(");
            }
            if (isArray) {
                sb.append("'<");
                sb.append(this.selectableMapping.getSelectableName());
                sb.append(">'||case when ");
                sb.append(this.customWriteExpressionStart);
                translator.render(expression.getValueExpression(this.selectableMapping), SqlAstNodeRenderingMode.NO_UNTYPED);
                sb.append(this.customWriteExpressionEnd);
                sb.append(" is null then null else xmlextract(");
            }
            sb.append(this.customWriteExpressionStart);
            translator.render(expression.getValueExpression(this.selectableMapping), SqlAstNodeRenderingMode.NO_UNTYPED);
            sb.append(this.customWriteExpressionEnd);
            if (isArray) {
                sb.append(",'/*/node()') end||'</");
                sb.append(this.selectableMapping.getSelectableName());
                sb.append(">'");
            }
            if (this.isAggregate()) {
                sb.append(",'<");
                sb.append(this.selectableMapping.getSelectableName());
                if (this.selectableMapping.getJdbcMapping().getJdbcType() instanceof AggregateJdbcType) {
                    sb.append(">");
                    this.appendNullTags(sb, this.selectableMapping);
                    sb.append("</");
                    sb.append(this.selectableMapping.getSelectableName());
                    sb.append(">')");
                } else {
                    sb.append("/>')");
                }
            }
        }

        private void appendNullTags(SqlAppender sb, SelectableMapping parentMapping) {
            AggregateJdbcType jdbcType = (AggregateJdbcType)parentMapping.getJdbcMapping().getJdbcType();
            EmbeddableMappingType embeddableMappingType = jdbcType.getEmbeddableMappingType();
            int jdbcValueCount = embeddableMappingType.getJdbcValueCount();
            for (int i = 0; i < jdbcValueCount; ++i) {
                SelectableMapping selectable = embeddableMappingType.getJdbcValueSelectable(i);
                sb.append("<");
                if (selectable.getJdbcMapping().getJdbcType() instanceof AggregateJdbcType) {
                    sb.append(selectable.getSelectableName());
                    sb.append(">");
                    this.appendNullTags(sb, selectable);
                    sb.append("</");
                    sb.append(selectable.getSelectableName());
                    sb.append(">");
                    continue;
                }
                sb.append(selectable.getSelectableName());
                sb.append("/>");
            }
        }
    }

    private static class AggregateXmlWriteExpression
    implements XmlWriteExpression {
        private final SelectableMapping selectableMapping;
        private final String columnDefinition;
        private final LinkedHashMap<String, XmlWriteExpression> subExpressions = new LinkedHashMap();

        private AggregateXmlWriteExpression(SelectableMapping selectableMapping, String columnDefinition) {
            this.selectableMapping = selectableMapping;
            this.columnDefinition = columnDefinition;
        }

        @Override
        public boolean isAggregate() {
            return true;
        }

        protected void initializeSubExpressions(SelectableMapping aggregateColumn, SelectableMapping[] columns) {
            for (SelectableMapping column : columns) {
                SelectablePath selectablePath = column.getSelectablePath();
                SelectablePath[] parts = selectablePath.getParts();
                AggregateXmlWriteExpression currentAggregate = this;
                for (int i = 1; i < parts.length - 1; ++i) {
                    AggregateJdbcType aggregateJdbcType = (AggregateJdbcType)currentAggregate.selectableMapping.getJdbcMapping().getJdbcType();
                    EmbeddableMappingType embeddableMappingType = aggregateJdbcType.getEmbeddableMappingType();
                    int selectableIndex = embeddableMappingType.getSelectableIndex(parts[i].getSelectableName());
                    currentAggregate = (AggregateXmlWriteExpression)currentAggregate.subExpressions.computeIfAbsent(parts[i].getSelectableName(), k -> new AggregateXmlWriteExpression(embeddableMappingType.getJdbcValueSelectable(selectableIndex), this.columnDefinition));
                }
                String customWriteExpression = column.getWriteExpression();
                currentAggregate.subExpressions.put(parts[parts.length - 1].getSelectableName(), new BasicXmlWriteExpression(column, HANAAggregateSupport.customWriteExpression(customWriteExpression, column.getJdbcMapping())));
            }
            this.passThroughUnsetSubExpressions(aggregateColumn);
        }

        protected void passThroughUnsetSubExpressions(SelectableMapping aggregateColumn) {
            AggregateJdbcType aggregateJdbcType = (AggregateJdbcType)aggregateColumn.getJdbcMapping().getJdbcType();
            EmbeddableMappingType embeddableMappingType = aggregateJdbcType.getEmbeddableMappingType();
            int jdbcValueCount = embeddableMappingType.getJdbcValueCount();
            for (int i = 0; i < jdbcValueCount; ++i) {
                SelectableMapping selectableMapping = embeddableMappingType.getJdbcValueSelectable(i);
                XmlWriteExpression xmlWriteExpression = this.subExpressions.get(selectableMapping.getSelectableName());
                if (xmlWriteExpression == null) {
                    this.subExpressions.put(selectableMapping.getSelectableName(), new PassThroughXmlWriteExpression(selectableMapping));
                    continue;
                }
                if (!(xmlWriteExpression instanceof AggregateXmlWriteExpression)) continue;
                AggregateXmlWriteExpression writeExpression = (AggregateXmlWriteExpression)xmlWriteExpression;
                writeExpression.passThroughUnsetSubExpressions(selectableMapping);
            }
        }

        protected String getTagName() {
            return this.selectableMapping.getSelectableName();
        }

        @Override
        public void append(SqlAppender sb, String path, SqlAstTranslator<?> translator, AggregateSupport.AggregateColumnWriteExpression expression) {
            XmlWriteExpression value;
            String column;
            int aggregateCount = this.determineAggregateCount();
            if (aggregateCount != 0) {
                sb.append("(replace_regexpr('^(.*)</");
                sb.append(this.getTagName());
                sb.append(">$' flag 's' in ");
            }
            sb.append("(select");
            if (aggregateCount != this.subExpressions.size()) {
                int separator = 32;
                for (Map.Entry<String, XmlWriteExpression> entry : this.subExpressions.entrySet()) {
                    column = entry.getKey();
                    value = entry.getValue();
                    if (value.isAggregate()) continue;
                    sb.append((char)separator);
                    value.append(sb, path, translator, expression);
                    sb.append(' ');
                    sb.appendDoubleQuoteEscapedString(column);
                    separator = 44;
                }
                sb.append(" from sys.dummy for xml('root'='no','rowname'='");
                sb.append(this.getTagName());
                sb.append("','format'='no','nullstyle'='attribute') returns ");
                sb.append(this.columnDefinition);
            } else {
                sb.append(" cast('<");
                sb.append(this.getTagName());
                sb.append("></");
                sb.append(this.getTagName());
                sb.append(">' as ");
                sb.append(this.columnDefinition);
                sb.append(") xmlresult from sys.dummy");
            }
            sb.append(')');
            if (aggregateCount != 0) {
                sb.append(" with '\\1')");
                String parentPartExpression = HANAAggregateSupport.determineXmlParentPartExpression(path);
                for (Map.Entry<String, XmlWriteExpression> entry : this.subExpressions.entrySet()) {
                    column = entry.getKey();
                    value = entry.getValue();
                    if (!value.isAggregate()) continue;
                    sb.append("||case when ");
                    sb.append(path);
                    sb.append(HANAAggregateSupport.XML_EXTRACT_READ_NULL_CHECK);
                    if (value instanceof AggregateXmlWriteExpression) {
                        String subPath = HANAAggregateSupport.XML_EXTRACT_START + parentPartExpression + column + HANAAggregateSupport.XML_EXTRACT_END;
                        value.append(sb, subPath, translator, expression);
                    } else {
                        value.append(sb, path, translator, expression);
                    }
                    sb.append(" end");
                }
                sb.append("||'</");
                sb.append(this.getTagName());
                sb.append(">')");
            }
        }

        private int determineAggregateCount() {
            int count = 0;
            for (Map.Entry<String, XmlWriteExpression> entry : this.subExpressions.entrySet()) {
                if (!entry.getValue().isAggregate()) continue;
                ++count;
            }
            return count;
        }
    }

    static interface XmlWriteExpression {
        public boolean isAggregate();

        public void append(SqlAppender var1, String var2, SqlAstTranslator<?> var3, AggregateSupport.AggregateColumnWriteExpression var4);
    }

    private static class PassThroughJsonWriteExpression
    implements JsonWriteExpression {
        private final SelectableMapping selectableMapping;

        PassThroughJsonWriteExpression(SelectableMapping selectableMapping) {
            this.selectableMapping = selectableMapping;
        }

        @Override
        public boolean isAggregate() {
            return this.selectableMapping.getJdbcMapping().getJdbcType().isJson();
        }

        @Override
        public void append(SqlAppender sb, String path, SqlAstTranslator<?> translator, AggregateSupport.AggregateColumnWriteExpression expression) {
            String parentPartExpression = HANAAggregateSupport.determineJsonParentPartExpression(path);
            switch (this.selectableMapping.getJdbcMapping().getJdbcType().getDefaultSqlTypeCode()) {
                case 16: {
                    sb.append("case json_value(");
                    sb.append(parentPartExpression);
                    sb.append(this.selectableMapping.getSelectableName());
                    if (SqlTypes.isNumericType(this.selectableMapping.getJdbcMapping().getJdbcType().getDdlTypeCode())) {
                        sb.append("') when 'true' then 1 when 'false' then 0 end");
                        break;
                    }
                    sb.append("') when 'true' then true when 'false' then false end");
                    break;
                }
                case -6: 
                case -5: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    sb.append("json_value(");
                    sb.append(parentPartExpression);
                    sb.append(this.selectableMapping.getSelectableName());
                    sb.append("' returning ");
                    sb.append(HANAJsonValueFunction.jsonValueReturningType(this.selectableMapping));
                    sb.append(" error on error)");
                    break;
                }
                case 3001: 
                case 3018: {
                    sb.append(HANAAggregateSupport.JSON_QUERY_START);
                    sb.append(parentPartExpression);
                    sb.append(this.selectableMapping.getSelectableName());
                    sb.append(HANAAggregateSupport.JSON_QUERY_END);
                    break;
                }
                default: {
                    sb.append("json_value(");
                    sb.append(parentPartExpression);
                    sb.append(this.selectableMapping.getSelectableName());
                    sb.append(HANAAggregateSupport.JSON_QUERY_END);
                }
            }
        }
    }

    private static class BasicJsonWriteExpression
    implements JsonWriteExpression {
        private final SelectableMapping selectableMapping;
        private final String customWriteExpressionStart;
        private final String customWriteExpressionEnd;

        BasicJsonWriteExpression(SelectableMapping selectableMapping, String customWriteExpression) {
            this.selectableMapping = selectableMapping;
            if (customWriteExpression.equals("?")) {
                this.customWriteExpressionStart = "";
                this.customWriteExpressionEnd = "";
            } else {
                String[] parts = StringHelper.split("?", customWriteExpression);
                assert (parts.length == 2);
                this.customWriteExpressionStart = parts[0];
                this.customWriteExpressionEnd = parts[1];
            }
        }

        @Override
        public boolean isAggregate() {
            return this.selectableMapping.getJdbcMapping().getJdbcType().isJson();
        }

        @Override
        public void append(SqlAppender sb, String path, SqlAstTranslator<?> translator, AggregateSupport.AggregateColumnWriteExpression expression) {
            sb.append(this.customWriteExpressionStart);
            translator.render(expression.getValueExpression(this.selectableMapping), SqlAstNodeRenderingMode.NO_UNTYPED);
            sb.append(this.customWriteExpressionEnd);
        }
    }

    private static class AggregateJsonWriteExpression
    implements JsonWriteExpression {
        private final SelectableMapping selectableMapping;
        private final String columnDefinition;
        private final LinkedHashMap<String, JsonWriteExpression> subExpressions = new LinkedHashMap();

        private AggregateJsonWriteExpression(SelectableMapping selectableMapping, String columnDefinition) {
            this.selectableMapping = selectableMapping;
            this.columnDefinition = columnDefinition;
        }

        @Override
        public boolean isAggregate() {
            return true;
        }

        protected void initializeSubExpressions(SelectableMapping aggregateColumn, SelectableMapping[] columns) {
            for (SelectableMapping column : columns) {
                SelectablePath selectablePath = column.getSelectablePath();
                SelectablePath[] parts = selectablePath.getParts();
                AggregateJsonWriteExpression currentAggregate = this;
                for (int i = 1; i < parts.length - 1; ++i) {
                    AggregateJdbcType aggregateJdbcType = (AggregateJdbcType)currentAggregate.selectableMapping.getJdbcMapping().getJdbcType();
                    EmbeddableMappingType embeddableMappingType = aggregateJdbcType.getEmbeddableMappingType();
                    int selectableIndex = embeddableMappingType.getSelectableIndex(parts[i].getSelectableName());
                    currentAggregate = (AggregateJsonWriteExpression)currentAggregate.subExpressions.computeIfAbsent(parts[i].getSelectableName(), k -> new AggregateJsonWriteExpression(embeddableMappingType.getJdbcValueSelectable(selectableIndex), this.columnDefinition));
                }
                String customWriteExpression = column.getWriteExpression();
                currentAggregate.subExpressions.put(parts[parts.length - 1].getSelectableName(), new BasicJsonWriteExpression(column, HANAAggregateSupport.customWriteExpression(customWriteExpression, column.getJdbcMapping())));
            }
            this.passThroughUnsetSubExpressions(aggregateColumn);
        }

        protected void passThroughUnsetSubExpressions(SelectableMapping aggregateColumn) {
            AggregateJdbcType aggregateJdbcType = (AggregateJdbcType)aggregateColumn.getJdbcMapping().getJdbcType();
            EmbeddableMappingType embeddableMappingType = aggregateJdbcType.getEmbeddableMappingType();
            int jdbcValueCount = embeddableMappingType.getJdbcValueCount();
            for (int i = 0; i < jdbcValueCount; ++i) {
                SelectableMapping selectableMapping = embeddableMappingType.getJdbcValueSelectable(i);
                JsonWriteExpression jsonWriteExpression = this.subExpressions.get(selectableMapping.getSelectableName());
                if (jsonWriteExpression == null) {
                    this.subExpressions.put(selectableMapping.getSelectableName(), new PassThroughJsonWriteExpression(selectableMapping));
                    continue;
                }
                if (!(jsonWriteExpression instanceof AggregateJsonWriteExpression)) continue;
                AggregateJsonWriteExpression writeExpression = (AggregateJsonWriteExpression)jsonWriteExpression;
                writeExpression.passThroughUnsetSubExpressions(selectableMapping);
            }
        }

        @Override
        public void append(SqlAppender sb, String path, SqlAstTranslator<?> translator, AggregateSupport.AggregateColumnWriteExpression expression) {
            int aggregateCount = this.determineAggregateCount();
            if (aggregateCount != 0) {
                sb.append("(trim(trailing '}' from ");
            }
            sb.append("(select");
            if (aggregateCount != this.subExpressions.size()) {
                int separator = 32;
                for (Map.Entry<String, JsonWriteExpression> entry : this.subExpressions.entrySet()) {
                    String column = entry.getKey();
                    JsonWriteExpression value = entry.getValue();
                    if (value.isAggregate()) continue;
                    sb.append((char)separator);
                    value.append(sb, path, translator, expression);
                    sb.append(' ');
                    sb.appendDoubleQuoteEscapedString(column);
                    separator = 44;
                }
                sb.append(" from sys.dummy for json('arraywrap'='no','omitnull'='no')");
                sb.append(" returns ");
                sb.append(this.columnDefinition);
            } else {
                sb.append(" cast('{}' as ");
                sb.append(this.columnDefinition);
                sb.append(") jsonresult from sys.dummy");
            }
            sb.append(')');
            if (aggregateCount != 0) {
                sb.append(')');
                String parentPartExpression = HANAAggregateSupport.determineJsonParentPartExpression(path);
                String separator = aggregateCount == this.subExpressions.size() ? " " : ",";
                for (Map.Entry<String, JsonWriteExpression> entry : this.subExpressions.entrySet()) {
                    String column = entry.getKey();
                    JsonWriteExpression value = entry.getValue();
                    if (!value.isAggregate()) continue;
                    sb.append("||'");
                    sb.append(separator);
                    sb.append('\"');
                    sb.append(column);
                    sb.append("\":'||");
                    if (value instanceof AggregateJsonWriteExpression) {
                        String subPath = HANAAggregateSupport.JSON_QUERY_START + parentPartExpression + column + HANAAggregateSupport.JSON_QUERY_END;
                        value.append(sb, subPath, translator, expression);
                    } else {
                        sb.append("coalesce(");
                        value.append(sb, path, translator, expression);
                        sb.append(",'null')");
                    }
                    separator = ",";
                }
                sb.append("||'}')");
            }
        }

        private int determineAggregateCount() {
            int count = 0;
            for (Map.Entry<String, JsonWriteExpression> entry : this.subExpressions.entrySet()) {
                if (!entry.getValue().isAggregate()) continue;
                ++count;
            }
            return count;
        }
    }

    static interface JsonWriteExpression {
        public boolean isAggregate();

        public void append(SqlAppender var1, String var2, SqlAstTranslator<?> var3, AggregateSupport.AggregateColumnWriteExpression var4);
    }
}

