/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan.entities;

import java.util.Set;
import org.keycloak.models.RealmModel;
import org.keycloak.models.cache.infinispan.entities.AbstractRevisioned;
import org.keycloak.models.cache.infinispan.entities.InClient;
import org.keycloak.models.cache.infinispan.entities.RoleQuery;

public class RoleByNameQuery
extends AbstractRevisioned
implements RoleQuery,
InClient {
    private final String role;
    private final String realm;
    private String client;

    public RoleByNameQuery(Long revisioned, String id, RealmModel realm, String role) {
        super(revisioned, id);
        this.realm = realm.getId();
        this.role = role;
    }

    public RoleByNameQuery(Long revision, String id, RealmModel realm, String role, String client) {
        this(revision, id, realm, role);
        this.client = client;
    }

    @Override
    public Set<String> getRoles() {
        return this.role == null ? Set.of() : Set.of(this.role);
    }

    public String getRole() {
        return this.role;
    }

    @Override
    public String getRealm() {
        return this.realm;
    }

    @Override
    public String getClientId() {
        return this.client;
    }

    public String toString() {
        return "RoleNameQuery{id='" + this.getId() + "', realm='" + this.realm + "', clientUuid='" + this.client + "'}";
    }
}

