/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.results.implicit;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.mapping.ForeignKeyDescriptor;
import org.hibernate.metamodel.mapping.MappingType;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.query.results.Builders;
import org.hibernate.query.results.DomainResultCreationStateImpl;
import org.hibernate.query.results.FetchBuilder;
import org.hibernate.query.results.ResultsHelper;
import org.hibernate.query.results.dynamic.DynamicFetchBuilderLegacy;
import org.hibernate.query.results.implicit.ImplicitFetchBuilder;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.Fetchable;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMetadata;

public class ImplicitFetchBuilderEntity
implements ImplicitFetchBuilder {
    private final NavigablePath fetchPath;
    private final ToOneAttributeMapping fetchable;
    private final Map<NavigablePath, FetchBuilder> fetchBuilders;

    public ImplicitFetchBuilderEntity(NavigablePath fetchPath, ToOneAttributeMapping fetchable, DomainResultCreationState creationState) {
        Map<NavigablePath, FetchBuilder> fetchBuilders;
        NavigablePath associationKeyFetchPath;
        String associationKeyPropertyName;
        this.fetchPath = fetchPath;
        this.fetchable = fetchable;
        DomainResultCreationStateImpl creationStateImpl = ResultsHelper.impl(creationState);
        Map.Entry<String, NavigablePath> relativePath = creationStateImpl.getCurrentRelativePath();
        Function<String, FetchBuilder> fetchBuilderResolver = creationStateImpl.getCurrentExplicitFetchMementoResolver();
        ForeignKeyDescriptor foreignKeyDescriptor = fetchable.getForeignKeyDescriptor();
        if (fetchable.getReferencedPropertyName() == null) {
            associationKeyPropertyName = fetchable.getEntityMappingType().getIdentifierMapping().getPartName();
            associationKeyFetchPath = relativePath.getValue().append(associationKeyPropertyName);
        } else {
            associationKeyPropertyName = fetchable.getReferencedPropertyName();
            NavigablePath path = relativePath.getValue();
            for (String part : associationKeyPropertyName.split("\\.")) {
                path = path.append(part);
            }
            associationKeyFetchPath = path;
        }
        FetchBuilder explicitAssociationKeyFetchBuilder = fetchBuilderResolver.apply(relativePath.getKey() + "." + associationKeyPropertyName);
        if (explicitAssociationKeyFetchBuilder == null) {
            MappingType partMappingType = foreignKeyDescriptor.getPartMappingType();
            if (partMappingType instanceof EmbeddableMappingType) {
                EmbeddableMappingType embeddableValuedModelPart = (EmbeddableMappingType)partMappingType;
                int size = embeddableValuedModelPart.getNumberOfFetchables();
                fetchBuilders = CollectionHelper.linkedMapOfSize(size);
                for (int i = 0; i < size; ++i) {
                    Fetchable subFetchable = embeddableValuedModelPart.getFetchable(i);
                    NavigablePath subFetchPath = associationKeyFetchPath.append(subFetchable.getFetchableName());
                    FetchBuilder explicitFetchBuilder = fetchBuilderResolver.apply(subFetchPath.getFullPath());
                    if (explicitFetchBuilder == null) {
                        fetchBuilders.put(subFetchPath, Builders.implicitFetchBuilder(fetchPath, subFetchable, creationStateImpl));
                        continue;
                    }
                    fetchBuilders.put(subFetchPath, explicitFetchBuilder);
                }
            } else {
                fetchBuilders = Collections.emptyMap();
            }
        } else {
            fetchBuilders = Collections.singletonMap(associationKeyFetchPath, explicitAssociationKeyFetchBuilder);
        }
        this.fetchBuilders = fetchBuilders;
    }

    private ImplicitFetchBuilderEntity(ImplicitFetchBuilderEntity original) {
        Map<NavigablePath, FetchBuilder> fetchBuilders;
        this.fetchPath = original.fetchPath;
        this.fetchable = original.fetchable;
        if (original.fetchBuilders.isEmpty()) {
            fetchBuilders = Collections.emptyMap();
        } else {
            fetchBuilders = new HashMap(original.fetchBuilders.size());
            for (Map.Entry<NavigablePath, FetchBuilder> entry : original.fetchBuilders.entrySet()) {
                fetchBuilders.put(entry.getKey(), entry.getValue().cacheKeyInstance());
            }
        }
        this.fetchBuilders = fetchBuilders;
    }

    @Override
    public FetchBuilder cacheKeyInstance() {
        return new ImplicitFetchBuilderEntity(this);
    }

    @Override
    public Fetch buildFetch(FetchParent parent, NavigablePath fetchPath, JdbcValuesMetadata jdbcResultsMetadata, BiFunction<String, String, DynamicFetchBuilderLegacy> legacyFetchResolver, DomainResultCreationState creationState) {
        Fetch fetch = parent.generateFetchableFetch(this.fetchable, fetchPath, this.fetchable.getMappedFetchOptions().getTiming(), false, null, creationState);
        return fetch;
    }

    @Override
    public void visitFetchBuilders(BiConsumer<String, FetchBuilder> consumer) {
        this.fetchBuilders.forEach((k, v) -> consumer.accept(k.getLocalName(), (FetchBuilder)v));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImplicitFetchBuilderEntity that = (ImplicitFetchBuilderEntity)o;
        return this.fetchPath.equals(that.fetchPath) && this.fetchable.equals(that.fetchable) && this.fetchBuilders.equals(that.fetchBuilders);
    }

    public int hashCode() {
        int result = this.fetchPath.hashCode();
        result = 31 * result + this.fetchable.hashCode();
        result = 31 * result + this.fetchBuilders.hashCode();
        return result;
    }

    public String toString() {
        return "ImplicitFetchBuilderEntity(" + this.fetchPath + ")";
    }
}

