/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.share;

import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.server.share.SharePartitionKey;
import org.apache.kafka.timeline.SnapshotRegistry;
import org.apache.kafka.timeline.TimelineHashMap;
import org.apache.kafka.timeline.TimelineLong;

public class ShareCoordinatorOffsetsManager {
    private final TimelineHashMap<SharePartitionKey, Long> offsets;
    private final TimelineLong lastRedundantOffset;

    public ShareCoordinatorOffsetsManager(SnapshotRegistry snapshotRegistry) {
        Objects.requireNonNull(snapshotRegistry);
        this.offsets = new TimelineHashMap(snapshotRegistry, 0);
        this.lastRedundantOffset = new TimelineLong(snapshotRegistry);
        this.lastRedundantOffset.set(Long.MAX_VALUE);
    }

    public void updateState(SharePartitionKey key, long offset) {
        this.lastRedundantOffset.set(Math.min(this.lastRedundantOffset.get(), offset));
        this.offsets.put((Object)key, (Object)offset);
        Optional<Long> redundantOffset = this.findRedundantOffset();
        redundantOffset.ifPresent(arg_0 -> ((TimelineLong)this.lastRedundantOffset).set(arg_0));
    }

    private Optional<Long> findRedundantOffset() {
        if (this.offsets.isEmpty()) {
            return Optional.empty();
        }
        long soFar = Long.MAX_VALUE;
        Iterator iterator = this.offsets.values().iterator();
        while (iterator.hasNext()) {
            long offset = (Long)iterator.next();
            if ((soFar = Math.min(soFar, offset)) != this.lastRedundantOffset.get()) continue;
            return Optional.of(soFar);
        }
        return Optional.of(soFar);
    }

    public Optional<Long> lastRedundantOffset() {
        long value = this.lastRedundantOffset.get();
        if (value <= 0L || value == Long.MAX_VALUE) {
            return Optional.empty();
        }
        return Optional.of(value);
    }

    TimelineHashMap<SharePartitionKey, Long> curState() {
        return this.offsets;
    }
}

