/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shape;

import javajs.util.AU;
import javajs.util.BS;
import org.jmol.atomdata.RadiusData;
import org.jmol.c.PAL;
import org.jmol.c.VDW;
import org.jmol.modelset.Atom;
import org.jmol.shape.Shape;
import org.jmol.util.BSUtil;
import org.jmol.util.C;

public abstract class AtomShape
extends Shape {
    public short mad = (short)-1;
    public short[] mads;
    public short[] colixes;
    public byte[] paletteIDs;
    public boolean isActive;
    private RadiusData rd;
    protected boolean isSet;
    public int monomerCount;
    public BS bsSizeDefault;

    @Override
    public void initShape() {
    }

    @Override
    protected void initModelSet() {
        this.isSet = true;
        int ac = this.ms.ac;
        if (this.mads != null) {
            this.mads = AU.arrayCopyShort(this.mads, ac);
        }
        if (this.colixes != null) {
            this.colixes = AU.arrayCopyShort(this.colixes, ac);
        }
        if (this.paletteIDs != null) {
            this.paletteIDs = AU.arrayCopyByte(this.paletteIDs, ac);
        }
    }

    @Override
    public int getSize(int atomIndex) {
        return this.mads == null ? 0 : this.mads[atomIndex];
    }

    @Override
    protected void setSize(int size, BS bsSelected) {
        this.setSize2(size, bsSelected);
    }

    protected void setSize2(int size, BS bsSelected) {
        if (size == 0) {
            this.setSizeRD(null, bsSelected);
            return;
        }
        if (this.rd == null) {
            this.rd = new RadiusData(null, size, RadiusData.EnumType.SCREEN, null);
        } else {
            this.rd.value = size;
        }
        this.setSizeRD(this.rd, bsSelected);
    }

    @Override
    protected void setSizeRD(RadiusData rd, BS bsSelected) {
        int i0;
        if (!this.isSet) {
            return;
        }
        this.isActive = true;
        boolean isVisible = rd != null && rd.value != 0.0f;
        boolean isAll = bsSelected == null;
        int ac = this.ms.ac;
        int n = i0 = isAll ? ac - 1 : bsSelected.nextSetBit(0);
        if (this.bsSizeSet == null) {
            this.bsSizeSet = BS.newN(ac);
        }
        if (this.mads == null && i0 >= 0) {
            this.mads = new short[ac];
        }
        int i = i0;
        while (i >= 0) {
            this.setSizeRD2(i, rd, isVisible);
            i = isAll ? i - 1 : bsSelected.nextSetBit(i + 1);
        }
    }

    protected void setSizeRD2(int i, RadiusData rd, boolean isVisible) {
        Atom atom = this.ms.at[i];
        this.mads[i] = atom.calculateMad(this.vwr, rd);
        this.bsSizeSet.setBitTo(i, isVisible);
        atom.setShapeVisibility(this.vf, isVisible);
    }

    protected void setPropAS(String propertyName, Object value, BS bs) {
        if ("color" == propertyName) {
            this.isActive = true;
            short colix = C.getColixO(value);
            byte pid = PAL.pidOf(value);
            int n = this.checkColixLength(colix, bs.length());
            int i = bs.nextSetBit(0);
            while (i >= 0 && i < n) {
                this.setColixAndPalette(colix, pid, i);
                i = bs.nextSetBit(i + 1);
            }
            return;
        }
        if ("pymolparams" == propertyName) {
            this.isActive = true;
            Object[] data = (Object[])value;
            short[] colixes = (short[])data[0];
            float[] atrans = (float[])data[1];
            float[] sizes = (float[])data[2];
            RadiusData rd = new RadiusData(null, 0.0f, RadiusData.EnumType.FACTOR, VDW.AUTO);
            if (this.bsColixSet == null) {
                this.bsColixSet = new BS();
            }
            if (this.bsSizeSet == null) {
                this.bsSizeSet = new BS();
            }
            int i0 = bs.nextSetBit(0);
            if (this.mads == null && i0 >= 0) {
                this.mads = new short[this.ms.ac];
            }
            int n = this.checkColixLength(colixes == null ? (short)0 : 4, bs.length());
            int i = i0;
            int pt = 0;
            while (i >= 0 && i < n) {
                float f;
                short colix = colixes == null ? (short)0 : colixes[pt];
                float f2 = f = atrans == null ? 0.0f : atrans[pt];
                if (f > 0.01f) {
                    colix = C.getColixTranslucent3(colix, true, f);
                }
                this.setColixAndPalette(colix, PAL.UNKNOWN.id, i);
                if (sizes != null) {
                    float f3;
                    rd.value = sizes[pt];
                    boolean isVisible = f3 > 0.0f;
                    this.setSizeRD2(i, rd, isVisible);
                }
                i = bs.nextSetBit(i + 1);
                ++pt;
            }
            return;
        }
        if ("translucency" == propertyName) {
            this.isActive = true;
            boolean isTranslucent = value.equals("translucent");
            this.checkColixLength((short)4, this.ms.ac);
            int i = bs.nextSetBit(0);
            while (i >= 0) {
                this.colixes[i] = C.getColixTranslucent3(this.colixes[i], isTranslucent, this.translucentLevel);
                if (isTranslucent) {
                    this.bsColixSet.set(i);
                }
                i = bs.nextSetBit(i + 1);
            }
            return;
        }
        if (propertyName == "deleteModelAtoms") {
            int[] info = (int[])((Object[])value)[2];
            int firstAtomDeleted = info[1];
            int nAtomsDeleted = info[2];
            this.mads = (short[])AU.deleteElements(this.mads, firstAtomDeleted, nAtomsDeleted);
            this.colixes = (short[])AU.deleteElements(this.colixes, firstAtomDeleted, nAtomsDeleted);
            this.paletteIDs = (byte[])AU.deleteElements(this.paletteIDs, firstAtomDeleted, nAtomsDeleted);
            BSUtil.deleteBits(this.bsSizeSet, bs);
            BSUtil.deleteBits(this.bsColixSet, bs);
            return;
        }
        this.setPropS(propertyName, value, bs);
    }

    protected int checkColixLength(short colix, int n) {
        n = Math.min(this.ms.ac, n);
        if (colix == 0) {
            return this.colixes == null ? 0 : this.colixes.length;
        }
        if (this.colixes == null || n > this.colixes.length) {
            this.colixes = AU.ensureLengthShort(this.colixes, n);
            this.paletteIDs = AU.ensureLengthByte(this.paletteIDs, n);
        }
        if (this.bsColixSet == null) {
            this.bsColixSet = BS.newN(this.ms.ac);
        }
        return n;
    }

    protected void setColixAndPalette(short colix, byte paletteID, int atomIndex) {
        if (this.colixes == null) {
            this.checkColixLength((short)-1, this.ms.ac);
        }
        this.colixes[atomIndex] = colix = this.getColixI(colix, paletteID, atomIndex);
        this.bsColixSet.setBitTo(atomIndex, colix != 0 || this.shapeID == 0);
        this.paletteIDs[atomIndex] = paletteID;
    }

    @Override
    public void setAtomClickability() {
        if (!this.isActive) {
            return;
        }
        Atom[] atoms = this.ms.at;
        int i = this.ms.ac;
        while (--i >= 0) {
            Atom atom = atoms[i];
            if (atom == null || (atom.shapeVisibilityFlags & this.vf) == 0 || this.ms.isAtomHidden(i)) continue;
            atom.setClickable(this.vf);
        }
    }

    @Override
    public String getShapeState() {
        return null;
    }
}

