import { AbstractStrategy } from "./strategy";
import type { Request } from "express";
import { AuthenticateOptions, MultiStrategyConfig, RequestWithUser, PassportSamlConfig, VerifyWithoutRequest, VerifyWithRequest } from "./types";
export declare class MultiSamlStrategy extends AbstractStrategy {
    static readonly newSamlProviderOnConstruct = false;
    _options: PassportSamlConfig & MultiStrategyConfig;
    constructor(options: MultiStrategyConfig, signonVerify: VerifyWithRequest, logoutVerify: VerifyWithRequest);
    constructor(options: MultiStrategyConfig, signonVerify: VerifyWithoutRequest, logoutVerify: VerifyWithoutRequest);
    authenticate(req: Request, options: AuthenticateOptions): void;
    logout(req: RequestWithUser, callback: (err: Error | null, url?: string | null | undefined) => void): void;
    generateServiceProviderMetadata(req: Request, decryptionCert: string | null, signingCert: string | string[] | null, callback: (err: Error | null, metadata?: string) => void): void;
    error(err: Error): void;
}
